/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.common.shape.FrameKind;
import gcewing.architecture.common.shape.ShapeKind;
import gcewing.architecture.common.shape.Window;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.Directions;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.util.Utils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class CornerWindow
extends Window {
    public CornerWindow() {
        this.frameSides = new EnumFacing[]{Directions.F_DOWN, Directions.F_SOUTH, Directions.F_UP, Directions.F_WEST};
        this.frameAlways = new boolean[]{false, false, false, false};
        this.frameKinds = new FrameKind[]{FrameKind.Corner, FrameKind.Corner, FrameKind.None, FrameKind.Plain, FrameKind.Plain, FrameKind.None};
        this.frameOrientations = new EnumFacing[]{Directions.F_EAST, Directions.F_EAST, null, Directions.F_UP, Directions.F_UP, null};
        this.frameTrans = new Trans3[]{Trans3.ident, Trans3.ident.rotY(-90.0).rotZ(90.0), Trans3.ident.rotY(-90.0).rotZ(180.0), Trans3.ident.rotZ(270.0)};
    }

    @Override
    protected void addCentreBoxesToList(double r, double s, Trans3 t, List list) {
        t.addBox(-r, -0.5, -r, r, 0.5, r, list);
    }

    @Override
    protected void addFrameBoxesToList(int i, double r, double s, Trans3 ts, List list) {
        if ((i & 1) == 0) {
            ts.addBox(-0.5, -0.5, -s, s, -0.5 + r, s, list);
            ts.addBox(-s, -0.5, -s, s, -0.5 + r, 0.5, list);
        } else {
            super.addFrameBoxesToList(i, r, s, ts, list);
        }
    }

    @Override
    protected void addGlassBoxesToList(double r, double s, double w, double[] e, Trans3 t, List list) {
        t.addBox(-e[3], -e[0], -w, -s, e[2], w, list);
        t.addBox(-w, -e[0], s, w, e[2], e[1], list);
    }

    @Override
    public boolean orientOnPlacement(EntityPlayer player, TileShape te, TileShape nte, EnumFacing face, Vector3 hit) {
        ShapeKind shapeKind;
        if (nte != null && !player.func_70093_af() && (shapeKind = nte.shape.kind) instanceof Window) {
            Window nsk = (Window)shapeKind;
            EnumFacing nlf = nte.localFace(face);
            FrameKind nfk = nsk.frameKindForLocalSide(nlf);
            switch (nfk) {
                case Corner: {
                    te.setSide(nte.side);
                    te.setTurn(nte.turn);
                    return true;
                }
                case Plain: {
                    EnumFacing nfo = nte.globalFace(nsk.frameOrientationForLocalSide(nlf));
                    return this.orientFromAdjacentCorner(te, nfo, hit) || this.orientFromAdjacentCorner(te, Utils.oppositeFacing(nfo), hit);
                }
            }
        }
        return super.orientOnPlacement(player, te, nte, face, hit);
    }

    protected boolean orientFromAdjacentCorner(TileShape te, EnumFacing face, Vector3 hit) {
        EnumFacing nlf;
        Window nsk;
        FrameKind nfk;
        ShapeKind shapeKind;
        TileShape nte = TileShape.get((IBlockAccess)BlockCompatUtils.getTileEntityWorld(te), te.getPos().offset(Utils.oppositeFacing(face)));
        if (nte != null && (shapeKind = nte.shape.kind) instanceof Window && (nfk = (nsk = (Window)shapeKind).frameKindForLocalSide(nlf = nte.localFace(face))) == FrameKind.Corner) {
            te.setSide(nte.side);
            te.setTurn(nte.turn);
            return true;
        }
        return false;
    }
}

