/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.tile;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.shape.ShapePage;
import gcewing.architecture.common.tile.IRestrictedDroppingInventory;
import gcewing.architecture.common.tile.TileArchitectureInventory;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileSawbench
extends TileArchitectureInventory
implements IRestrictedDroppingInventory {
    public static final int materialSlot = 0;
    public static final int resultSlot = 1;
    public static final int[] materialSideSlots = new int[]{0};
    public static final int[] resultSideSlots = new int[]{1};
    public static final boolean allowAutomation = false;
    public static final ShapePage[] pages = new ShapePage[]{new ShapePage("Roofing", Shape.RoofTile, Shape.RoofOuterCorner, Shape.RoofInnerCorner, Shape.RoofRidge, Shape.RoofSmartRidge, Shape.RoofValley, Shape.RoofSmartValley, Shape.RoofOverhang, Shape.RoofOverhangOuterCorner, Shape.RoofOverhangInnerCorner, Shape.RoofOverhangGableLH, Shape.RoofOverhangGableRH, Shape.RoofOverhangGableEndLH, Shape.RoofOverhangGableEndRH, Shape.RoofOverhangRidge, Shape.RoofOverhangValley, Shape.BevelledOuterCorner, Shape.BevelledInnerCorner), new ShapePage("Rounded", Shape.Cylinder, Shape.CylinderHalf, Shape.CylinderQuarter, Shape.CylinderLargeQuarter, Shape.AnticylinderLargeQuarter, Shape.Pillar, Shape.Post, Shape.Pole, Shape.SphereFull, Shape.SphereHalf, Shape.SphereQuarter, Shape.SphereEighth, Shape.SphereEighthLarge, Shape.SphereEighthLargeRev), new ShapePage("Classical", Shape.PillarBase, Shape.Pillar, Shape.DoricCapital, Shape.DoricTriglyph, Shape.DoricTriglyphCorner, Shape.DoricMetope, Shape.IonicCapital, Shape.CorinthianCapital, Shape.Architrave, Shape.ArchitraveCorner, Shape.CorniceLH, Shape.CorniceRH, Shape.CorniceEndLH, Shape.CorniceEndRH, Shape.CorniceRidge, Shape.CorniceValley, Shape.CorniceBottom), new ShapePage("Window", Shape.WindowFrame, Shape.WindowCorner, Shape.WindowMullion), new ShapePage("Arches", Shape.ArchD1, Shape.ArchD2, Shape.ArchD3A, Shape.ArchD3B, Shape.ArchD3C, Shape.ArchD4A, Shape.ArchD4B, Shape.ArchD4C), new ShapePage("Railings", Shape.BalustradePlain, Shape.BalustradePlainOuterCorner, Shape.BalustradePlainInnerCorner, Shape.BalustradePlainWithNewel, Shape.BalustradePlainEnd, Shape.BanisterPlainTop, Shape.BanisterPlain, Shape.BanisterPlainBottom, Shape.BanisterPlainEnd, Shape.BanisterPlainInnerCorner, Shape.BalustradeFancy, Shape.BalustradeFancyCorner, Shape.BalustradeFancyWithNewel, Shape.BalustradeFancyNewel, Shape.BanisterFancyTop, Shape.BanisterFancy, Shape.BanisterFancyBottom, Shape.BanisterFancyEnd, Shape.BanisterFancyNewelTall), new ShapePage("Other", Shape.CladdingSheet, Shape.Slab, Shape.Stairs, Shape.StairsOuterCorner, Shape.StairsInnerCorner, Shape.SlopeTileA1, Shape.SlopeTileA2, Shape.SlopeTileB1, Shape.SlopeTileB2, Shape.SlopeTileB3, Shape.SlopeTileC1, Shape.SlopeTileC2, Shape.SlopeTileC3, Shape.SlopeTileC4, Shape.AngledRoofRidge, Shape.DoubleRoofTile), new ShapePage("Glow", Shape.SquareSE, Shape.SlabSE, Shape.RoofTileSE, Shape.SlopeTileA1SE, Shape.SlopeTileA2SE, Shape.SlopeTileB1SE, Shape.SlopeTileB2SE, Shape.SlopeTileB3SE, Shape.SlopeTileC1SE, Shape.SlopeTileC2SE, Shape.SlopeTileC3SE, Shape.SlopeTileC4SE)};
    public final IInventory inventory = new InventoryBasic("Items", false, 2);
    public int selectedPage = 0;
    public final int[] selectedSlots = new int[pages.length];
    public boolean pendingMaterialUsage = false;
    private static final List<String> acceptableMaterialsFromConfig = Arrays.asList(ArchitectureCraft.mod.config.get("materials", "UnlocalizedNames", new String[]{"tile.chisel.stained_glass", "tile.extrautils:greenscreen"}).getStringList());

    public Shape getSelectedShape() {
        int slot;
        if (this.isSelectedPageInRange() && (slot = this.selectedSlots[this.selectedPage]) >= 0 && slot < pages[this.selectedPage].size()) {
            return pages[this.selectedPage].get(slot);
        }
        return null;
    }

    public int getSelectedPageIndex() {
        if (this.isSelectedPageInRange()) {
            return this.selectedPage;
        }
        return -1;
    }

    public int getSelectedShapeIndex() {
        if (this.isSelectedPageInRange()) {
            return this.selectedSlots[this.selectedPage];
        }
        return -1;
    }

    private boolean isSelectedPageInRange() {
        return this.selectedPage >= 0 && this.selectedPage < pages.length;
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        this.updateResultSlot();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == 1) {
            this.usePendingMaterial();
        }
        ItemStack result = super.func_70298_a(slot, amount);
        this.updateResultSlot();
        return result;
    }

    public ItemStack usePendingMaterial() {
        ItemStack origMaterialStack = this.func_70301_a(0);
        if (this.pendingMaterialUsage) {
            this.pendingMaterialUsage = false;
            this.inventory.func_70298_a(0, this.materialMultiple());
        }
        return origMaterialStack;
    }

    public void returnUnusedMaterial(ItemStack origMaterialStack) {
        if (!this.pendingMaterialUsage) {
            ItemStack materialStack = this.func_70301_a(0);
            ItemStack resultStack = this.func_70301_a(1);
            int m = this.materialMultiple();
            int n = this.resultMultiple();
            if (resultStack != null && resultStack.field_77994_a == n) {
                if (materialStack != null) {
                    materialStack.field_77994_a += m;
                } else {
                    materialStack = origMaterialStack;
                    materialStack.field_77994_a = m;
                }
                this.inventory.func_70299_a(0, materialStack);
                this.pendingMaterialUsage = true;
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return materialSideSlots;
        }
        return resultSideSlots;
    }

    @Override
    public void func_145839_a(NBTTagCompound tc) {
        super.func_145839_a(tc);
        this.selectedPage = tc.func_74762_e("Page");
        int[] ss = tc.func_74759_k("Slots");
        if (ss != null) {
            for (int page = 0; page < pages.length; ++page) {
                int slot = page < ss.length ? ss[page] : 0;
                this.selectedSlots[page] = slot >= 0 && slot < pages[page].size() ? slot : 0;
            }
        }
        this.pendingMaterialUsage = tc.func_74767_n("PMU");
    }

    @Override
    public void func_145841_b(NBTTagCompound tc) {
        super.func_145841_b(tc);
        tc.func_74768_a("Page", this.selectedPage);
        tc.func_74783_a("Slots", this.selectedSlots);
        tc.func_74757_a("PMU", this.pendingMaterialUsage);
    }

    public void setSelectedShape(int page, int slot) {
        if (page >= 0 && page < pages.length) {
            this.selectedPage = page;
            if (slot >= 0 && slot < pages[this.selectedPage].size()) {
                this.selectedSlots[this.selectedPage] = slot;
                this.func_70296_d();
                this.updateResultSlot();
                ArchitectureCraft.sendTileEntityUpdate(this);
            }
        }
    }

    public void updateResultSlot() {
        ItemStack oldResult = this.func_70301_a(1);
        if (oldResult == null || this.pendingMaterialUsage) {
            ItemStack resultStack = this.makeResultStack();
            if (!ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)oldResult)) {
                this.inventory.func_70299_a(1, resultStack);
            }
            this.pendingMaterialUsage = resultStack != null;
        }
    }

    protected ItemStack makeResultStack() {
        Block materialBlock;
        Item materialItem;
        ItemStack materialStack;
        boolean shaderEmissive;
        Shape resultShape = this.getSelectedShape();
        boolean bl = shaderEmissive = this.getSelectedPageIndex() == 7;
        if (resultShape != null && (materialStack = this.func_70301_a(0)) != null && materialStack.field_77994_a >= resultShape.materialUsed && (materialItem = materialStack.func_77973_b()) instanceof ItemBlock && this.isAcceptableMaterial(materialBlock = Block.func_149634_a((Item)materialItem))) {
            return resultShape.kind.newStack(resultShape, materialBlock, materialStack.func_77960_j(), resultShape.itemsProduced, shaderEmissive);
        }
        return null;
    }

    protected boolean isAcceptableMaterial(Block block) {
        if (block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block instanceof BlockSlab || acceptableMaterialsFromConfig.contains(block.func_149739_a())) {
            return true;
        }
        return block.func_149686_d() && !block.func_149716_u();
    }

    public int materialMultiple() {
        Shape shape;
        Block materialBlock;
        int factor = 1;
        ItemStack materialStack = this.func_70301_a(0);
        if (materialStack != null && (materialBlock = Block.func_149634_a((Item)materialStack.func_77973_b())) instanceof BlockSlab) {
            factor = 2;
        }
        if ((shape = this.getSelectedShape()) != null) {
            return factor * shape.materialUsed;
        }
        return 0;
    }

    public int resultMultiple() {
        Shape shape = this.getSelectedShape();
        if (shape != null) {
            return shape.itemsProduced;
        }
        return 0;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (side == 0) {
            return false;
        }
        return slot == 0;
    }

    @Override
    public int[] getDroppingSlots() {
        return materialSideSlots;
    }
}

