/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.chat;

import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ServerChatEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.chat.ChatHandlerEiraIRC;
import pl.asie.lib.chat.CommandMe;
import pl.asie.lib.chat.CommandNick;
import pl.asie.lib.chat.CommandRealname;
import pl.asie.lib.chat.CommandSpy;
import pl.asie.lib.reference.Mods;
import pl.asie.lib.util.ChatUtils;

public class ChatHandler {
    private final HashMap<String, String> actions = new HashMap();
    public final boolean enableChatFeatures;
    public final boolean enableShout;
    public final boolean enableGreentext;
    public final boolean enableColor;
    public final boolean enableChatLog;
    public final boolean spyOnByDefault;
    public final int CHAT_RADIUS;
    public final int nickLevel;
    public final int realnameLevel;
    public final String colorAction;
    public final String messageFormat;
    public final String shoutPrefix;
    public final Logger chatlog;

    public ChatHandler(Configuration config) {
        this.CHAT_RADIUS = config.get("chat", "chatRadius", 0).getInt();
        this.spyOnByDefault = config.get("chat", "spyOnByDefault", true, "Admins will have spy mode on by default after connecting. (Only matters if chatRadius > 0)").getBoolean(true);
        this.enableShout = config.get("chat", "enableShout", true).getBoolean(true);
        this.shoutPrefix = config.get("chat", "shoutPrefix", "[Shout]").getString();
        this.enableChatFeatures = config.get("base", "enableChatTweaks", false).getBoolean(false);
        this.enableColor = config.get("base", "enableColor", true).getBoolean(true);
        this.enableGreentext = config.get("chat", "enableGreentext", false, ">implying anyone will ever turn this on").getBoolean(false);
        this.nickLevel = config.get("chat", "nicknamesForEveryone", true, "Disable to make changing the own nickname require Op rights on a server").getBoolean(true) ? 0 : 2;
        this.realnameLevel = config.get("chat", "realnamesForEveryone", true, "Disable to make looking up the real name of others require Op rights on a server").getBoolean(true) ? 0 : 2;
        this.colorAction = config.get("chat", "colorMe", "5").getString();
        this.messageFormat = config.get("chat", "formatMessage", "<%u> %m", "%u - username; %m - message; %w - dimension; %H - hours; %M - minutes; %S - seconds").getString();
        this.enableChatLog = config.get("chat", "chatLog", true, "Enable this to log server chat to console").getBoolean(true);
        this.chatlog = LogManager.getLogger((String)"Chat");
    }

    public void registerCommands(FMLServerStartingEvent event) {
        if (this.enableChatFeatures) {
            event.registerServerCommand((ICommand)new CommandMe());
            event.registerServerCommand((ICommand)new CommandNick());
            event.registerServerCommand((ICommand)new CommandRealname());
            if (this.CHAT_RADIUS > 0) {
                event.registerServerCommand((ICommand)new CommandSpy());
            }
        }
    }

    private static String pad(int t) {
        if (t < 10) {
            return "0" + t;
        }
        return "" + t;
    }

    @SubscribeEvent
    public void loggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.func_70003_b(2, "spy") && this.spyOnByDefault) {
            CommandSpy.SPYING_USERS.add(event.player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void loggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        CommandSpy.SPYING_USERS.remove(event.player.func_70005_c_());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void chatEvent(ServerChatEvent event) {
        IChatComponent chat;
        if (this.CHAT_RADIUS < 0) {
            event.setCanceled(true);
            return;
        }
        IChatComponent chatSpy = null;
        boolean disableRadius = false;
        String username = ChatUtils.color(AsieLibMod.nick.getNickname(event.username)) + EnumChatFormatting.RESET;
        String message = event.message;
        int dimensionId = event.player.field_70170_p.field_73011_w.field_76574_g;
        if (this.enableShout && event.message.startsWith("!")) {
            message = message.substring(1);
        }
        if (this.enableGreentext && message.startsWith(">")) {
            message = EnumChatFormatting.GREEN + message;
        }
        Calendar now = Calendar.getInstance();
        String formattedMessage = EnumChatFormatting.RESET + this.messageFormat;
        try {
            formattedMessage = formattedMessage.replaceAll("%u", username).replaceAll("%m", message).replaceAll("%w", event.player.field_70170_p.field_73011_w.func_80007_l()).replaceAll("%H", ChatHandler.pad(now.get(11))).replaceAll("%M", ChatHandler.pad(now.get(12))).replaceAll("%S", ChatHandler.pad(now.get(13)));
        }
        catch (Exception e) {
            e.printStackTrace();
            formattedMessage = EnumChatFormatting.RESET + "<" + username + "" + EnumChatFormatting.RESET + "> " + message;
        }
        if (this.enableColor) {
            try {
                formattedMessage = ChatUtils.color(formattedMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.enableShout && event.message.startsWith("!")) {
            chat = ForgeHooks.newChatWithLinks((String)(EnumChatFormatting.YELLOW + this.shoutPrefix + " " + formattedMessage));
            disableRadius = true;
        } else {
            chat = ForgeHooks.newChatWithLinks((String)formattedMessage);
            chatSpy = ForgeHooks.newChatWithLinks((String)(EnumChatFormatting.GRAY + "[Spy] " + formattedMessage));
        }
        boolean useRadius = this.CHAT_RADIUS > 0 && !disableRadius;
        event.setCanceled(true);
        if (!useRadius && Mods.API.hasAPI("EiraIRC|API")) {
            ChatHandlerEiraIRC.eiraircRelay(event.player, username, message);
        }
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        if (this.enableChatLog) {
            this.chatlog.info(ChatUtils.stripColors(formattedMessage));
        }
        for (WorldServer ws : MinecraftServer.func_71276_C().field_71305_c) {
            for (Object o : ws.field_73010_i) {
                if (!(o instanceof EntityPlayer)) continue;
                EntityPlayer target = (EntityPlayer)o;
                if ((!useRadius || event.player == target || event.player.func_70032_d((Entity)target) <= (float)this.CHAT_RADIUS) && ws.field_73011_w.field_76574_g == dimensionId) {
                    target.func_145747_a(chat);
                    continue;
                }
                if (chatSpy == null || !CommandSpy.SPYING_USERS.contains(target.func_70005_c_())) continue;
                target.func_145747_a(chatSpy);
            }
        }
    }

    public static List addTabUsernameCompletionOptions(String[] args) {
        if (args == null || args.length < 1) {
            return null;
        }
        String[] names = (String[])MinecraftServer.func_71276_C().func_71213_z().clone();
        if (AsieLibMod.nick != null && AsieLibMod.nick.nicknames != null) {
            for (int i = 0; i < names.length; ++i) {
                names[i] = AsieLibMod.nick.getNickname(names[i]);
            }
        }
        return CommandBase.func_71530_a((String[])args, (String[])names);
    }
}

