/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.tile;

import net.minecraft.nbt.NBTTagCompound;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.api.tile.IBattery;

public class BatteryBasic
implements IBattery {
    private double energy;
    private double maxEnergy;
    private double maxInsert;
    private double maxExtract;
    private double[] averageUsage = new double[8];
    private double lastEnergy = 0.0;
    private double peakEnergyUsage = 0.0;
    private byte avgUsPtr = (byte)-1;

    public BatteryBasic(double maxEng, double maxExt, double maxIns) {
        this.maxEnergy = maxEng;
        this.maxInsert = maxExt;
        this.maxExtract = maxIns;
    }

    public BatteryBasic(double maxEng, double maxIO) {
        this(maxEng, maxIO, maxIO);
    }

    public BatteryBasic(double maxEng) {
        this(maxEng, maxEng, maxEng);
    }

    @Override
    public double insert(int side, double maximum, boolean simulate) {
        if (maximum > this.maxInsert) {
            maximum = this.maxInsert;
        }
        if (this.energy + maximum > this.maxEnergy) {
            if (!simulate) {
                this.energy = this.maxEnergy;
            }
            return this.maxEnergy - this.energy;
        }
        if (!simulate) {
            this.energy += maximum;
        }
        return maximum;
    }

    @Override
    public double extract(int side, double maximum, boolean simulate) {
        double amount = Math.min(this.energy, Math.min(maximum, this.maxExtract));
        if (!simulate) {
            this.energy -= amount;
        }
        return amount;
    }

    @Override
    public double getEnergyStored() {
        return this.energy;
    }

    @Override
    public double getMaxEnergyStored() {
        return this.maxEnergy;
    }

    @Override
    public double getMaxEnergyInserted() {
        return this.maxInsert;
    }

    @Override
    public double getMaxEnergyExtracted() {
        return this.maxExtract;
    }

    @Override
    public boolean canInsert(int side, String type) {
        return this.maxInsert > 0.0;
    }

    @Override
    public boolean canExtract(int side, String type) {
        return this.maxExtract > 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("bb_energy")) {
            this.energy = tag.func_74769_h("bb_energy");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("bb_energy", this.energy);
    }

    @Override
    public void onTick() {
        if (!AsieLibMod.ENABLE_DYNAMIC_ENERGY_CALCULATION) {
            return;
        }
        if (this.avgUsPtr == -1) {
            this.lastEnergy = this.energy;
            this.avgUsPtr = (byte)(this.avgUsPtr + 1);
        } else {
            double p = this.energy - this.lastEnergy;
            this.lastEnergy = this.energy;
            if (p > this.peakEnergyUsage) {
                this.peakEnergyUsage = p;
            }
            byte by = this.avgUsPtr;
            this.avgUsPtr = (byte)(by + 1);
            this.averageUsage[by] = p;
            this.avgUsPtr = (byte)(this.avgUsPtr & 7);
        }
    }

    @Override
    public double getEnergyUsage() {
        double z = 0.0;
        for (int i = 0; i < 8; ++i) {
            z += this.averageUsage[i];
        }
        return z / 8.0;
    }

    @Override
    public double getMaxEnergyUsage() {
        return this.peakEnergyUsage;
    }
}

