/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import tuhljin.automagy.gui.ContainerPortableArcaneCrafting;
import tuhljin.automagy.gui.ModGuiContainer;
import tuhljin.automagy.items.ItemFocusCrafting;

public class GUIPortableArcaneCrafting
extends ModGuiContainer {
    public final ResourceLocation texture;
    private ContainerPortableArcaneCrafting container;
    private float craftAlpha = 0.138f;
    private boolean lastVisInsufficient = false;
    private boolean usingStaff = false;
    private int[][] aspectLocs = new int[][]{{72, 21}, {24, 43}, {24, 102}, {72, 124}, {120, 102}, {120, 43}};
    ArrayList<Aspect> primals = Aspect.getPrimalAspects();
    private InventoryPlayer ip;

    private GUIPortableArcaneCrafting(ContainerPortableArcaneCrafting container, EntityPlayer player) {
        super(container);
        this.container = container;
        this.ip = player.field_71071_by;
        this.texture = new ResourceLocation("Automagy:textures/gui/focusCrafting.png");
        this.field_146999_f = 190;
        this.field_147000_g = 206;
        this.usingStaff = container.craftingInv.func_70301_a(10) == null;
    }

    public GUIPortableArcaneCrafting(EntityPlayer player, int wandSlot) {
        this(new ContainerPortableArcaneCrafting(player, wandSlot), player);
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        if (this.craftAlpha < 2.0f) {
            this.craftAlpha += this.craftAlpha < 1.0f ? 0.01f : 0.005f;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        int x = 135;
        int y = 135;
        int offY = -6;
        int invExtraOffY = -6;
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + offY, x, 0, this.field_146999_f - x, y);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + y + offY + invExtraOffY, 0, y, this.field_146999_f, this.field_147000_g - y - offY - invExtraOffY + 6);
        if (this.craftAlpha < 1.0f) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(this.craftAlpha, 1.0f));
            this.func_73729_b(this.field_147003_i, this.field_147009_r + offY, 0, 0, x, y);
        } else {
            float r = this.interpolate(1.0f, 0.5f, this.craftAlpha - 1.0f);
            float g = this.interpolate(1.0f, 0.8f, this.craftAlpha - 1.0f);
            float b = this.interpolate(1.0f, 0.5f, this.craftAlpha - 1.0f);
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            this.func_73729_b(this.field_147003_i, this.field_147009_r + offY, 0, 0, x, y);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.func_73729_b(this.field_147003_i + 15 + this.container.blockedSlotHotbarPos * 18, this.field_147009_r + 187, 0, this.field_147000_g + 18, this.container.blockedSlotHotbarPos == 8 ? 18 : 17, 18);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(offY + invExtraOffY + 1), (float)0.0f);
        this.drawRecipeResultsAndAspects();
        GL11.glPopMatrix();
        super.func_146976_a(var1, var2, var3);
    }

    private float interpolate(float a, float b, float interpolationFactor) {
        return tuhljin.automagy.codechicken.lib.math.MathHelper.interpolate(a, b, interpolationFactor);
    }

    private void drawRecipeResultsAndAspects() {
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        ItemWandCasting wand = null;
        if (this.container.craftingInv.func_70301_a(10) != null && this.container.craftingInv.func_70301_a(10).func_77973_b() instanceof ItemWandCasting) {
            wand = (ItemWandCasting)this.container.craftingInv.func_70301_a(10).func_77973_b();
        }
        AspectList cost = null;
        if (ThaumcraftCraftingManager.findMatchingArcaneRecipe((IInventory)this.container.fakeTile, (EntityPlayer)this.ip.field_70458_d) != null) {
            AspectList extraCost = this.getExtraVisCostForPortable(wand, this.container.craftingInv.func_70301_a(10));
            cost = ThaumcraftCraftingManager.findMatchingArcaneRecipeAspects((IInventory)this.container.fakeTile, (EntityPlayer)this.ip.field_70458_d);
            int count = 0;
            for (Aspect primal : this.primals) {
                float amt = cost.getAmount(primal);
                float extraAmt = extraCost.getAmount(primal);
                if (cost.getAmount(primal) > 0 || extraAmt > 0.0f) {
                    float alpha = 0.5f + (MathHelper.func_76126_a((float)((float)(this.ip.field_70458_d.field_70173_aa + count * 10) / 2.0f)) * 0.2f - 0.2f);
                    if (wand != null) {
                        if ((amt += extraAmt / 100.0f) > 0.0f) {
                            amt *= wand.getConsumptionModifier(this.container.craftingInv.func_70301_a(10), this.ip.field_70458_d, primal, true);
                        }
                        if (amt * 100.0f <= (float)wand.getVis(this.container.craftingInv.func_70301_a(10), primal)) {
                            alpha = 1.0f;
                        }
                    }
                    UtilsFX.drawTag((int)(var5 + this.aspectLocs[count][0] - 8), (int)(var6 + this.aspectLocs[count][1] - 8), (Aspect)primal, (float)amt, (int)0, (double)this.field_73735_i, (int)771, (float)alpha, (boolean)false);
                }
                if (++count <= 5) continue;
                break;
            }
        }
        if (wand != null && cost != null && !wand.consumeAllVisCrafting(this.container.craftingInv.func_70301_a(10), this.ip.field_70458_d, cost, false)) {
            GL11.glPushMatrix();
            float var40 = 0.33f;
            GL11.glColor4f((float)var40, (float)var40, (float)var40, (float)0.66f);
            GUIPortableArcaneCrafting.field_146296_j.field_77024_a = false;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3042);
            field_146296_j.func_82406_b(this.field_146297_k.field_71466_p, this.field_146297_k.field_71446_o, ThaumcraftCraftingManager.findMatchingArcaneRecipe((IInventory)this.container.fakeTile, (EntityPlayer)this.ip.field_70458_d), var5 + 160, var6 + 64);
            field_146296_j.func_77021_b(this.field_146297_k.field_71466_p, this.field_146297_k.field_71446_o, ThaumcraftCraftingManager.findMatchingArcaneRecipe((IInventory)this.container.fakeTile, (EntityPlayer)this.ip.field_70458_d), var5 + 160, var6 + 64);
            GUIPortableArcaneCrafting.field_146296_j.field_77024_a = true;
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2896);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(var5 + 168), (float)(var6 + 46), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
            String text = StatCollector.func_74838_a((String)"Automagy.gui.focusCrafting.visLow");
            int ll = this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, -ll, 0, 0xEE6E6E);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            if (!this.lastVisInsufficient) {
                this.lastVisInsufficient = true;
                this.container.func_75130_a(this.container.craftingInv);
            }
        } else if (this.lastVisInsufficient) {
            this.lastVisInsufficient = false;
        } else if (this.usingStaff) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)(var5 + 168), (float)(var6 + 46), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
            String text = StatCollector.func_74838_a((String)"Automagy.gui.focusCrafting.staff.1");
            int ll = this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, -ll, -3, 0xEE6E6E);
            text = StatCollector.func_74838_a((String)"Automagy.gui.focusCrafting.staff.2");
            ll = this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, -ll, 5, 0xEE6E6E);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void buttonClicked(GuiButton button, boolean rightClick) {
    }

    public AspectList getExtraVisCostForPortable(ItemWandCasting wand, ItemStack wandstack) {
        ItemFocusCrafting focus = ItemFocusCrafting.getCraftingFocusOnWand(wandstack);
        AspectList extraCost = focus == null ? ItemFocusCrafting.visCost : focus.getVisCost(wand.getFocusItem(wandstack));
        return extraCost;
    }
}

