/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ChestGenHooks;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.compat.CompatibilityManager;

public class AutomagyWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (AutomagyConfig.netherSpireChance > 0 && world.field_73011_w.field_76574_g == -1 && random.nextInt(AutomagyConfig.netherSpireChance) == 0) {
            this.tryGenerateNetherSpire(random, chunkX, chunkZ, world);
        }
    }

    public void tryGenerateNetherSpire(Random rand, int chunkX, int chunkZ, World world) {
        int areaWidth = 10;
        int airHeight = 30;
        int minLavaHeight = 3;
        int x = chunkX * 16 + rand.nextInt(16 - areaWidth);
        int z = chunkZ * 16 + rand.nextInt(16 - areaWidth);
        int y = this.getYAboveLavaPool(world, x, z, minLavaHeight, areaWidth, 1);
        while (y > 0) {
            boolean allAir = true;
            for (int y2 = y; y2 < y + airHeight; ++y2) {
                if (this.airInArea(world, x, y2, z, areaWidth)) continue;
                y = this.getYAboveLavaPool(world, x, z, minLavaHeight, areaWidth, y + 1);
                allAir = false;
                break;
            }
            if (!allAir) continue;
            break;
        }
        if (y > 0) {
            int heightAbove = airHeight - 17 - rand.nextInt(5);
            for (int x2 = x + 3; x2 < x + 6; ++x2) {
                for (int z2 = z + 3; z2 < z + 6; ++z2) {
                    this.createObsidianColumn(rand, world, x2, y, z2, heightAbove);
                }
            }
            this.createObsidianColumn(rand, world, x + 4, y, z + 2, heightAbove);
            this.createObsidianColumn(rand, world, x + 6, y, z + 4, heightAbove);
            this.createObsidianColumn(rand, world, x + 4, y, z + 6, heightAbove);
            this.createObsidianColumn(rand, world, x + 2, y, z + 4, heightAbove);
            this.createFieryTotem(rand, world, x + 3, y + heightAbove, z + 3, 5);
            this.createFieryTotem(rand, world, x + 3, y + heightAbove, z + 5, 5);
            this.createFieryTotem(rand, world, x + 5, y + heightAbove, z + 3, 5);
            this.createFieryTotem(rand, world, x + 5, y + heightAbove, z + 5, 5);
            this.createFieryTotem(rand, world, x + 4, y + heightAbove + 3, z + 4, 5);
            this.createFieryTotem(rand, world, x + 4, y + heightAbove, z + 3, 2);
            this.createFieryTotem(rand, world, x + 3, y + heightAbove, z + 4, 2);
            this.createFieryTotem(rand, world, x + 5, y + heightAbove, z + 4, 2);
            this.createFieryTotem(rand, world, x + 4, y + heightAbove, z + 5, 2);
            this.createFieryNode(rand, world, x + 4, y + heightAbove + 2, z + 4);
            world.func_147465_d(x + 4, y + heightAbove + 1, z + 4, Blocks.field_150474_ac, 0, 3);
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(x + 4, y + heightAbove + 1, z + 4);
            if (spawner != null) {
                spawner.func_145881_a().func_98272_a("Automagy.WispNether");
            }
            this.generateDungeonChest(rand, world, x + 4, y + heightAbove, z + 4, true);
        }
    }

    private int getYAboveLavaPool(World world, int x, int z, int minLavaHeight, int minLavaWidth, int startY) {
        int maxY = world.func_72940_L() - 20;
        int lavaCount = 0;
        for (int y = startY; y < maxY; ++y) {
            if (this.lavaInArea(world, x, y, z, minLavaWidth)) {
                ++lavaCount;
                continue;
            }
            if (lavaCount >= minLavaHeight && world.func_147437_c(x, y, z)) {
                return y;
            }
            lavaCount = 0;
        }
        return -1;
    }

    private boolean lavaInArea(World world, int x, int y, int z, int width) {
        int maxX = x + width;
        int maxZ = z + width;
        int startZ = z;
        while (x < maxX) {
            for (z = startZ; z < maxZ; ++z) {
                if (world.func_147439_a(x, y, z) == Blocks.field_150353_l) continue;
                return false;
            }
            ++x;
        }
        return true;
    }

    private boolean airInArea(World world, int x, int y, int z, int width) {
        int maxX = x + width;
        int maxZ = z + width;
        int startZ = z;
        while (x < maxX) {
            for (z = startZ; z < maxZ; ++z) {
                if (world.func_147437_c(x, y, z)) continue;
                return false;
            }
            ++x;
        }
        return true;
    }

    private void createObsidianColumn(Random rand, World world, int x, int y, int z, int heightAbove) {
        Block block;
        int y2;
        for (y2 = y - 1; y2 > 0 && world.func_147439_a(x, y2, z).func_149688_o() == Material.field_151587_i; --y2) {
            if (rand.nextInt(10) == 0) {
                if (rand.nextInt(4) == 0) {
                    world.func_147465_d(x, y2, z, (Block)ModBlocks.runedObsidian, rand.nextInt(6), 3);
                    continue;
                }
                world.func_147465_d(x, y2, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                continue;
            }
            world.func_147449_b(x, y2, z, Blocks.field_150343_Z);
        }
        for (int deep = 3; deep > 0 && y2 > 0 && ((block = world.func_147439_a(x, y2, z)) == Blocks.field_150424_aL || block == Blocks.field_150425_aM || block == Blocks.field_150351_n); --deep, --y2) {
            world.func_147449_b(x, y2, z, Blocks.field_150343_Z);
        }
        for (y2 = y; y2 < y + heightAbove; ++y2) {
            if (rand.nextInt(10) == 0) {
                if (rand.nextInt(4) == 0) {
                    world.func_147465_d(x, y2, z, (Block)ModBlocks.runedObsidian, rand.nextInt(6), 3);
                    continue;
                }
                world.func_147465_d(x, y2, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                continue;
            }
            world.func_147449_b(x, y2, z, Blocks.field_150343_Z);
        }
    }

    private void createFieryTotem(Random rand, World world, int x, int y, int z, int height) {
        int y2;
        for (y2 = y; y2 < y + height - 2; ++y2) {
            world.func_147449_b(x, y2, z, ConfigBlocks.blockCosmeticSolid);
        }
        world.func_147465_d(x, y2, z, (Block)ModBlocks.runedObsidian, rand.nextInt(6), 3);
        world.func_147449_b(x, y2 + 1, z, (Block)Blocks.field_150480_ab);
    }

    private void createFieryNode(Random rand, World world, int x, int y, int z) {
        int a;
        BiomeGenBase bg = world.func_72807_a(x, z);
        int baura = BiomeHandler.getBiomeAura((BiomeGenBase)bg);
        int value = rand.nextInt(baura / 2) + baura / 2;
        AspectList al = new AspectList();
        al.add(Aspect.FIRE, 2);
        if (rand.nextBoolean()) {
            al.merge(Aspect.DEATH, 1);
        } else {
            al.merge(Aspect.UNDEAD, 1);
        }
        if (rand.nextBoolean()) {
            al.merge(Aspect.DARKNESS, 1);
        }
        if (CompatibilityManager.ForbiddenMagicAspect.NETHER != null) {
            al.merge(CompatibilityManager.ForbiddenMagicAspect.NETHER, 1);
        }
        int[] spread = new int[al.size()];
        float total = 0.0f;
        for (a = 0; a < spread.length; ++a) {
            spread[a] = al.getAmount(al.getAspectsSorted()[a]) == 2 ? 50 + rand.nextInt(25) : 25 + rand.nextInt(50);
            total += (float)spread[a];
        }
        for (a = 0; a < spread.length; ++a) {
            al.merge(al.getAspectsSorted()[a], (int)((float)spread[a] / total * (float)value));
        }
        if (al.getAmount(Aspect.FIRE) < 50) {
            al.add(Aspect.FIRE, rand.nextInt(20) + 20);
        }
        ThaumcraftWorldGenerator.createNodeAt((World)world, (int)x, (int)y, (int)z, (NodeType)NodeType.DARK, (NodeModifier)NodeModifier.BRIGHT, (AspectList)al);
    }

    private void generateDungeonChest(Random rand, World world, int x, int y, int z, boolean bonusAutomagyItems) {
        ChestGenHooks info1 = ChestGenHooks.getInfo((String)"dungeonChest");
        ChestGenHooks info2 = ChestGenHooks.getInfo((String)"dungeonChest");
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 3);
        TileEntityChest chest = (TileEntityChest)world.func_147438_o(x, y, z);
        if (chest != null) {
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info1.getItems(rand), (IInventory)chest, (int)info1.getCount(rand));
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info2.getItems(rand), (IInventory)chest, (int)info2.getCount(rand));
        }
        if (bonusAutomagyItems) {
            ItemStack loot;
            ItemStack loot2 = null;
            int r = rand.nextInt(10);
            if (r < 4) {
                loot = new ItemStack((Item)ModItems.avaricePearl, rand.nextInt(2) + 2, 0);
            } else if (r < 7) {
                if (rand.nextBoolean()) {
                    loot = new ItemStack((Item)ModItems.enchantedPaper, rand.nextInt(4) + 8, 0);
                    loot2 = new ItemStack((Item)ModItems.enchantedPaper, rand.nextInt(2) + 1, 3);
                } else {
                    loot = new ItemStack((Item)ModItems.enchantedPaper, rand.nextInt(4) + 3, 3);
                    loot2 = new ItemStack((Item)ModItems.enchantedPaper, rand.nextInt(3) + 2, 0);
                }
            } else if (r < 9) {
                loot = new ItemStack((Item)ModItems.shardSliver, rand.nextInt(6) + 5, 1);
            } else {
                loot = new ItemStack((Item)ModItems.edible);
                loot2 = new ItemStack((Item)ModItems.avaricePearl, rand.nextInt(1) + 1, 0);
            }
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                if (chest.func_70301_a(i) != null) continue;
                chest.func_70299_a(i, loot);
                if (loot2 == null) break;
                loot = loot2;
                loot2 = null;
            }
        }
    }
}

