/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectSourceHelper;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.entities.EntityAICharmWalk;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityMobLure
extends ModTileEntity {
    public static int VERTICAL_CALC_FREQUENCY = 60;
    public static int CHARM_FREQUENCY = 2;
    public static double RANGE_HORIZONTAL = 8.5;
    public static double RANGE_HORIZONTAL_BOOSTED = 32.5;
    public static int RANGE_BOOST_TIME = 400;
    public static int MIN_TOTEM_BLOCKS = 2;
    public static int MAX_TOTEM_BLOCKS_EACHDIR = 4;
    public static WeakHashMap<UUID, Integer> secondaryCharmedEntitiesStrength = new WeakHashMap();
    public static WeakHashMap<UUID, Long> secondaryCharmedEntitiesTime = new WeakHashMap();
    public static WeakHashMap<UUID, WorldSpecificCoordinates> secondaryCharmedEntitiesCoord = new WeakHashMap();
    public static HashMap<Integer, HashSet<BlockCoord>> lureLocations = new HashMap();
    private boolean addedToMap = false;
    public int numTotemBlocks;
    public int yTop;
    public int yBottom;
    public int nextVerticalCalc;
    public int nextCharm = 0;
    public int timeRangeUp = 0;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.isEnabled()) {
            if (!this.addedToMap) {
                HashSet<Object> bcs;
                int dimension = this.field_145850_b.field_73011_w.field_76574_g;
                if (lureLocations.containsKey(dimension)) {
                    bcs = lureLocations.get(dimension);
                } else {
                    bcs = new HashSet();
                    lureLocations.put(dimension, bcs);
                }
                bcs.add(new BlockCoord(this));
                this.addedToMap = true;
                this.nextCharm = this.field_145850_b.field_73012_v.nextInt(CHARM_FREQUENCY + 5) + 1;
            }
            int prevTimeRangeUp = this.timeRangeUp;
            if (this.timeRangeUp > 0) {
                --this.timeRangeUp;
            }
            --this.nextVerticalCalc;
            if (this.nextVerticalCalc < 1 && !this.calcVerticalLimits()) {
                this.tryDisable();
                return;
            }
            --this.nextCharm;
            if (this.nextCharm < 1) {
                if (this.timeRangeUp == 0 && AspectSourceHelper.drainEssentia((TileEntity)this, (Aspect)Aspect.HUNGER, (ForgeDirection)ForgeDirection.UNKNOWN, (int)8)) {
                    this.timeRangeUp = RANGE_BOOST_TIME;
                }
                this.charmNearbyEntities();
                this.nextCharm = CHARM_FREQUENCY;
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    ++this.nextCharm;
                }
            }
            if (prevTimeRangeUp < 1) {
                if (this.timeRangeUp > 0) {
                    this.func_70296_d();
                } else if (prevTimeRangeUp != this.timeRangeUp) {
                    this.markDirty(false);
                }
            } else if (this.timeRangeUp < 1) {
                this.func_70296_d();
            } else if (prevTimeRangeUp != this.timeRangeUp) {
                this.markDirty(false);
            }
        }
    }

    public void func_145843_s() {
        int dimension;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && lureLocations.containsKey(dimension = this.field_145850_b.field_73011_w.field_76574_g)) {
            HashSet<BlockCoord> bcs = lureLocations.get(dimension);
            bcs.remove(new BlockCoord(this));
        }
        super.func_145843_s();
    }

    public boolean isEnabled() {
        return this.func_145832_p() == 1;
    }

    public boolean tryEnable() {
        if (!this.isEnabled() && this.calcVerticalLimits()) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:brain", 0.8f, this.field_145850_b.field_73012_v.nextFloat() * 0.3f + 0.2f);
            MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0, 0, (short)10);
            return true;
        }
        return false;
    }

    public boolean tryDisable() {
        if (this.isEnabled()) {
            this.timeRangeUp = 0;
            this.func_70296_d();
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:wandfail", 0.5f, 0.4f);
            return true;
        }
        return false;
    }

    public static TileEntityMobLure getLureNear(World world, double x, double y, double z) {
        int dimension = world.field_73011_w.field_76574_g;
        if (!lureLocations.containsKey(dimension)) {
            return null;
        }
        HashSet<BlockCoord> bcs = lureLocations.get(dimension);
        TileEntityMobLure closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockCoord bc : bcs) {
            double d;
            TileEntityMobLure teML;
            TileEntity te;
            if (!TjUtil.isChunkLoaded(world, bc.x, bc.z) || !((te = world.func_147438_o(bc.x, bc.y, bc.z)) instanceof TileEntityMobLure) || !(teML = (TileEntityMobLure)te).isEnabled() || (d = teML.getDistanceIfInRange(x, y, z)) == -1.0 || !(d < closestDistance)) continue;
            closest = teML;
            closestDistance = d;
        }
        return closest;
    }

    public double getDistanceIfInRange(double x, double y, double z) {
        double range = this.getRange();
        double d = TjUtil.getDistanceBetweenPoints_squared((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, x, y, z);
        return d <= range * range ? d : -1.0;
    }

    public double getRange() {
        return this.timeRangeUp > 0 ? RANGE_HORIZONTAL_BOOSTED : RANGE_HORIZONTAL;
    }

    public boolean calcVerticalLimits() {
        this.nextVerticalCalc = VERTICAL_CALC_FREQUENCY;
        int prevTop = this.yTop;
        int prevBottom = this.yBottom;
        int numAbove = 0;
        int numBelow = 0;
        this.yTop = this.field_145848_d;
        while (ThaumcraftExtension.blockIsObsidianTotem((IBlockAccess)this.field_145850_b, this.field_145851_c, this.yTop + 1, this.field_145849_e)) {
            ++this.yTop;
            if (++numAbove < MAX_TOTEM_BLOCKS_EACHDIR) continue;
        }
        this.yBottom = this.field_145848_d;
        while (ThaumcraftExtension.blockIsObsidianTotem((IBlockAccess)this.field_145850_b, this.field_145851_c, this.yBottom - 1, this.field_145849_e)) {
            --this.yBottom;
            if (++numBelow < MAX_TOTEM_BLOCKS_EACHDIR) continue;
        }
        this.numTotemBlocks = numAbove + numBelow;
        if (prevBottom != this.yBottom || prevTop != this.yTop) {
            this.func_70296_d();
        }
        return this.numTotemBlocks >= MIN_TOTEM_BLOCKS;
    }

    public void charmNearbyEntities() {
        double range = this.getRange();
        List<EntityLiving> targets = this.getTargetEntities(range);
        int strength = this.getLureStrength();
        WorldSpecificCoordinates coord = new WorldSpecificCoordinates(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        long time = System.currentTimeMillis();
        for (EntityLiving e : targets) {
            long t;
            int luredStr;
            UUID id;
            if (EntityAICharmWalk.addAIToEntity(e, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, range + 1.0, strength, this) || !(e instanceof EntityCreature) || secondaryCharmedEntitiesStrength.containsKey(id = e.func_110124_au()) && !secondaryCharmedEntitiesCoord.get(id).equals(coord) && (luredStr = secondaryCharmedEntitiesStrength.get(id).intValue()) >= strength && time - (t = secondaryCharmedEntitiesTime.get(id).longValue()) < 1000L) continue;
            secondaryCharmedEntitiesStrength.put(id, strength);
            secondaryCharmedEntitiesTime.put(id, time);
            secondaryCharmedEntitiesCoord.put(id, coord);
            PathNavigate nav = e.func_70661_as();
            PathEntity path = nav.func_75488_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
            ((EntityCreature)e).func_70778_a(path);
            double x = e.field_70165_t + e.field_70159_w;
            double z = e.field_70161_v + e.field_70179_y;
            if (Math.abs((double)this.field_145851_c - x) < Math.abs((double)this.field_145851_c - e.field_70165_t) || Math.abs((double)this.field_145849_e - z) < Math.abs((double)this.field_145849_e - e.field_70161_v)) {
                e.func_70612_e(0.0f, 0.8f);
            } else if (this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                e.func_70612_e(0.0f, 0.5f);
            }
            e.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, CHARM_FREQUENCY + 1, 0));
        }
    }

    private int getLureStrength() {
        return this.numTotemBlocks;
    }

    public List<EntityLiving> getTargetEntities(double rangeHorizontal) {
        double x = (double)this.field_145851_c + 0.5;
        double z = (double)this.field_145849_e + 0.5;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - rangeHorizontal), (double)this.yBottom, (double)(z - rangeHorizontal), (double)(x + rangeHorizontal), (double)((double)this.yTop + 1.0), (double)(z + rangeHorizontal));
        List entities = this.field_145850_b.func_72872_a(EntityLiving.class, box);
        ArrayList<EntityLiving> targets = new ArrayList<EntityLiving>();
        for (EntityLiving e : entities) {
            if (!(e instanceof IMob) && !(e instanceof IAnimals) || e instanceof EntityGolemBase || e instanceof IBossDisplayData || e instanceof IEntityMultiPart) continue;
            targets.add(e);
        }
        return targets;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("timeRangeUp", this.timeRangeUp);
        nbttagcompound.func_74768_a("yTop", this.yTop);
        nbttagcompound.func_74768_a("yBottom", this.yBottom);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.timeRangeUp = nbttagcompound.func_74762_e("timeRangeUp");
        this.yTop = nbttagcompound.func_74762_e("yTop");
        this.yBottom = nbttagcompound.func_74762_e("yBottom");
    }
}

