/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.container;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.expanded.BaubleExpandedSlots;
import baubles.api.expanded.IBaubleExpanded;
import baubles.common.lib.ItemStackHelper;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSyncBauble;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public class InventoryBaubles
implements IInventory {
    public ItemStack[] stackList = new ItemStack[20];
    private Container eventHandler;
    public WeakReference<EntityPlayer> player;
    public boolean blockEvents = false;

    public InventoryBaubles(EntityPlayer player) {
        this.player = new WeakReference<EntityPlayer>(player);
    }

    public Container getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(Container eventHandler) {
        this.eventHandler = eventHandler;
    }

    public int func_70302_i_() {
        return this.stackList.length;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? null : this.stackList[slot];
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.stackList[slot] != null) {
            ItemStack itemstack = this.stackList[slot];
            this.stackList[slot] = null;
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int decrementBy) {
        if (this.stackList[slot] != null) {
            ItemStack itemstack;
            if (this.stackList[slot].field_77994_a <= decrementBy) {
                itemstack = this.stackList[slot];
                if (itemstack != null && itemstack.func_77973_b() instanceof IBauble) {
                    ((IBauble)itemstack.func_77973_b()).onUnequipped(itemstack, (EntityLivingBase)this.player.get());
                }
                this.stackList[slot] = null;
            } else {
                itemstack = this.stackList[slot].func_77979_a(decrementBy);
                if (itemstack != null && itemstack.func_77973_b() instanceof IBauble) {
                    ((IBauble)itemstack.func_77973_b()).onUnequipped(itemstack, (EntityLivingBase)this.player.get());
                }
                if (this.stackList[slot].field_77994_a == 0) {
                    this.stackList[slot] = null;
                }
            }
            if (this.eventHandler != null) {
                this.eventHandler.func_75130_a((IInventory)this);
            }
            this.syncSlotToClients(slot);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.blockEvents && this.stackList[slot] != null) {
            ((IBauble)this.stackList[slot].func_77973_b()).onUnequipped(this.stackList[slot], (EntityLivingBase)this.player.get());
        }
        this.stackList[slot] = stack;
        if (!this.blockEvents && stack != null && stack.func_77973_b() instanceof IBauble && this.player.get() != null) {
            ((IBauble)stack.func_77973_b()).onEquipped(stack, (EntityLivingBase)this.player.get());
        }
        if (this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
        this.syncSlotToClients(slot);
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        try {
            ((EntityPlayer)this.player.get()).field_71071_by.func_70296_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        String[] types;
        String slotType = BaubleExpandedSlots.getSlotType(slot);
        if (stack == null || slotType == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IBauble) || !((IBauble)item).canEquip(stack, (EntityLivingBase)this.player.get())) {
            return false;
        }
        if (item instanceof IBaubleExpanded) {
            types = ((IBaubleExpanded)item).getBaubleTypes(stack);
        } else {
            BaubleType legacyType = ((IBauble)item).getBaubleType(stack);
            types = new String[]{BaubleExpandedSlots.getTypeFromBaubleType(legacyType)};
        }
        for (String type : types) {
            if (!type.equals("universal") && !type.equals(slotType)) continue;
            return true;
        }
        return false;
    }

    public void saveNBT(EntityPlayer player) {
        NBTTagCompound tags = player.getEntityData();
        this.saveNBT(tags);
    }

    public void saveNBT(NBTTagCompound tags) {
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.stackList.length; ++slot) {
            if (this.stackList[slot] == null) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.func_74774_a("Slot", (byte)slot);
            this.stackList[slot].func_77955_b(invSlot);
            tagList.func_74742_a((NBTBase)invSlot);
        }
        tags.func_74782_a("Baubles.Inventory", (NBTBase)tagList);
    }

    public void readNBT(EntityPlayer player) {
        NBTTagCompound tags = player.getEntityData();
        this.readNBT(tags);
    }

    public void readNBT(NBTTagCompound tags) {
        NBTTagList tagList = tags.func_150295_c("Baubles.Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            int slot = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            if (itemstack == null) continue;
            this.stackList[slot] = itemstack;
        }
    }

    public void dropItems(ArrayList<EntityItem> drops) {
        for (int slot = 0; slot < this.stackList.length; ++slot) {
            if (this.stackList[slot] == null) continue;
            EntityItem item = new EntityItem(((EntityPlayer)this.player.get()).field_70170_p, ((EntityPlayer)this.player.get()).field_70165_t, ((EntityPlayer)this.player.get()).field_70163_u + (double)((EntityPlayer)this.player.get()).eyeHeight, ((EntityPlayer)this.player.get()).field_70161_v, this.stackList[slot].func_77946_l());
            item.field_145804_b = 40;
            float f1 = ((EntityPlayer)this.player.get()).field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = ((EntityPlayer)this.player.get()).field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            item.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            item.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            item.field_70181_x = 0.2f;
            drops.add(item);
            this.stackList[slot] = null;
            this.syncSlotToClients(slot);
        }
    }

    public void dropItemsAt(ArrayList<EntityItem> drops, Entity entity) {
        for (int slot = 0; slot < this.stackList.length; ++slot) {
            if (this.stackList[slot] == null || ItemStackHelper.isSoulBound(this.stackList[slot])) continue;
            EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, this.stackList[slot].func_77946_l());
            item.field_145804_b = 40;
            float f1 = entity.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = entity.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            item.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            item.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            item.field_70181_x = 0.2f;
            drops.add(item);
            this.stackList[slot] = null;
            this.syncSlotToClients(slot);
        }
    }

    public void syncSlotToClients(int slot) {
        try {
            EntityPlayer entityPlayer = (EntityPlayer)this.player.get();
            if (entityPlayer != null && !entityPlayer.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSyncBauble((EntityPlayer)this.player.get(), slot));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

