/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.UuidConverter;
import betterquesting.api2.storage.UuidDatabase;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestInstance;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QuestDatabase
extends UuidDatabase<IQuest>
implements IQuestDatabase {
    public static final QuestDatabase INSTANCE = new QuestDatabase();

    @Override
    public synchronized IQuest createNew(UUID questID) {
        QuestInstance quest = new QuestInstance();
        this.put(questID, quest);
        return quest;
    }

    @Override
    @Nullable
    public IQuest put(@Nullable UUID key, @Nullable IQuest value) {
        if (value == null && BQ_Settings.logNullQuests) {
            BetterQuesting.logger.warn("A null quest was added with ID {}", new Object[]{key});
        }
        return super.put(key, value);
    }

    @Override
    public IQuest remove(Object key) {
        if (!(key instanceof UUID)) {
            return null;
        }
        UUID questID = (UUID)key;
        IQuest removed = (IQuest)super.remove(questID);
        if (removed != null) {
            for (IQuest quest : this.values()) {
                this.removeReq(quest, questID);
            }
        }
        return removed;
    }

    @Override
    public UUID removeValue(IQuest value) {
        UUID questID = super.removeValue(value);
        if (questID != null) {
            for (IQuest quest : this.values()) {
                this.removeReq(quest, questID);
            }
        }
        return questID;
    }

    private void removeReq(IQuest quest, UUID questID) {
        quest.getRequirements().remove(questID);
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<UUID> subset) {
        this.orderedEntries().forEach(entry -> {
            if (subset != null && !subset.contains(entry.getKey())) {
                return;
            }
            if (entry.getValue() == null) {
                if (BQ_Settings.logNullQuests) {
                    BetterQuesting.logger.warn("Tried saving null quest with ID {}", new Object[]{entry.getKey()});
                }
                return;
            }
            NBTTagCompound jq = new NBTTagCompound();
            ((IQuest)entry.getValue()).writeToNBT(jq);
            NBTConverter.UuidValueType.QUEST.writeId((UUID)entry.getKey(), jq);
            nbt.func_74742_a((NBTBase)jq);
        });
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.clear();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            UUID questID;
            NBTTagCompound qTag = nbt.func_150305_b(i);
            Optional<UUID> questIDOptional = NBTConverter.UuidValueType.QUEST.tryReadId(qTag);
            if (questIDOptional.isPresent()) {
                questID = questIDOptional.get();
            } else {
                if (!qTag.func_150297_b("questID", 99)) continue;
                questID = UuidConverter.convertLegacyId(qTag.func_74762_e("questID"));
            }
            IQuest quest = (IQuest)this.get(questID);
            quest = quest != null ? quest : this.createNew(questID);
            quest.readFromNBT(qTag);
        }
    }

    @Override
    public synchronized NBTTagList writeProgressToNBT(NBTTagList json, List<UUID> users) {
        for (Map.Entry entry : this.entrySet()) {
            NBTTagCompound jq = ((IQuest)entry.getValue()).writeProgressToNBT(new NBTTagCompound(), users);
            NBTConverter.UuidValueType.QUEST.writeId(entry.getKey(), jq);
            json.func_74742_a((NBTBase)jq);
        }
        return json;
    }

    @Override
    public synchronized void readProgressFromNBT(NBTTagList json, boolean merge) {
        int tagCount = json.func_74745_c();
        for (int i = 0; i < tagCount; ++i) {
            IQuest quest;
            NBTTagCompound qTag = json.func_150305_b(i);
            UUID questID = null;
            Optional<UUID> questIDOptional = NBTConverter.UuidValueType.QUEST.tryReadId(qTag);
            if (questIDOptional.isPresent()) {
                questID = questIDOptional.get();
            } else if (qTag.func_150297_b("questID", 99)) {
                questID = UuidConverter.convertLegacyId(qTag.func_74762_e("questID"));
            }
            if (questID == null || (quest = (IQuest)this.get(questID)) == null) continue;
            quest.readProgressFromNBT(qTag, merge);
        }
    }
}

