/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.AbstractReward;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import bq_standard.NBTReplaceUtil;
import bq_standard.client.gui.rewards.PanelRewardChoice;
import bq_standard.core.BQ_Standard;
import bq_standard.rewards.IRewardItemOutput;
import bq_standard.rewards.factory.FactoryRewardChoice;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class RewardChoice
extends AbstractReward
implements IReward,
IRewardItemOutput {
    public final List<BigItemStack> choices = new ArrayList<BigItemStack>();
    private final TreeMap<UUID, Integer> selected = new TreeMap();

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryRewardChoice.INSTANCE.getRegistryName();
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.reward.choice";
    }

    public int getSelecton(UUID uuid) {
        if (!this.selected.containsKey(uuid)) {
            return -1;
        }
        return this.selected.get(uuid);
    }

    public void setSelection(UUID uuid, int value) {
        this.selected.put(uuid, value);
    }

    public void selectRandomChoice(EntityPlayer player) {
        if (this.choices.isEmpty()) {
            return;
        }
        UUID playerUUID = QuestingAPI.getQuestingUUID(player);
        if (this.selected.containsKey(playerUUID)) {
            return;
        }
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (int i = 0; i < this.choices.size(); ++i) {
            BigItemStack choice = this.choices.get(i);
            ItemStack baseStack = choice.getBaseStack();
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)baseStack.func_77973_b());
            if (id == null || !id.modId.equals("enhancedlootbags")) continue;
            candidates.add(i);
        }
        int selection = !candidates.isEmpty() ? (Integer)candidates.get((int)(Math.random() * (double)candidates.size())) : (int)(Math.random() * (double)this.choices.size());
        this.setSelection(playerUUID, selection);
    }

    @Override
    public boolean canClaim(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        if (!this.selected.containsKey(QuestingAPI.getQuestingUUID(player))) {
            return false;
        }
        int tmp = this.selected.get(QuestingAPI.getQuestingUUID(player));
        return this.choices.isEmpty() || tmp >= 0 && tmp < this.choices.size();
    }

    @Override
    protected void claimReward0(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.choices.isEmpty()) {
            return;
        }
        if (!this.selected.containsKey(playerID)) {
            return;
        }
        int tmp = this.selected.get(playerID);
        if (tmp < 0 || tmp >= this.choices.size()) {
            BQ_Standard.logger.log(Level.ERROR, "Choice reward was forcibly claimed with invalid choice", (Throwable)new IllegalStateException());
            return;
        }
        BigItemStack stack = this.choices.get(tmp);
        BigItemStack bigItemStack = stack = stack == null ? null : stack.copy();
        if (stack == null || stack.stackSize <= 0) {
            BQ_Standard.logger.log(Level.WARN, "Claimed reward choice was null or was 0 in size!");
            return;
        }
        for (ItemStack s : stack.getCombinedStacks()) {
            if (s.func_77978_p() != null) {
                s.func_77982_d(NBTReplaceUtil.replaceStrings(s.func_77978_p(), "VAR_NAME", player.func_70005_c_()));
                s.func_77982_d(NBTReplaceUtil.replaceStrings(s.func_77978_p(), "VAR_UUID", QuestingAPI.getQuestingUUID(player).toString()));
            }
            if (player.field_71071_by.func_70441_a(s)) continue;
            player.func_71019_a(s, false);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.choices.clear();
        NBTTagList cList = nbt.func_150295_c("choices", 10);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            this.choices.add(JsonHelper.JsonToItemStack(cList.func_150305_b(i)));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList rJson = new NBTTagList();
        for (BigItemStack stack : this.choices) {
            rJson.func_74742_a((NBTBase)JsonHelper.ItemStackToJson(stack, new NBTTagCompound()));
        }
        nbt.func_74782_a("choices", (NBTBase)rJson);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getRewardGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelRewardChoice(rect, quest, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getRewardEditor(GuiScreen screen, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    @Override
    public List<BigItemStack> getItemOutputs() {
        return this.choices;
    }
}

