/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.biome.BOPSubBiome;
import biomesoplenty.common.world.BOPBiomeManager;
import biomesoplenty.common.world.noise.SimplexNoise;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;
import org.apache.commons.lang3.tuple.Pair;

public class GenLayerSubBiome
extends GenLayer {
    private final int OFFSET_RANGE = 500000;
    private Pair<Integer, Integer>[] offsets = new Pair[BiomeGenBase.func_150565_n().length];

    public GenLayerSubBiome(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
        this.setOffsets();
    }

    public int[] func_75904_a(int x, int z, int width, int length) {
        int[] inputBiomeIDs = this.field_75909_a.func_75904_a(x - 1, z - 1, width + 2, length + 2);
        int[] outputBiomeIDs = IntCache.func_76445_a((int)(width * length));
        for (int xi = 0; xi < width; ++xi) {
            for (int zi = 0; zi < length; ++zi) {
                BOPSubBiome selectedSubBiome;
                this.func_75903_a(xi + x, zi + z);
                int currentBiomeId = inputBiomeIDs[xi + 1 + (zi + 1) * (width + 2)];
                List<BiomeManager.BiomeEntry> currentSubBiomes = BOPBiomeManager.overworldSubBiomes[currentBiomeId];
                BOPSubBiome bOPSubBiome = selectedSubBiome = currentSubBiomes != null ? (BOPSubBiome)currentSubBiomes.get((int)this.func_75902_a((int)currentSubBiomes.size())).biome : null;
                if (selectedSubBiome != null) {
                    Pair<Integer, Integer> offset = this.getOffset(selectedSubBiome);
                    if (SimplexNoise.noise((double)(xi + x + (Integer)offset.getLeft()) * selectedSubBiome.zoom, (double)(zi + z + (Integer)offset.getRight()) * selectedSubBiome.zoom) > selectedSubBiome.threshold) {
                        outputBiomeIDs[xi + zi * width] = selectedSubBiome.field_76756_M;
                        continue;
                    }
                    outputBiomeIDs[xi + zi * width] = currentBiomeId;
                    continue;
                }
                outputBiomeIDs[xi + zi * width] = currentBiomeId;
            }
        }
        return outputBiomeIDs;
    }

    private Pair<Integer, Integer> getOffset(BiomeGenBase biome) {
        return this.offsets[biome.field_76756_M];
    }

    private void setOffsets() {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = Pair.of((Object)(this.func_75902_a(500000) - 250000), (Object)(this.func_75902_a(500000) - 250000));
        }
    }
}

