/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.blocklimiter.config;

import com.github.namikon.blocklimiter.BlockLimiter;
import com.github.namikon.blocklimiter.auxiliary.BlockInfo;
import com.github.namikon.blocklimiter.auxiliary.ItemInfo;
import eu.usrv.yamcore.config.ConfigManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BlockLimiterConfig
extends ConfigManager {
    public List<BlockInfo> LimitedBlocks = null;
    public List<ItemInfo> LimitedItems = null;
    private String[] tConfiguredBlocks;
    private String[] tConfiguredItems;
    public String[] RandomDenyMessages = null;
    public String[] RandomItemDenyMessages = null;
    public String SFXOnBlockDeny;
    public String SFXOnItemDeny;
    public boolean DenyCreativeMode;

    public BlockLimiterConfig(File pConfigBaseDirectory, String pModCollectionDirectory, String pModID) {
        super(pConfigBaseDirectory, pModCollectionDirectory, pModID);
    }

    protected void PreInit() {
        this.LimitedBlocks = new ArrayList<BlockInfo>();
        this.LimitedItems = new ArrayList<ItemInfo>();
        this.RandomDenyMessages = new String[]{"You can't place that here", "You are too jelly to place this", "The block doesn't want to be here", "YOU SHALL NOT PLACE (this Block)", "*poof*"};
        this.RandomItemDenyMessages = new String[]{"You can't use that here", "You are too jelly to use this", "The item seems to be broken...", "YOU SHALL NOT USE (this Item)"};
        this.SFXOnBlockDeny = "minecraft:ambient.weather.thunder";
        this.SFXOnItemDeny = "minecraft:ambient.weather.thunder";
        this.DenyCreativeMode = false;
    }

    protected void Init() {
        this.tConfiguredBlocks = this._mainConfig.getStringList("BlockList", "Main", new String[0], "Define your Blocks here. Syntax is: [modID]:[BlockID];[DimID];... if you don't add a Dimension (e.g. minecraft:dirt) it will be denied in every dimension");
        this.tConfiguredItems = this._mainConfig.getStringList("ItemList", "Main", new String[0], "Define your Items here. Syntax is: [modID]:[ItemID];[DimID];... if you don't add a Dimension (e.g. minecraft:dirt instead of minecraft:dirt;12) it will be denied in every dimension");
        this.RandomDenyMessages = this._mainConfig.getStringList("RejectMessages", "Main", this.RandomDenyMessages, "Define a few reject messages that are being sent to the player if they try to place a monitored Block");
        this.RandomItemDenyMessages = this._mainConfig.getStringList("ItemRejectMessages", "Main", this.RandomItemDenyMessages, "Define a few reject messages that are being sent to the player if they try to use a monitored item");
        this.SFXOnBlockDeny = this._mainConfig.getString("PlaySFXOnBlockDeny", "main", this.SFXOnBlockDeny, "Leave it blank for no sound effect, or put in a valid sound-reference like this: [modID]:[soundeffectID]");
        this.SFXOnItemDeny = this._mainConfig.getString("PlaySFXOnItemDeny", "main", this.SFXOnItemDeny, "Leave it blank for no sound effect, or put in a valid sound-reference like this: [modID]:[soundeffectID]");
        this.DenyCreativeMode = this._mainConfig.getBoolean("DenyCreativeMode", "main", this.DenyCreativeMode, "Set this to true to prevent even Server-OPs/Admins from placing forbidden blocks and using forbidden items");
    }

    public boolean Reload() {
        this._mainConfig.load();
        this.Init();
        boolean tState = true;
        if (!this.InitDefinedBlocks()) {
            tState = false;
        }
        if (!this.InitDefinedItems()) {
            tState = false;
        }
        return tState;
    }

    private boolean InitDefinedItems() {
        boolean tResult = true;
        try {
            ArrayList<ItemInfo> tNewLimitedItems = new ArrayList<ItemInfo>();
            for (String tItemDef : this.tConfiguredItems) {
                try {
                    ItemInfo tII = new ItemInfo(tItemDef);
                    tNewLimitedItems.add(tII);
                }
                catch (Exception e) {
                    tResult = false;
                    BlockLimiter.Logger.error((Object)("An error occoured while parsing line " + tItemDef + " and therfor it will be ignored"));
                    e.printStackTrace();
                }
            }
            this.LimitedItems = tNewLimitedItems;
        }
        catch (Exception e) {
            BlockLimiter.Logger.error((Object)"An error occoured while parsing ItemConfigs. You probably did something wrong did you..?");
            BlockLimiter.Logger.DumpStack(e);
        }
        return tResult;
    }

    private boolean InitDefinedBlocks() {
        boolean tResult = true;
        try {
            ArrayList<BlockInfo> tNewLimitedBlocks = new ArrayList<BlockInfo>();
            for (String tBlockDef : this.tConfiguredBlocks) {
                try {
                    BlockInfo tBI = new BlockInfo(tBlockDef);
                    tNewLimitedBlocks.add(tBI);
                }
                catch (Exception e) {
                    tResult = false;
                    BlockLimiter.Logger.error((Object)("An error occoured while parsing line " + tBlockDef + " and therfor it will be ignored"));
                    e.printStackTrace();
                }
            }
            this.LimitedBlocks = tNewLimitedBlocks;
        }
        catch (Exception e) {
            BlockLimiter.Logger.error((Object)"An error occoured while parsing BlockConfigs. You probably did something wrong did you..?");
            BlockLimiter.Logger.DumpStack(e);
        }
        return tResult;
    }

    protected void PostInit() {
        this.InitDefinedBlocks();
        this.InitDefinedItems();
    }
}

