/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.IMeleeSpellEntityEffect;
import WayofTime.alchemicalWizardry.api.spell.IMeleeSpellWorldEffect;
import WayofTime.alchemicalWizardry.api.spell.SpellEnhancement;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SpellParadigmMelee
extends SpellParadigm {
    private List<IMeleeSpellEntityEffect> entityEffectList = new ArrayList<IMeleeSpellEntityEffect>();
    private List<IMeleeSpellWorldEffect> worldEffectList = new ArrayList<IMeleeSpellWorldEffect>();

    @Override
    public void enhanceParadigm(SpellEnhancement enh) {
    }

    @Override
    public void castSpell(World world, EntityPlayer entityPlayer, ItemStack itemStack) {
        int cost = this.getTotalCost();
        if (!SoulNetworkHandler.syphonAndDamageFromNetwork(itemStack, entityPlayer, cost)) {
            return;
        }
        for (IMeleeSpellEntityEffect iMeleeSpellEntityEffect : this.entityEffectList) {
            iMeleeSpellEntityEffect.onEntityImpact(world, entityPlayer);
        }
        for (IMeleeSpellWorldEffect iMeleeSpellWorldEffect : this.worldEffectList) {
            iMeleeSpellWorldEffect.onWorldEffect(world, entityPlayer);
        }
    }

    public void addEntityEffect(IMeleeSpellEntityEffect eff) {
        if (eff != null) {
            this.entityEffectList.add(eff);
        }
    }

    public void addWorldEffect(IMeleeSpellWorldEffect eff) {
        if (eff != null) {
            this.worldEffectList.add(eff);
        }
    }

    @Override
    public int getDefaultCost() {
        return 0;
    }
}

