/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.client.ClientUtils;
import WayofTime.alchemicalWizardry.client.nei.TooltipStack;
import WayofTime.alchemicalWizardry.client.nei.widgets.CostInfo;
import WayofTime.alchemicalWizardry.client.nei.widgets.RadiusInfo;
import WayofTime.alchemicalWizardry.client.nei.widgets.ReagentInfo;
import WayofTime.alchemicalWizardry.client.nei.widgets.RitualInfo;
import WayofTime.alchemicalWizardry.common.summoning.meteor.Meteor;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorReagent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorReagentRegistry;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.base.Joiner;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class NEIMeteorRecipeHandler
extends TemplateRecipeHandler {
    private static final RitualInfo ritualInfo = new RitualInfo(0.75f, "AW019FallingTower");
    private static final ReagentInfo reagentInfo = new ReagentInfo(0.75f);

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && ((Object)((Object)this)).getClass() == NEIMeteorRecipeHandler.class) {
            for (Meteor meteor : this.getSortedMeteors()) {
                this.arecipes.add(new CachedMeteorRecipe(meteor, null));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Meteor meteor : this.getSortedMeteors()) {
            if (meteor.ores.stream().anyMatch(m -> this.matchItem(result, m.getBlock()))) {
                this.arecipes.add(new CachedMeteorRecipe(meteor, result));
            }
            if (!(meteor.fillerChance > 0.0f) || !meteor.filler.stream().anyMatch(m -> this.matchItem(result, m.getBlock()))) continue;
            this.arecipes.add(new CachedMeteorRecipe(meteor, result));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Meteor meteor : this.getSortedMeteors()) {
            if (!this.matchItem(ingredient, meteor.focusItem)) continue;
            this.arecipes.add(new CachedMeteorRecipe(meteor, null));
        }
    }

    private boolean matchItem(ItemStack compared, ItemStack compareTo) {
        if (compared == null || compareTo == null) {
            return false;
        }
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)compared, (ItemStack)compareTo)) {
            return true;
        }
        if (compared.func_77977_a().startsWith("gt.blockores") && compareTo.func_77977_a().startsWith("gt.blockores")) {
            return compared.func_77960_j() % 1000 == compareTo.func_77960_j() % 1000;
        }
        String[] prefixes = new String[]{"crushed", "rawOre", "raw"};
        for (int i : OreDictionary.getOreIDs((ItemStack)compareTo)) {
            String s1 = OreDictionary.getOreName((int)i);
            if (!s1.startsWith("ore")) continue;
            for (int j : OreDictionary.getOreIDs((ItemStack)compared)) {
                if (i == j) {
                    return true;
                }
                String s2 = OreDictionary.getOreName((int)j);
                for (String prefix : prefixes) {
                    if (i != OreDictionary.getOreID((String)s2.replaceFirst("^" + prefix, "ore"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/meteor.png").toString();
    }

    public String getOverlayIdentifier() {
        return "alchemicalwizardry.meteor";
    }

    public void drawExtras(int recipe) {
        CachedMeteorRecipe meteorRecipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipe));
        meteorRecipe.costInfo.onDraw(30, 4);
        meteorRecipe.radiusInfo.onDraw(120, 4);
        ritualInfo.onDraw(0, 0);
        reagentInfo.onDraw(153, 0);
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)202);
        CachedMeteorRecipe recipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipeIndex));
        Point focus = recipe.focus;
        if (focus != null) {
            GuiDraw.drawTexturedModalRect((int)focus.x, (int)focus.y, (int)172, (int)0, (int)18, (int)18);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        PositionedStack pStack;
        CachedMeteorRecipe meteorRecipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipe));
        Iterator iterator = meteorRecipe.outputs.iterator();
        while (iterator.hasNext() && (pStack = (PositionedStack)iterator.next()) instanceof TooltipStack) {
            TooltipStack tStack = (TooltipStack)pStack;
            if (!Arrays.stream(tStack.items).anyMatch(s -> NEIServerUtils.areStacksSameTypeCrafting((ItemStack)s, (ItemStack)stack))) continue;
            currenttip.addAll(tStack.getTooltips());
            break;
        }
        return currenttip;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipeIndex) {
        if (GuiContainerManager.shouldShowTooltip(gui) && currenttip.isEmpty()) {
            TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
            Point mousePos = GuiDraw.getMousePosition();
            if (cRecipe instanceof CachedMeteorRecipe) {
                CachedMeteorRecipe cachedRecipe = (CachedMeteorRecipe)cRecipe;
                if (cachedRecipe.costInfo.getRect(gui).contains(mousePos)) {
                    currenttip.add(StatCollector.func_74838_a((String)"nei.recipe.meteor.cost"));
                    if (APISpellHelper.getPlayerLPTag((EntityPlayer)ClientUtils.mc.field_71439_g) < cachedRecipe.getCost()) {
                        currenttip.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"nei.recipe.meteor.tooExpensive"));
                    }
                } else if (cachedRecipe.radiusInfo.getRect(gui).contains(mousePos)) {
                    currenttip.add(StatCollector.func_74837_a((String)"nei.recipe.meteor.diameter", (Object[])new Object[]{2 * cachedRecipe.radiusInfo.getRadius() + 1}));
                } else if (ritualInfo.getRect(gui).contains(mousePos)) {
                    ritualInfo.onHover(currenttip);
                } else if (reagentInfo.getRect(gui).contains(mousePos)) {
                    reagentInfo.onHover(currenttip);
                    this.addMeteorReagentInfo(currenttip, cachedRecipe);
                }
            }
        }
        return super.handleTooltip(gui, currenttip, recipeIndex);
    }

    private void addMeteorReagentInfo(List<String> list, CachedMeteorRecipe cachedRecipe) {
        DecimalFormat fmt = new DecimalFormat("###.##");
        for (Map.Entry<Reagent, MeteorReagent> entry : MeteorReagentRegistry.reagents.entrySet()) {
            ArrayList<String> l = new ArrayList<String>();
            Reagent r = entry.getKey();
            MeteorReagent mr = entry.getValue();
            if (mr.radiusChange != 0) {
                l.add(StatCollector.func_74837_a((String)"nei.recipe.reagent.meteor.radius", (Object[])new Object[]{mr.radiusChange, Meteor.getNewRadius(cachedRecipe.getRadius(), Collections.singletonList(r))}));
            }
            if (cachedRecipe.fillerChance > 0.0f) {
                if (mr.fillerChanceChange != 0 || mr.rawFillerChanceChange != 0.0f) {
                    l.add(StatCollector.func_74837_a((String)"nei.recipe.reagent.meteor.filler.chance", (Object[])new Object[]{fmt.format(Meteor.getNewFillerChance(cachedRecipe.fillerChance, Collections.singletonList(r)))}));
                }
                if (!mr.filler.isEmpty()) {
                    l.add(StatCollector.func_74837_a((String)"nei.recipe.reagent.meteor.filler.blocks", (Object[])new Object[]{this.reagentFillerBlockNames(mr)}));
                }
            }
            if (mr.disableExplosions) {
                l.add(StatCollector.func_74838_a((String)"nei.recipe.reagent.meteor.explosions"));
            } else if (mr.invertExplosionBlockDamage && AlchemicalWizardry.doMeteorsDestroyBlocks) {
                l.add(StatCollector.func_74838_a((String)"nei.recipe.reagent.meteor.blockDamage.off"));
            } else if (mr.invertExplosionBlockDamage) {
                l.add(StatCollector.func_74838_a((String)"nei.recipe.reagent.meteor.blockDamage.on"));
            }
            if (l.isEmpty()) continue;
            list.add(r.name + ":");
            list.addAll(l);
        }
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"nei.recipe.meteor.category", (Object[])new Object[0]);
    }

    private List<Meteor> getSortedMeteors() {
        return MeteorRegistry.meteorList.stream().sorted(Comparator.comparing(m -> m.cost)).collect(Collectors.toList());
    }

    private String getFormattedChance(float chance) {
        return new DecimalFormat("0.##").format(chance * 100.0f);
    }

    private int getEstimatedAmount(float chance, int radius) {
        return (int)Math.ceil(4.1887903296220665 * Math.pow((double)radius + 0.5, 3.0) * (double)chance);
    }

    private String reagentFillerBlockNames(MeteorReagent mr) {
        ArrayList<String> blockNames = new ArrayList<String>();
        for (MeteorComponent mc : mr.filler) {
            blockNames.add(mc.getBlock().func_82833_r() + this.requiredReagentsForFiller(mc));
        }
        return Joiner.on((String)", ").join(blockNames);
    }

    private String requiredReagentsForFiller(MeteorComponent mc) {
        ArrayList<Reagent> reagents = mc.getRequiredReagents();
        if (reagents.isEmpty()) {
            return "";
        }
        return " (" + reagents.stream().map(r -> r.name).collect(Collectors.joining(", ")) + ")";
    }

    public class CachedMeteorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private final CostInfo costInfo;
        private final RadiusInfo radiusInfo;
        private Point focus;
        public float fillerChance;

        public CachedMeteorRecipe(Meteor meteor, ItemStack focusStack) {
            super((TemplateRecipeHandler)NEIMeteorRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.input.add(new PositionedStack((Object)meteor.focusItem, 75, 4));
            int row = 0;
            int col = 0;
            float totalComponentWeight = MeteorComponent.getTotalListWeight(meteor.ores);
            this.fillerChance = meteor.fillerChance;
            ArrayList<MeteorComponent> sortedComponents = new ArrayList<MeteorComponent>(meteor.ores);
            sortedComponents.sort(Comparator.comparingInt(c -> -c.getWeight()));
            float fillerRatio = (float)((double)this.fillerChance / 100.0);
            float componentRatio = 1.0f - fillerRatio;
            if (this.fillerChance < 100.0f) {
                for (MeteorComponent component : sortedComponents) {
                    ItemStack stack = component.getBlock();
                    int xPos = 3 + 18 * col;
                    int yPos = 37 + 18 * row;
                    ArrayList<String> tooltips = new ArrayList<String>();
                    float chance = (float)component.getWeight() / totalComponentWeight * componentRatio;
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.chance", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getFormattedChance(chance)}));
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.amount", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getEstimatedAmount(chance, meteor.radius)}));
                    if (!component.getRequiredReagents().isEmpty()) {
                        tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.reagent", (Object[])new Object[]{this.getReagentStrings(component)}));
                    }
                    this.outputs.add(new TooltipStack(stack, xPos, yPos, tooltips));
                    if (++col > 8) {
                        col = 0;
                        ++row;
                    }
                    if (!NEIMeteorRecipeHandler.this.matchItem(focusStack, stack)) continue;
                    this.focus = new Point(xPos - 1, yPos - 1);
                }
            }
            if (this.fillerChance > 0.0f) {
                if (col != 0) {
                    col = 0;
                    ++row;
                }
                ArrayList<MeteorComponent> sortedFiller = new ArrayList<MeteorComponent>(meteor.filler);
                sortedFiller.sort(Comparator.comparingInt(c -> -c.getWeight()));
                float totalFillerWeight = MeteorComponent.getTotalListWeight(meteor.filler);
                for (MeteorComponent filler : sortedFiller) {
                    ItemStack stack = filler.getBlock();
                    int xPos = 3 + 18 * col;
                    int yPos = 37 + 18 * row;
                    ArrayList<String> tooltips = new ArrayList<String>();
                    float chance = (float)filler.getWeight() / totalFillerWeight * fillerRatio;
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.chance", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getFormattedChance(chance)}));
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.amount", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getEstimatedAmount(chance, meteor.radius)}));
                    tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.filler", (Object[])new Object[0]));
                    if (!filler.getRequiredReagents().isEmpty()) {
                        tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.reagent", (Object[])new Object[]{this.getReagentStrings(filler)}));
                    }
                    this.outputs.add(new TooltipStack(stack, xPos, yPos, tooltips));
                    if (++col > 8) {
                        col = 0;
                        ++row;
                    }
                    if (!NEIMeteorRecipeHandler.this.matchItem(focusStack, stack)) continue;
                    this.focus = new Point(xPos - 1, yPos - 1);
                }
            }
            this.costInfo = new CostInfo(1.0f, meteor.cost);
            this.radiusInfo = new RadiusInfo(1.0f, meteor.radius);
        }

        private String getReagentStrings(MeteorComponent component) {
            ArrayList<Reagent> reagents = component.getRequiredReagents();
            ArrayList<String> reagentNames = new ArrayList<String>();
            for (Reagent r : reagents) {
                reagentNames.add(r.name);
            }
            return Joiner.on((String)", ").join(reagentNames);
        }

        public List<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public int getCost() {
            return this.costInfo.getCost();
        }

        public int getRadius() {
            return this.radiusInfo.getRadius();
        }
    }
}

