/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil.holding;

import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryHolding
implements IInventory {
    public ItemStack parentItemStack;
    protected ItemStack[] inventory;
    protected static String NBT_MOST_SIG = "MostSig";
    protected static String NBT_LEAST_SIG = "LeastSig";
    protected static String NBT_ITEMS = "Items";

    public InventoryHolding(ItemStack itemStack) {
        this.parentItemStack = itemStack;
        this.inventory = new ItemStack[5];
        this.readFromNBT(itemStack.func_77978_p());
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.parentItemStack = this.findParentItemStack(entityPlayer);
        if (this.parentItemStack != null) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (InventoryHolding.hasUUID(this.parentItemStack)) {
            UUID parentItemStackUUID = new UUID(this.parentItemStack.func_77978_p().func_74763_f(NBT_MOST_SIG), this.parentItemStack.func_77978_p().func_74763_f(NBT_LEAST_SIG));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (!InventoryHolding.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f(NBT_MOST_SIG) != parentItemStackUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f(NBT_LEAST_SIG) != parentItemStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentItemStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.func_74772_a(NBT_MOST_SIG, uuid.getMostSignificantBits());
            nbtTagCompound.func_74772_a(NBT_LEAST_SIG, uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentItemStack.func_77982_d(nbtTagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.inventory.length ? this.inventory[slotIndex] : null;
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 0 && slotIndex < this.inventory.length) {
            this.inventory[slotIndex] = itemStack;
        }
    }

    public String func_145825_b() {
        return "SigilOfHolding";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ISigil && ((ISigil)itemStack.func_77973_b()).canBeStored();
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b(NBT_ITEMS) && nbtTagCompound.func_74764_b(NBT_ITEMS)) {
            NBTTagList tagList = nbtTagCompound.func_150295_c(NBT_ITEMS, 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slotIndex = tagCompound.func_74771_c("Slot");
                if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
                this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a(NBT_ITEMS, (NBTBase)tagList);
    }

    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b(keyName);
    }

    public static boolean hasUUID(ItemStack itemStack) {
        return InventoryHolding.hasTag(itemStack, NBT_MOST_SIG) && InventoryHolding.hasTag(itemStack, NBT_LEAST_SIG);
    }

    public static void setUUID(ItemStack itemStack) {
        InventoryHolding.initNBTTagCompound(itemStack);
        if (!InventoryHolding.hasTag(itemStack, NBT_MOST_SIG) && !InventoryHolding.hasTag(itemStack, NBT_LEAST_SIG)) {
            UUID itemUUID = UUID.randomUUID();
            InventoryHolding.setLong(itemStack, NBT_MOST_SIG, itemUUID.getMostSignificantBits());
            InventoryHolding.setLong(itemStack, NBT_LEAST_SIG, itemUUID.getLeastSignificantBits());
        }
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        InventoryHolding.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74772_a(keyName, keyValue);
    }
}

