/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.common.summoning.meteor.Meteor;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import java.util.Iterator;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.FallingTower")
public class FallingTower {
    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, String[] components) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, 10000, components));
    }

    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, String components) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, 10000, components.split("\\s*,\\s*")));
    }

    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, int cost, String[] components) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, cost, components));
    }

    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, int cost, String components) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, cost, components.split("\\s*,\\s*")));
    }

    @ZenMethod
    public static void addFocus(IItemStack stack, int radius, int cost, String components, String filler, int fillerChance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(MTHelper.toStack(stack), radius, cost, components.split("\\s*,\\s*"), filler.split("\\s*,\\s*"), fillerChance));
    }

    @ZenMethod
    public static void removeFocus(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Add
    implements IUndoableAction {
        private Meteor meteor;

        public Add(ItemStack stack, int radius, int cost, String[] components) {
            new Add(stack, radius, cost, components, null, 0);
        }

        public Add(ItemStack stack, int radius, int cost, String[] components, String[] filler, int fillerChance) {
            this.meteor = new Meteor(stack, radius, cost, fillerChance, MeteorComponent.parseStringArray(components), MeteorComponent.parseStringArray(filler));
            this.meteor.validate();
        }

        public void apply() {
            MeteorRegistry.registerMeteor(this.meteor);
        }

        public boolean canUndo() {
            return MeteorRegistry.meteorList != null;
        }

        public void undo() {
            MeteorRegistry.meteorList.remove(this.meteor);
        }

        public String describe() {
            return "Adding Falling Tower Focus for " + this.meteor.focusItem.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Falling Tower Focus for " + this.meteor.focusItem.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack focus;
        private Meteor paradigm;

        public Remove(ItemStack focus) {
            this.focus = focus;
        }

        public void apply() {
            Iterator<Meteor> itr = MeteorRegistry.meteorList.iterator();
            while (itr.hasNext()) {
                Meteor paradigm = itr.next();
                if (!OreDictionary.itemMatches((ItemStack)paradigm.focusItem, (ItemStack)this.focus, (boolean)false)) continue;
                this.paradigm = paradigm;
                itr.remove();
                break;
            }
        }

        public boolean canUndo() {
            return MeteorRegistry.meteorList != null && this.paradigm != null;
        }

        public void undo() {
            MeteorRegistry.meteorList.add(this.paradigm);
        }

        public String describe() {
            return "Removing Falling Tower Focus for " + this.focus.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Falling Tower Focus for " + this.focus.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

