/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.tileentity;

import cpw.mods.fml.common.FMLLog;
import net.fuzzycraft.botanichorizons.addons.tileentity.SimpleAutomationTileEntity;
import net.fuzzycraft.botanichorizons.util.Facing2D;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.common.block.tile.mana.TilePool;

public abstract class TileAdvancedManaPool
extends SimpleAutomationTileEntity<RecipeManaInfusion> {
    public final int manaCapacity;
    public static final int CYCLE_TICKS = 20;
    public static final int MAX_PARALLELS = 64;
    public static final int ACTIVATE_MANA = 1000;
    protected int cycleRemaining = 0;

    public TileAdvancedManaPool(MultiblockHelper structure, int capacity) {
        super(structure);
        this.manaCapacity = capacity;
    }

    @Override
    protected void updateEntityCrafting() {
        if (!this.isOnline) {
            return;
        }
        if (this.cycleRemaining > 0) {
            --this.cycleRemaining;
        } else if (this.partialStructureValidation()) {
            this.cycleRemaining = 20;
            this.handleCrafts();
            this.handleOutputs();
            this.cleanupInventory(0, 2);
            this.cleanupInventory(2, 4);
            this.func_70296_d();
        } else {
            this.isOnline = false;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index << 1, 3);
        }
    }

    @Override
    public int getAvailableParallels(@NotNull RecipeManaInfusion recipe) {
        int parallel = 64;
        int recipeManaCost = recipe.getManaToConsume();
        if (parallel * recipeManaCost < this.storedMana) {
            return parallel;
        }
        int externalMana = this.getExternalMana();
        int totalReservoir = this.storedMana + externalMana;
        if (recipeManaCost > 0) {
            int manaParallel = totalReservoir / recipeManaCost;
            parallel = Math.min(parallel, manaParallel);
        }
        return parallel;
    }

    @Override
    void consumeNonItemResources(RecipeManaInfusion recipe, int parallel) {
        this.storedMana -= parallel * recipe.getManaToConsume();
        if (this.storedMana < 0) {
            int deficit = -this.storedMana;
            TilePool pool = this.getExternalPool();
            if (pool != null && pool.getCurrentMana() >= deficit) {
                pool.recieveMana(-deficit);
                this.storedMana = 0;
            } else {
                FMLLog.bigWarning((String)"Exploit: External mana is no longer available", (Object[])new Object[0]);
                this.isOnline = false;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing.index << 1, 3);
            }
        }
    }

    @Nullable
    private TilePool getExternalPool() {
        int poolX = this.field_145851_c - 4 * this.facing.dx;
        int poolY = this.field_145848_d + 1;
        int poolZ = this.field_145849_e - 4 * this.facing.dz;
        TileEntity rawPoolTE = this.field_145850_b.func_147438_o(poolX, poolY, poolZ);
        if (rawPoolTE instanceof TilePool) {
            TilePool pool = (TilePool)rawPoolTE;
            return pool;
        }
        FMLLog.warning((String)"Not a pool at %d %d %d", (Object[])new Object[]{poolX, poolY, poolZ});
        return null;
    }

    private int getExternalMana() {
        TilePool pool = this.getExternalPool();
        return pool != null ? pool.getCurrentMana() : 0;
    }

    @Override
    public int getRecipeInputStackSize(@NotNull RecipeManaInfusion recipe) {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getRecipeOutput(@NotNull RecipeManaInfusion recipe) {
        return recipe.getOutput();
    }

    @Override
    public int getManaMaximum() {
        return this.manaCapacity;
    }

    public boolean onWanded(EntityPlayer wandUser) {
        this.facing = Facing2D.fromIndex(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) >> 1 & 3);
        if (!this.isOnline) {
            Exception error = this.structure.checkEntireStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing);
            if (error != null) {
                boolean handled = MultiblockHelper.handleFailedStructure(this.field_145850_b, wandUser, error);
                return false;
            }
            if (this.storedMana <= 1000) {
                return false;
            }
            this.storedMana -= 1000;
            this.cycleRemaining = 20;
            this.isOnline = true;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1 + this.facing.index * 2, 3);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

