/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.gui;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import pl.asie.computronics.gui.IGuiTapeDrive;
import pl.asie.computronics.item.ItemTape;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.util.StringUtil;
import pl.asie.lib.block.ContainerInventory;
import pl.asie.lib.gui.GuiSpecialContainer;

public class GuiTapePlayer
extends GuiSpecialContainer<ContainerInventory> {
    private static final int BUTTON_START_X = 48;
    private static final int BUTTON_START_Y = 58;
    private TapeDriveState.State state = TapeDriveState.State.STOPPED;
    private Button buttonMouse = null;
    private final IGuiTapeDrive tile;

    public GuiTapePlayer(IGuiTapeDrive tile, ContainerInventory container) {
        super((Container)container, "computronics:tape_player", 176, 166);
        this.tile = tile;
    }

    public boolean isButtonPressed(Button button) {
        if (button == this.buttonMouse) {
            return true;
        }
        switch (this.state) {
            case FORWARDING: {
                return button == Button.FAST_FORWARD;
            }
            case PLAYING: {
                return button == Button.PLAY;
            }
            case REWINDING: {
                return button == Button.REWIND;
            }
        }
        return false;
    }

    public void setState(TapeDriveState.State state) {
        if (this.tile != null) {
            this.tile.setState(state);
        }
    }

    public void handleButtonPress(Button button) {
        switch (button) {
            case REWIND: {
                if (this.state == TapeDriveState.State.REWINDING) {
                    this.setState(TapeDriveState.State.STOPPED);
                    break;
                }
                this.setState(TapeDriveState.State.REWINDING);
                break;
            }
            case PLAY: {
                this.setState(TapeDriveState.State.PLAYING);
                break;
            }
            case FAST_FORWARD: {
                if (this.state == TapeDriveState.State.FORWARDING) {
                    this.setState(TapeDriveState.State.STOPPED);
                    break;
                }
                this.setState(TapeDriveState.State.FORWARDING);
                break;
            }
            case STOP: {
                this.setState(TapeDriveState.State.STOPPED);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.state = this.tile.getState();
    }

    public void func_73864_a(int x, int y, int mb) {
        super.func_73864_a(x, y, mb);
        if (mb == 0) {
            for (Button button : Button.values()) {
                int button_x = this.xCenter + 48 + button.ordinal() * 20;
                int button_y = this.yCenter + 58;
                if (x < button_x || x >= button_x + 20 || y < button_y || y >= button_y + 15 || this.isButtonPressed(button)) continue;
                this.buttonMouse = button;
            }
        }
    }

    protected void func_146984_a(Slot slot, int index, int button, int shift) {
        if (slot == null || !this.tile.isLocked(slot, index, button, shift)) {
            super.func_146984_a(slot, index, button, shift);
        }
    }

    protected boolean func_146983_a(int keyCode) {
        return this.tile.shouldCheckHotbarKeys() && super.func_146983_a(keyCode);
    }

    public void func_146286_b(int x, int y, int which) {
        super.func_146286_b(x, y, which);
        if (which >= 0 && this.buttonMouse != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.handleButtonPress(this.buttonMouse);
            this.buttonMouse = null;
        }
    }

    private String getLabel() {
        ItemStack stack = (ItemStack)((ContainerInventory)this.container).func_75138_a().get(0);
        if (stack != null && stack.func_77973_b() instanceof ItemTape) {
            String label = StringUtil.localize("tooltip.computronics.tape.unnamed");
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("label")) {
                label = stack.func_77978_p().func_74779_i("label");
            }
            return label;
        }
        return null;
    }

    protected void func_146976_a(float f, int i, int j) {
        this.state = this.tile.getState();
        super.func_146976_a(f, i, j);
        for (Button button : Button.values()) {
            int button_ty = 170 + button.ordinal() * 15;
            int button_tx = this.isButtonPressed(button) ? 20 : 0;
            int button_x = 48 + button.ordinal() * 20;
            this.func_73729_b(this.xCenter + button_x, this.yCenter + 58, button_tx, button_ty, 20, 15);
        }
        String label = this.getLabel();
        int labelColor = 0xFFFFFF;
        if (label == null) {
            label = StringUtil.localize("tooltip.computronics.tape.none");
            labelColor = 0xFF3333;
        }
        if (label.length() > 24) {
            label = label.substring(0, 22) + "...";
        }
        this.func_73732_a(this.field_146289_q, label, this.xCenter + 88, this.yCenter + 15, labelColor);
    }

    public static enum Button {
        REWIND,
        PLAY,
        STOP,
        FAST_FORWARD;

    }
}

