/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.common.blocks.signals.ISignalTileDefinition;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.railcraft.SignalTypes;
import pl.asie.computronics.integration.railcraft.signalling.MassiveSignalReceiver;
import pl.asie.computronics.integration.railcraft.tile.TileDigitalBoxBase;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.TableUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.railcraft.api.signals.IReceiverTile", modid="Railcraft"), @Optional.Interface(iface="mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider", modid="Railcraft")})
public class TileDigitalReceiverBox
extends TileDigitalBoxBase
implements IReceiverTile,
IAspectProvider {
    private boolean prevBlinkState;
    private final MassiveSignalReceiver receiver = new MassiveSignalReceiver(this.getName(), (TileEntity)this);
    private static LinkedHashMap<Object, Object> aspectMap;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.receiver.tickClient();
            if (this.receiver.getVisualAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getVisualAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setVisualAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.receiver.isPaired()) {
            this.receiver.setVisualAspect(this.receiver.getMostRestrictiveAspect());
        } else {
            this.receiver.setVisualAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getVisualAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        String name = this.receiver.getNameFor(con);
        if (Mods.isLoaded("OpenComputers")) {
            this.eventOC(name, aspect);
        }
        if (Mods.isLoaded("ComputerCraft")) {
            this.eventCC(name, aspect);
        }
        this.updateNeighbors();
        this.sendUpdateToClient();
    }

    private void updateNeighbors() {
        this.notifyBlocksOfNeighborChange();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.receiver.readFromNBT(data);
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.markBlockForUpdate();
    }

    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.receiver.getVisualAspect();
    }

    public boolean canTransferAspect() {
        return true;
    }

    public SignalReceiver getReceiver() {
        return this.receiver;
    }

    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect(null);
    }

    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        return tile != null && tile instanceof TileBoxBase && ((TileBoxBase)tile).canReceiveAspect();
    }

    public ISignalTileDefinition getSignalType() {
        return SignalTypes.DigitalReceiver;
    }

    public TileDigitalReceiverBox() {
        super("digital_receiver_box");
    }

    @Optional.Method(modid="OpenComputers")
    public void eventOC(String name, SignalAspect aspect) {
        if (this.node() != null) {
            this.node().sendToReachable("computer.signal", new Object[]{"aspect_changed", name, aspect.ordinal() + 1});
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void eventCC(String name, SignalAspect aspect) {
        if (this.attachedComputersCC != null) {
            for (IComputerAccess computer : this.attachedComputersCC) {
                computer.queueEvent("aspect_changed", new Object[]{computer.getAttachmentName(), name, aspect.ordinal() + 1});
            }
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("communication", "Signal receiver", "Railcraft, Inc.", "Digitized Signal Receiver X3", new String[0]);
    }

    private Object[] getAspect(String name) {
        SignalAspect aspect = this.receiver.getMostRestrictiveAspectFor(name);
        if (aspect != null) {
            return new Object[]{aspect.ordinal() + 1};
        }
        return new Object[]{null, "no valid signal found"};
    }

    private Object[] removeSignal(String name) {
        Collection<WorldCoordinate> coords = this.receiver.getCoordsFor(name);
        if (!coords.isEmpty()) {
            for (WorldCoordinate coord : coords) {
                this.receiver.clearPairing(coord);
            }
            return new Object[]{true};
        }
        return new Object[]{false, "no valid signal found"};
    }

    private Object[] getSignalNames() {
        return new Object[]{TableUtils.convertSetToMap(this.receiver.getSignalNames())};
    }

    private static Object[] aspects() {
        if (aspectMap == null) {
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < SignalAspect.VALUES.length - 1; ++i) {
                SignalAspect aspect = SignalAspect.VALUES[i];
                String name = aspect.name().toLowerCase(Locale.ENGLISH);
                newMap.put(name, aspect.ordinal() + 1);
                newMap.put(aspect.ordinal() + 1, name);
            }
            aspectMap = newMap;
        }
        return new Object[]{aspectMap};
    }

    @Callback(doc="function(name:string):number; Returns the aspect currently received from a connected signal with the specified name. Returns nil and an error message on failure.", direct=true, limit=32)
    @Optional.Method(modid="OpenComputers")
    public Object[] getAspect(Context context, Arguments args) {
        return this.getAspect(args.checkString(0));
    }

    @Callback(doc="function():number; Returns the most restrictive aspect currently received from connected signals", direct=true, limit=32)
    @Optional.Method(modid="OpenComputers")
    public Object[] getMostRestrictiveAspect(Context context, Arguments args) {
        return new Object[]{this.receiver.getMostRestrictiveAspect().ordinal() + 1};
    }

    @Callback(doc="function(name:string):number; Tries to remove any pairing to a signal with the specified name. Returns true on success.", direct=true, limit=32)
    @Optional.Method(modid="OpenComputers")
    public Object[] unpair(Context context, Arguments args) {
        return this.removeSignal(args.checkString(0));
    }

    @Callback(doc="function():table; Returns a list containing the name of every paired controller.", direct=true, limit=32)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSignalNames(Context c, Arguments a) {
        return this.getSignalNames();
    }

    @Callback(doc="This is a list of every available Signal Aspect in Railcraft", getter=true, direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] aspects(Context c, Arguments a) {
        return TileDigitalReceiverBox.aspects();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getAspect", "getMostRestrictiveAspect", "unpair", "getSignalNames", "aspects"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (method < this.getMethodNames().length) {
            switch (method) {
                case 0: {
                    if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                        throw new LuaException("first argument needs to be a string");
                    }
                    return this.getAspect((String)arguments[0]);
                }
                case 1: {
                    return new Object[]{this.receiver.getMostRestrictiveAspect().ordinal() + 1};
                }
                case 2: {
                    if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                        throw new LuaException("first argument needs to be a string");
                    }
                    return this.removeSignal((String)arguments[0]);
                }
                case 3: {
                    return this.getSignalNames();
                }
                case 4: {
                    return TileDigitalReceiverBox.aspects();
                }
            }
        }
        return null;
    }
}

