/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.ServerChatEvent;
import pl.asie.computronics.api.chat.ChatAPI;
import pl.asie.computronics.api.chat.IChatListener;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.ChatBoxUtils;
import pl.asie.computronics.util.OCUtils;

public class TileChatBox
extends TileEntityPeripheralBase
implements IChatListener {
    private int distance = Config.CHATBOX_DISTANCE;
    private boolean hasDistance = false;
    private int ticksUntilOff = 0;
    private boolean mustRefresh = false;
    private String name = "";

    public TileChatBox() {
        super("chat_box");
    }

    public int requestCurrentRedstoneValue(int side) {
        return this.ticksUntilOff > 0 ? 15 : 0;
    }

    public boolean canUpdate() {
        return Config.MUST_UPDATE_TILE_ENTITIES || Config.REDSTONE_REFRESH;
    }

    public boolean isCreative() {
        return Config.CHATBOX_CREATIVE && this.field_145850_b != null && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) >= 8;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Config.REDSTONE_REFRESH && this.ticksUntilOff > 0) {
            --this.ticksUntilOff;
            if (this.ticksUntilOff == 0 || this.mustRefresh) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int dist) {
        if (dist > Short.MAX_VALUE) {
            dist = Short.MAX_VALUE;
        }
        this.distance = !this.isCreative() ? Math.min(Config.CHATBOX_DISTANCE, dist) : dist;
        this.hasDistance = true;
        if (this.distance < 0) {
            this.distance = Config.CHATBOX_DISTANCE;
            this.hasDistance = false;
        }
    }

    @Override
    public void receiveChatMessage(ServerChatEvent event) {
        if (!this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (!(Config.CHATBOX_MAGIC || this.isCreative() || event.player.field_70170_p == this.field_145850_b && !(event.player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) > (double)(this.distance * this.distance)))) {
            return;
        }
        if (Config.REDSTONE_REFRESH) {
            this.ticksUntilOff = 5;
            this.mustRefresh = true;
        }
        if (Mods.isLoaded("OpenComputers")) {
            this.eventOC(event);
        }
        if (Mods.isLoaded("ComputerCraft")) {
            this.eventCC(event);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        ChatAPI.registry.registerChatListener(this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        ChatAPI.registry.unregisterChatListener(this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        ChatAPI.registry.unregisterChatListener(this);
    }

    @Optional.Method(modid="OpenComputers")
    public void eventOC(ServerChatEvent event) {
        if (this.node() != null) {
            this.node().sendToReachable("computer.signal", new Object[]{"chat_message", event.username, event.message});
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void eventCC(ServerChatEvent event) {
        if (this.attachedComputersCC != null) {
            for (IComputerAccess computer : this.attachedComputersCC) {
                computer.queueEvent("chat_message", new Object[]{computer.getAttachmentName(), event.username, event.message});
            }
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Chat interface", "National Security Agency", "[CLASSIFIED]", new String[0]);
    }

    @Callback(doc="function(text:string [, distance:number]):boolean; Makes the chat box say some text with the currently set or the specified distance. Returns true on success")
    @Optional.Method(modid="OpenComputers")
    public Object[] say(Context context, Arguments args) {
        int d = this.distance;
        if (args.count() >= 1) {
            boolean isCreative = this.isCreative();
            boolean hasDistance = this.hasDistance;
            if (args.isInteger(1)) {
                int n = d = isCreative ? args.checkInteger(1) : Math.min(Config.CHATBOX_DISTANCE, args.checkInteger(1));
                if (d <= 0) {
                    d = this.distance;
                }
                hasDistance = true;
            }
            if (args.isString(0)) {
                ChatBoxUtils.sendChatMessage((TileEntity)this, d, this.name.length() > 0 ? this.name : Config.CHATBOX_PREFIX, args.checkString(0), !hasDistance && (Config.CHATBOX_MAGIC || isCreative));
                return new Object[]{true};
            }
        }
        return new Object[]{false};
    }

    @Callback(doc="function():number; Returns the chat distance the chat box is currently set to", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDistance(Context context, Arguments args) {
        return new Object[]{this.distance};
    }

    @Callback(doc="function(distance:number):number; Sets the distance of the chat box. Returns the new distance", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setDistance(Context context, Arguments args) {
        this.setDistance(args.checkInteger(0));
        return new Object[]{this.distance};
    }

    @Callback(doc="function():string; Returns the name of the chat box", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getName(Context context, Arguments args) {
        return new Object[]{this.name};
    }

    @Callback(doc="function(name:string):string; Sets the name of the chat box. Returns the new name", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setName(Context context, Arguments args) {
        this.name = args.checkString(0);
        return new Object[]{this.name};
    }

    @Override
    public boolean canBeColored() {
        return !this.isCreative() && super.canBeColored();
    }

    @Override
    public int getColor() {
        int color = super.getColor();
        if (this.isCreative()) {
            return 0xFF60FF;
        }
        return color;
    }

    @Override
    public void setColor(int color) {
        if (this.isCreative()) {
            super.setColor(0xFF60FF);
        } else {
            super.setColor(color);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("d")) {
            this.distance = nbt.func_74765_d("d");
        }
        if (nbt.func_74764_b("hd")) {
            this.hasDistance = nbt.func_74767_n("hd");
        }
        if (nbt.func_74764_b("n")) {
            this.name = nbt.func_74779_i("n");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("d", (short)this.distance);
        nbt.func_74757_a("hd", this.hasDistance);
        if (this.name.length() > 0) {
            nbt.func_74778_a("n", this.name);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"say", "getDistance", "setDistance", "getName", "setName"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                if (arguments.length >= 1 && arguments[0] instanceof String) {
                    int d = this.distance;
                    boolean hasDistance = this.hasDistance;
                    boolean isCreative = this.isCreative();
                    if (arguments.length >= 2 && arguments[1] instanceof Double) {
                        int n = d = isCreative ? ((Double)arguments[1]).intValue() : Math.min(Config.CHATBOX_DISTANCE, ((Double)arguments[1]).intValue());
                        if (d <= 0) {
                            d = this.distance;
                        }
                        hasDistance = true;
                    }
                    ChatBoxUtils.sendChatMessage((TileEntity)this, d, this.name.length() > 0 ? this.name : Config.CHATBOX_PREFIX, (String)arguments[0], !hasDistance && (Config.CHATBOX_MAGIC || isCreative));
                    return new Object[]{true};
                }
                return new Object[]{false};
            }
            case 1: {
                return new Object[]{this.distance};
            }
            case 2: {
                if (arguments.length == 1 && arguments[0] instanceof Double) {
                    this.setDistance(((Double)arguments[0]).intValue());
                    return new Object[]{this.distance};
                }
                throw new LuaException("first argument needs to be a number");
            }
            case 3: {
                return new Object[]{this.name};
            }
            case 4: {
                if (arguments.length == 1 && arguments[0] instanceof String) {
                    this.name = (String)arguments[0];
                    return new Object[]{this.name};
                }
                throw new LuaException("first argument needs to be a string");
            }
        }
        return null;
    }
}

