/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.reference.Config;

public class Camera {
    private World world;
    private float xDirection;
    private float yDirection;
    private float zDirection;
    private double oxPos;
    private double oyPos;
    private double ozPos;
    private double xPos;
    private double yPos;
    private double zPos;
    private Object hit;

    public boolean ray(World worldObj, int xCoord, int yCoord, int zCoord, ForgeDirection dir, float x, float y) {
        return this.ray(worldObj, (double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5, dir, x, y, true);
    }

    public boolean ray(World worldObj, double xCoord, double yCoord, double zCoord, ForgeDirection dir, float x, float y, boolean doBlockOffset) {
        this.hit = null;
        if (x < -1.0f || x > 1.0f || y < -1.0f || y > 1.0f) {
            return false;
        }
        if (dir != null) {
            Vec3 target;
            this.xDirection = 0.0f;
            this.yDirection = y;
            this.zDirection = 0.0f;
            double oxOffset = 0.0;
            double oyOffset = 0.0;
            double ozOffset = 0.0;
            switch (dir) {
                case EAST: {
                    this.xDirection = 1.0f;
                    this.zDirection = -x;
                    if (!doBlockOffset) break;
                    xCoord += 0.6;
                    oxOffset = -0.1;
                    break;
                }
                case NORTH: {
                    this.zDirection = -1.0f;
                    this.xDirection = x;
                    if (!doBlockOffset) break;
                    zCoord -= 0.6;
                    ozOffset = 0.1;
                    break;
                }
                case SOUTH: {
                    this.zDirection = 1.0f;
                    this.xDirection = -x;
                    if (!doBlockOffset) break;
                    zCoord += 0.6;
                    ozOffset = -0.1;
                    break;
                }
                case WEST: {
                    this.xDirection = -1.0f;
                    this.zDirection = x;
                    if (!doBlockOffset) break;
                    xCoord -= 0.6;
                    oxOffset = 0.1;
                    break;
                }
                case DOWN: {
                    this.yDirection = -1.0f;
                    this.xDirection = x;
                    this.zDirection = y;
                    if (!doBlockOffset) break;
                    yCoord -= 0.6;
                    oyOffset = 0.1;
                    break;
                }
                case UP: {
                    this.yDirection = 1.0f;
                    this.xDirection = x;
                    this.zDirection = y;
                    if (!doBlockOffset) break;
                    yCoord += 0.6;
                    oyOffset = -0.1;
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            this.world = worldObj;
            this.xPos = xCoord;
            this.yPos = yCoord;
            this.zPos = zCoord;
            this.oxPos = this.xPos;
            this.oyPos = this.yPos;
            this.ozPos = this.zPos;
            if (!this.world.func_147437_c((int)Math.floor(this.xPos), (int)Math.floor(this.yPos), (int)Math.floor(this.zPos))) {
                this.hit = this.world.func_147439_a((int)Math.floor(this.xPos), (int)Math.floor(this.yPos), (int)Math.floor(this.zPos));
                return true;
            }
            float steps = Config.CAMERA_DISTANCE;
            Vec3 origin = Vec3.func_72443_a((double)this.xPos, (double)this.yPos, (double)this.zPos);
            MovingObjectPosition mop = this.world.func_72933_a(origin, target = Vec3.func_72443_a((double)(this.xPos + (double)(this.xDirection * steps)), (double)(this.yPos + (double)(this.yDirection * steps)), (double)(this.zPos + (double)(this.zDirection * steps))));
            if (mop != null) {
                this.xPos = mop.field_72307_f.field_72450_a;
                this.yPos = mop.field_72307_f.field_72448_b;
                this.zPos = mop.field_72307_f.field_72449_c;
                this.oxPos += oxOffset;
                this.oyPos += oyOffset;
                this.ozPos += ozOffset;
                switch (mop.field_72313_a) {
                    case ENTITY: {
                        this.hit = mop.field_72308_g;
                        break;
                    }
                    case BLOCK: {
                        this.hit = this.world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public double getDistance() {
        if (this.hit == null) {
            return -1.0;
        }
        double x = this.xPos - this.oxPos;
        double y = this.yPos - this.oyPos;
        double z = this.zPos - this.ozPos;
        return Math.sqrt(x * x + y * y + z * z);
    }
}

