/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import pl.asie.computronics.util.ParticleUtils;

public class NoteUtils {
    private static final String[] instruments = new String[]{"harp", "bd", "snare", "hat", "bassattack", "pling", "bass"};

    public static void playNoteRaw(World world, int x, int y, int z, String instrument, int note, float volume) {
        float f = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, instrument, volume, f);
        ParticleUtils.sendParticlePacket("note", world, (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, (double)note / 24.0, 1.0, 0.0);
    }

    public static NoteTask playNote(World world, int x, int y, int z, String instrument, int note, float volume) {
        return new NoteTask(NoteUtils.checkInstrument(instrument), NoteUtils.checkNote(note), volume);
    }

    public static NoteTask playNote(World world, int x, int y, int z, String instrument, int note) {
        return new NoteTask(NoteUtils.checkInstrument(instrument), NoteUtils.checkNote(note), 3.0f);
    }

    public static NoteTask playNote(World world, int x, int y, int z, int instrument, int note) {
        return NoteUtils.playNote(world, x, y, z, instrument, note, -1.0f);
    }

    public static NoteTask playNote(World world, int x, int y, int z, int instrument, int note, float volume) {
        if (instrument < 0) {
            int b0 = 0;
            if (y > 0) {
                Material m = world.func_147439_a(x, y - 1, z).func_149688_o();
                if (m == Material.field_151576_e) {
                    b0 = 1;
                }
                if (m == Material.field_151595_p) {
                    b0 = 2;
                }
                if (m == Material.field_151592_s) {
                    b0 = 3;
                }
                if (m == Material.field_151575_d) {
                    b0 = 4;
                }
            }
            instrument = b0;
        }
        return new NoteTask(instrument %= 7, NoteUtils.checkNote(note), volume < 0.0f ? 3.0f : volume);
    }

    public static float toVolume(int index, double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("bad argument #" + index + " (number between 0 and 1 expected, got " + value + ")");
        }
        return Math.min(Math.max((float)value * 3.0f, 0.0f), 3.0f);
    }

    public static float toVolume(Object[] arguments, int index) {
        double value = 1.0;
        if (arguments.length > index && arguments[index] instanceof Double) {
            value = (Double)arguments[index];
        }
        return NoteUtils.toVolume(index + 1, value);
    }

    public static String checkInstrument(String instrument) {
        for (String s : instruments) {
            if (!s.equals(instrument)) continue;
            return "note." + instrument;
        }
        throw new IllegalArgumentException("invalid instrument: " + instrument);
    }

    public static int checkNote(int note) {
        if (note >= 0) {
            return note;
        }
        throw new IllegalArgumentException("invalid note: " + note);
    }

    public static class NoteTask {
        private String instrument;
        private int instrumentID = -1;
        private int note;
        private final float volume;

        public NoteTask(String instrument, int note, float volume) {
            this.instrument = instrument;
            this.note = note;
            this.volume = volume;
        }

        public NoteTask(int instrumentID, int note, float volume) {
            this.instrumentID = instrumentID;
            this.note = note;
            this.volume = volume;
        }

        public void play(World world, int x, int y, int z) {
            if (this.instrument == null && this.instrumentID >= 0) {
                if (this.instrumentID <= 4) {
                    NoteBlockEvent.Play e = new NoteBlockEvent.Play(world, x, y, z, Short.MAX_VALUE, this.note, this.instrumentID);
                    if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                        return;
                    }
                    this.instrumentID = e.instrument.ordinal();
                    this.note = e.getVanillaNoteId();
                }
                this.instrument = instruments[0];
                if (this.instrumentID > 0 && this.instrumentID < instruments.length) {
                    this.instrument = instruments[this.instrumentID];
                }
                this.instrument = "note." + this.instrument;
            }
            if (this.instrument != null) {
                NoteUtils.playNoteRaw(world, x, y, z, this.instrument, this.note, this.volume);
            }
        }
    }
}

