/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.sound;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pl.asie.computronics.util.sound.AudioType;
import pl.asie.computronics.util.sound.AudioUtil;

public abstract class Instruction {
    public abstract void encounter(AudioUtil.AudioProcess var1);

    public static Instruction load(NBTTagCompound tag) {
        byte type = tag.func_74771_c("t");
        switch (type) {
            case 0: {
                return new Open(tag.func_74771_c("c"));
            }
            case 1: {
                return new Close(tag.func_74771_c("c"));
            }
            case 2: {
                return new SetWave(tag);
            }
            case 3: {
                return new Delay(tag);
            }
            case 4: {
                return new SetFM(tag);
            }
            case 5: {
                return new ResetFM(tag.func_74771_c("c"));
            }
            case 6: {
                return new SetAM(tag);
            }
            case 7: {
                return new ResetAM(tag.func_74771_c("c"));
            }
            case 8: {
                return new SetADSR(tag);
            }
            case 9: {
                return new ResetEnvelope(tag.func_74771_c("c"));
            }
            case 10: {
                return new SetVolume(tag);
            }
            case 11: {
                return new SetFrequency(tag);
            }
            case 12: {
                return new SetWhiteNoise(tag.func_74771_c("c"));
            }
            case 13: {
                return new SetLFSR(tag);
            }
        }
        return null;
    }

    public static void save(NBTTagCompound tag, Instruction inst) {
        if (inst instanceof ChannelSpecific) {
            tag.func_74774_a("c", (byte)((ChannelSpecific)inst).channelIndex);
        }
        if (inst instanceof Open) {
            tag.func_74774_a("t", (byte)0);
        } else if (inst instanceof Close) {
            tag.func_74774_a("t", (byte)1);
        } else if (inst instanceof SetWave) {
            tag.func_74774_a("t", (byte)2);
            tag.func_74768_a("w", ((SetWave)inst).type.ordinal());
        } else if (inst instanceof Delay) {
            tag.func_74774_a("t", (byte)3);
            tag.func_74768_a("d", ((Delay)inst).delay);
        } else if (inst instanceof SetFM) {
            tag.func_74774_a("t", (byte)4);
            tag.func_74768_a("m", ((SetFM)inst).freqMod.modulatorIndex);
            tag.func_74776_a("i", ((SetFM)inst).freqMod.index);
        } else if (inst instanceof ResetFM) {
            tag.func_74774_a("t", (byte)5);
        } else if (inst instanceof SetAM) {
            tag.func_74774_a("t", (byte)6);
            tag.func_74768_a("m", ((SetAM)inst).ampMod.modulatorIndex);
        } else if (inst instanceof ResetAM) {
            tag.func_74774_a("t", (byte)7);
        } else if (inst instanceof SetADSR) {
            tag.func_74774_a("t", (byte)8);
            AudioUtil.ADSR envelope = ((SetADSR)inst).envelope;
            tag.func_74768_a("a", envelope.attackDuration);
            tag.func_74768_a("d", envelope.decayDuration);
            tag.func_74776_a("s", envelope.attenuation);
            tag.func_74768_a("r", envelope.releaseDuration);
        } else if (inst instanceof ResetEnvelope) {
            tag.func_74774_a("t", (byte)9);
        } else if (inst instanceof SetVolume) {
            tag.func_74774_a("t", (byte)10);
            tag.func_74776_a("v", ((SetVolume)inst).volume);
        } else if (inst instanceof SetFrequency) {
            tag.func_74774_a("t", (byte)11);
            tag.func_74776_a("f", ((SetFrequency)inst).frequency);
        } else if (inst instanceof SetWhiteNoise) {
            tag.func_74774_a("t", (byte)12);
        } else if (inst instanceof SetLFSR) {
            tag.func_74774_a("t", (byte)13);
            tag.func_74768_a("i", ((SetLFSR)inst).initial);
            tag.func_74768_a("m", ((SetLFSR)inst).mask);
        }
    }

    public static Queue<Instruction> fromNBT(NBTTagList l) {
        ArrayDeque<Instruction> instructions = new ArrayDeque<Instruction>();
        for (int i = 0; i < l.func_74745_c(); ++i) {
            Instruction instr;
            NBTTagCompound tag = l.func_150305_b(i);
            if (tag.func_82582_d() || (instr = Instruction.load(tag)) == null) continue;
            instructions.add(instr);
        }
        return instructions;
    }

    public static void toNBT(NBTTagList l, Queue<Instruction> instructions) {
        for (Instruction instruction : instructions) {
            NBTTagCompound tag = new NBTTagCompound();
            Instruction.save(tag, instruction);
            l.func_74742_a((NBTBase)tag);
        }
    }

    public static interface Ticking {
    }

    public static abstract class ChannelSpecific
    extends Instruction {
        public final int channelIndex;

        public ChannelSpecific(int channelIndex) {
            this.channelIndex = channelIndex;
        }

        @Override
        public final void encounter(AudioUtil.AudioProcess process) {
            this.encounter(process, (AudioUtil.State)process.states.get(this.channelIndex));
        }

        public abstract void encounter(AudioUtil.AudioProcess var1, AudioUtil.State var2);
    }

    public static class SetLFSR
    extends ChannelSpecific {
        public final int initial;
        public final int mask;

        public SetLFSR(int channelIndex, int initial, int mask) {
            super(channelIndex);
            this.initial = initial;
            this.mask = mask;
        }

        public SetLFSR(NBTTagCompound tag) {
            this(tag.func_74771_c("c"), tag.func_74762_e("i"), tag.func_74762_e("m"));
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.generator = new AudioUtil.LFSR(this.initial, this.mask);
        }
    }

    public static class SetWhiteNoise
    extends ChannelSpecific {
        public SetWhiteNoise(int channelIndex) {
            super(channelIndex);
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.generator = new AudioUtil.WhiteNoise();
        }
    }

    public static class SetFrequency
    extends ChannelSpecific {
        public final float frequency;

        public SetFrequency(int channelIndex, float frequency) {
            super(channelIndex);
            this.frequency = frequency;
        }

        public SetFrequency(NBTTagCompound tag) {
            super(tag.func_74771_c("c"));
            this.frequency = tag.func_74760_g("f");
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.frequencyInHz = this.frequency;
        }
    }

    public static class SetVolume
    extends ChannelSpecific {
        public final float volume;

        public SetVolume(int channelIndex, float volume) {
            super(channelIndex);
            this.volume = Math.min(Math.max(volume, 0.0f), 1.0f);
        }

        public SetVolume(NBTTagCompound tag) {
            super(tag.func_74771_c("c"));
            this.volume = tag.func_74760_g("v");
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.volume = this.volume;
        }
    }

    public static class ResetEnvelope
    extends ChannelSpecific {
        public ResetEnvelope(int channelIndex) {
            super(channelIndex);
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.envelope = null;
        }
    }

    public static class SetADSR
    extends ChannelSpecific {
        public final AudioUtil.ADSR envelope;

        public SetADSR(int channelIndex, int attackDuration, int decayDuration, float attenuation, int releaseDuration) {
            super(channelIndex);
            this.envelope = new AudioUtil.ADSR(attackDuration, decayDuration, attenuation, releaseDuration);
        }

        public SetADSR(NBTTagCompound tag) {
            super(tag.func_74771_c("c"));
            this.envelope = new AudioUtil.ADSR(tag.func_74762_e("a"), tag.func_74762_e("d"), tag.func_74760_g("s"), tag.func_74762_e("r"));
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            if (state.envelope != null) {
                this.envelope.progress = state.envelope.progress;
                this.envelope.phase = state.envelope.phase;
            }
            state.envelope = this.envelope;
        }
    }

    public static class ResetAM
    extends ChannelSpecific {
        public ResetAM(int channelIndex) {
            super(channelIndex);
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            if (state.ampMod == null) {
                return;
            }
            AudioUtil.State mstate = (AudioUtil.State)process.states.get(state.ampMod.modulatorIndex);
            if (mstate != null) {
                mstate.isAmpMod = false;
            }
            state.ampMod = null;
        }
    }

    public static class SetAM
    extends ChannelSpecific {
        public final AudioUtil.AmplitudeModulation ampMod;

        public SetAM(int channelIndex, int modulatorIndex) {
            super(channelIndex);
            this.ampMod = new AudioUtil.AmplitudeModulation(modulatorIndex);
        }

        public SetAM(NBTTagCompound tag) {
            super(tag.func_74771_c("c"));
            this.ampMod = new AudioUtil.AmplitudeModulation(tag.func_74762_e("m"));
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            AudioUtil.State mstate;
            if (state.isAmpMod || state.isFreqMod) {
                return;
            }
            if (state.ampMod != null && (mstate = (AudioUtil.State)process.states.get(state.ampMod.modulatorIndex)) != null) {
                mstate.isAmpMod = false;
            }
            if ((mstate = (AudioUtil.State)process.states.get(this.ampMod.modulatorIndex)) != null) {
                mstate.isAmpMod = true;
                state.ampMod = this.ampMod;
            }
        }
    }

    public static class ResetFM
    extends ChannelSpecific {
        public ResetFM(int channelIndex) {
            super(channelIndex);
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            if (state.freqMod == null) {
                return;
            }
            AudioUtil.State mstate = (AudioUtil.State)process.states.get(state.freqMod.modulatorIndex);
            if (mstate != null) {
                mstate.isFreqMod = false;
            }
            state.freqMod = null;
        }
    }

    public static class SetFM
    extends ChannelSpecific {
        public final AudioUtil.FrequencyModulation freqMod;

        public SetFM(int channelIndex, int modulatorIndex, float index) {
            super(channelIndex);
            this.freqMod = new AudioUtil.FrequencyModulation(modulatorIndex, index);
        }

        public SetFM(NBTTagCompound tag) {
            super(tag.func_74771_c("c"));
            this.freqMod = new AudioUtil.FrequencyModulation(tag.func_74762_e("m"), tag.func_74760_g("i"));
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            AudioUtil.State mstate;
            if (state.isAmpMod || state.isFreqMod) {
                return;
            }
            if (state.freqMod != null && (mstate = (AudioUtil.State)process.states.get(state.freqMod.modulatorIndex)) != null) {
                mstate.isFreqMod = false;
            }
            if ((mstate = (AudioUtil.State)process.states.get(this.freqMod.modulatorIndex)) != null) {
                mstate.isFreqMod = true;
                state.freqMod = this.freqMod;
            }
        }
    }

    public static class Delay
    extends Instruction
    implements Ticking {
        public final int delay;

        public Delay(int delay) {
            this.delay = delay;
        }

        public Delay(NBTTagCompound tag) {
            this.delay = tag.func_74762_e("d");
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process) {
            process.delay = this.delay;
        }
    }

    public static class SetWave
    extends ChannelSpecific {
        public final AudioType type;

        public SetWave(int channelIndex, AudioType type) {
            super(channelIndex);
            this.type = type;
        }

        public SetWave(NBTTagCompound tag) {
            super(tag.func_74771_c("c"));
            this.type = AudioType.fromIndex(tag.func_74771_c("w"));
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.generator = new AudioUtil.Wave(this.type);
        }
    }

    public static class Close
    extends ChannelSpecific {
        public Close(int channelIndex) {
            super(channelIndex);
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.gate = AudioUtil.Gate.Closed;
        }
    }

    public static class Open
    extends ChannelSpecific {
        public Open(int channelIndex) {
            super(channelIndex);
        }

        @Override
        public void encounter(AudioUtil.AudioProcess process, AudioUtil.State state) {
            state.gate = AudioUtil.Gate.Open;
            if (state.envelope != null) {
                state.envelope.reset();
            }
        }
    }
}

