/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.gregtechCrops;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class GarnydniaCrop
extends BasicCrop {
    public int tier() {
        return 7;
    }

    public String name() {
        return "Garnydinia";
    }

    @Override
    public String discoveredBy() {
        return "moronwmachinegun";
    }

    public String[] attributes() {
        return new String[]{"Shiny", "Crystal", "Red", "Yellow", "Metal"};
    }

    public int stat(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)Math.floor((double)humidity / 0.5 + (double)nutrients / 2.0 + (double)air / 0.5);
    }

    public int maxSize() {
        return 3;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 1;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (!super.canGrow(crop)) {
            return false;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            return this.isBlockBelow(crop);
        }
        return true;
    }

    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return crop.getSize() >= this.maxSize() - 1 ? 550 : 300;
    }

    public boolean isBlockBelow(ICropTile aCrop) {
        if (aCrop == null) {
            return false;
        }
        for (int i = 1; i < this.getrootslength(aCrop); ++i) {
            Block tBlock = aCrop.getWorld().func_147439_a(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            if (tBlock instanceof BlockOresAbstract) {
                Materials tMaterial;
                TileEntity tTileEntity = aCrop.getWorld().func_147438_o(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
                if (!(tTileEntity instanceof TileEntityOres) || (tMaterial = GregTechAPI.sGeneratedMaterials[((TileEntityOres)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                return tMaterial == Materials.GarnetRed || tMaterial == Materials.GarnetYellow;
            }
            int tMetaID = aCrop.getWorld().func_72805_g(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            ItemData tAssotiation = GTOreDictUnificator.getAssociation((ItemStack)new ItemStack(tBlock, 1, tMetaID));
            if (tAssotiation == null || !tAssotiation.mPrefix.toString().startsWith("ore") && tAssotiation.mPrefix != OrePrefixes.block || tAssotiation.mMaterial.mMaterial != Materials.GarnetRed && tAssotiation.mMaterial.mMaterial != Materials.GarnetYellow) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getSize() >= this.maxSize();
    }

    public ItemStack getGain(ICropTile iCropTile) {
        Materials dropMat = XSTR.XSTR_INSTANCE.nextInt(100) >= 50 ? Materials.GarnetRed : Materials.GarnetYellow;
        int chance = XSTR.XSTR_INSTANCE.nextInt(100);
        ItemStack drop = chance >= 95 ? GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemExquisite, (Object)dropMat, (long)1L) : (chance >= 80 ? dropMat.getGems(1) : (chance == 42 ? GTOreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)Materials.GarnetSand, (long)1L) : (chance >= 40 ? dropMat.getDust(1) : (chance == 23 ? GTOreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)dropMat, (long)1L) : (chance >= 20 ? dropMat.getDustSmall(1) : (chance == 13 || chance == 17 ? GTOreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)dropMat, (long)1L) : dropMat.getDustTiny(1)))))));
        return drop;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Needs a block or ore of Yellow or Red Garnet below to fully mature.", "Has decreased humidity and air requirements (x0.5)", "Has increased nutrient requirements (x2.0)");
    }

    @Override
    public ItemStack getDisplayItem() {
        return Materials.GarnetRed.getGems(1);
    }
}

