/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.natura;

import com.github.bartimaeusnek.croploadcore.OreDict;
import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.abstracts.BasicBerryCrop;
import gregtech.api.enums.Mods;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import mods.natura.common.NContent;
import net.minecraft.item.ItemStack;

public class BlackberryCrop
extends BasicBerryCrop {
    private static final String cropOreName = "cropBlackberry";

    public BlackberryCrop() {
        OreDict.BSget((String)cropOreName, (CropCard)this);
    }

    public String name() {
        return "Blackberry";
    }

    @Override
    public String discoveredBy() {
        return "Ancient cultures";
    }

    public String[] attributes() {
        return new String[]{"Berry", "Food", "Black"};
    }

    public ItemStack getGain(ICropTile crop) {
        if (Mods.Natura.isModLoaded()) {
            return new ItemStack(NContent.berryItem, 3, 2);
        }
        return CCropUtility.getCopiedOreStack(cropOreName);
    }

    @Override
    public ItemStack getDisplayItem() {
        if (Mods.Natura.isModLoaded()) {
            return new ItemStack(NContent.berryItem, 3, 2);
        }
        return OreDict.ISget((String)cropOreName);
    }
}

