/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.container;

import com.brandon3055.draconicevolution.common.inventory.SlotOpaqueBlock;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetectorAdvanced;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerPlayerDetector
extends Container {
    private boolean shouldShowInventory = true;
    private final TilePlayerDetectorAdvanced detector;

    public ContainerPlayerDetector(InventoryPlayer playerInventory, TilePlayerDetectorAdvanced detector) {
        this.detector = detector;
        this.bindPlayerInventory(playerInventory);
        this.addContainerSlots(detector);
        this.updateContainerSlots();
    }

    private void bindPlayerInventory(InventoryPlayer invPlayer) {
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 8 + 18 * x, 174));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)invPlayer, x + y * 9 + 9, 8 + 18 * x, 116 + y * 18));
            }
        }
    }

    public void addContainerSlots(TilePlayerDetectorAdvanced tileDetector) {
        this.func_75146_a(new SlotOpaqueBlock(tileDetector, 0, 145, 15));
    }

    public void updateContainerSlots() {
        for (Slot slot : this.field_75151_b) {
            if (slot instanceof SlotOpaqueBlock) {
                if (this.shouldShowInventory) {
                    slot.field_75223_e = 143;
                    slot.field_75221_f = 20;
                    continue;
                }
                slot.field_75223_e = -1000;
                slot.field_75221_f = -1000;
                continue;
            }
            if (this.shouldShowInventory) {
                if (slot.field_75222_d < 9) {
                    slot.field_75223_e = 8 + 18 * slot.field_75222_d;
                    slot.field_75221_f = 174;
                    continue;
                }
                if (slot.field_75222_d >= 36) continue;
                slot.field_75223_e = 8 + 18 * (slot.field_75222_d % 9);
                slot.field_75221_f = 116 + (slot.field_75222_d / 9 - 1) * 18;
                continue;
            }
            slot.field_75223_e = -1000;
            slot.field_75221_f = -1000;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.detector.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        return null;
    }

    public boolean shouldShowInventory() {
        return this.shouldShowInventory;
    }

    public void setShouldShowInventory(boolean shouldShow) {
        this.shouldShowInventory = shouldShow;
        this.updateContainerSlots();
    }

    public TilePlayerDetectorAdvanced getDetector() {
        return this.detector;
    }
}

