/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.world;

import com.brandon3055.brandonscore.common.handlers.IProcess;
import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.brandonscore.common.utills.SimplexNoise;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.entity.EntityChaosCrystal;
import com.brandon3055.draconicevolution.common.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.TileChaosShard;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class ChaosWorldGenHandler {
    public static void generateChunk(World world, int chunkX, int chunkZ, DataUtills.XZPair<Integer, Integer> islandCenter, Random random) {
        DataUtills.XZPair<Integer, Integer> closestSpawn;
        DataUtills.XZPair<Integer, Integer> xZPair = closestSpawn = islandCenter == null ? ChaosWorldGenHandler.getClosestChaosSpawn(chunkX, chunkZ) : islandCenter;
        if ((Integer)closestSpawn.x == 0 && (Integer)closestSpawn.z == 0) {
            return;
        }
        int posX = chunkX * 16;
        int posZ = chunkZ * 16;
        int copyStartDistance = 180;
        if (Math.abs(posX - (Integer)closestSpawn.x) > copyStartDistance || Math.abs(posZ - (Integer)closestSpawn.z) > copyStartDistance) {
            return;
        }
        if ((Integer)closestSpawn.x > posX && (Integer)closestSpawn.x <= posX + 16 && (Integer)closestSpawn.z > posZ && (Integer)closestSpawn.z <= posZ + 16) {
            ChaosWorldGenHandler.generateStructures(world, closestSpawn, random);
        }
        for (int trueX = posX; trueX < posX + 16; ++trueX) {
            for (int y = 0; y < 255; ++y) {
                for (int trueZ = posZ; trueZ < posZ + 16; ++trueZ) {
                    double density;
                    double plateauFalloff;
                    int x = trueX - (Integer)closestSpawn.x;
                    int z = trueZ - (Integer)closestSpawn.z;
                    int size = 80;
                    double dist = Math.sqrt(x * x + (y - 16) * (y - 16) + z * z);
                    double xd = (double)x / (double)size;
                    double yd = (double)y / 32.0;
                    double zd = (double)z / (double)size;
                    double diameterScale = 150.0;
                    double centerFalloff = 1.0 / (dist * 0.05);
                    if (centerFalloff < 0.0) {
                        centerFalloff = 0.0;
                    }
                    if ((plateauFalloff = yd < 0.4 ? yd * 2.5 : (yd <= 0.6 ? 1.0 : (yd > 0.6 && yd < 1.0 ? 1.0 - (yd - 0.6) * 2.5 : 0.0))) == 0.0 || centerFalloff == 0.0) continue;
                    double heightMapFalloff = 0.0;
                    for (int octave = 1; octave < 5; ++octave) {
                        heightMapFalloff += (SimplexNoise.noise((double)(xd * (double)octave + (double)((Integer)closestSpawn.x).intValue()), (double)(zd * (double)octave + (double)((Integer)closestSpawn.z).intValue())) + 1.0) * 0.5 * 0.01 * ((double)octave * 10.0 * 1.0 - dist * 0.001);
                    }
                    if (heightMapFalloff <= 0.0) {
                        heightMapFalloff = 0.0;
                    }
                    if ((heightMapFalloff += (0.5 - Math.abs(yd - 0.5)) * 0.15) == 0.0 || !((density = centerFalloff * plateauFalloff * heightMapFalloff) > 0.1) || world.func_147439_a(x + (Integer)closestSpawn.x, y + 64, z + (Integer)closestSpawn.z) != Blocks.field_150350_a) continue;
                    world.func_147449_b(x + (Integer)closestSpawn.x, y + 64, z + (Integer)closestSpawn.z, dist > 60.0 || dist > (double)random.nextInt(60) ? Blocks.field_150377_bs : Blocks.field_150343_Z);
                }
            }
        }
    }

    public static void generateStructures(World world, DataUtills.XZPair<Integer, Integer> islandCenter, Random random) {
        int outerRadius = 330;
        int shardY = 80;
        int coreHeight = 10;
        int coreWidth = 20;
        for (int y = shardY - coreHeight; y <= shardY + coreHeight; ++y) {
            int h = Math.abs(y - shardY);
            int inRadius = h - 3;
            double yp = (double)(coreHeight - h) / (double)coreHeight;
            int outRadius = (int)(yp * (double)coreWidth);
            outRadius -= outRadius * outRadius / 100;
            ChaosWorldGenHandler.genCoreSlice(world, (Integer)islandCenter.x, y, (Integer)islandCenter.z, inRadius, shardY, coreWidth, true, random);
            ChaosWorldGenHandler.genCoreSlice(world, (Integer)islandCenter.x, y, (Integer)islandCenter.z, outRadius, shardY, coreWidth, false, random);
        }
        world.func_147449_b(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue(), (Block)ModBlocks.chaosCrystal);
        TileChaosShard tileChaosShard = (TileChaosShard)world.func_147438_o(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue());
        tileChaosShard.locationHash = tileChaosShard.getLocationHash((Integer)islandCenter.x, shardY, (Integer)islandCenter.z, world.field_73011_w.field_76574_g);
        EntityChaosGuardian guardian = new EntityChaosGuardian(world);
        guardian.func_70634_a(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue());
        world.func_72838_d((Entity)guardian);
        int rings = 4;
        int width = 20;
        int spacing = 8;
        for (int x = (Integer)islandCenter.x - outerRadius; x <= (Integer)islandCenter.x + outerRadius; ++x) {
            for (int z = (Integer)islandCenter.z - outerRadius; z <= (Integer)islandCenter.z + outerRadius; ++z) {
                int dist = (int)Utills.getDistanceAtoB((double)x, (double)z, (double)((Integer)islandCenter.x).intValue(), (double)((Integer)islandCenter.z).intValue());
                for (int i = 0; i < rings; ++i) {
                    if (dist >= outerRadius - (width + spacing) * i || dist < outerRadius - width - (width + spacing) * i) continue;
                    int y = 90 + (int)((double)((Integer)islandCenter.x - x) * 0.1) + (random.nextInt(10) - 5);
                    if (0.1f > random.nextFloat()) {
                        world.func_147465_d(x, y, z, Blocks.field_150377_bs, 0, 2);
                    }
                    if (!(0.001f > random.nextFloat())) continue;
                    world.func_147465_d(x, y, z, (Block)ModBlocks.draconiumOre, 0, 2);
                }
            }
        }
        ChaosWorldGenHandler.generateObelisks(world, islandCenter, random);
    }

    public static void genCoreSlice(World world, int xi, int yi, int zi, int ringRadius, int yc, int coreRadious, boolean fillIn, Random rand) {
        for (int x = xi - coreRadious; x <= xi + coreRadious; ++x) {
            for (int z = zi - coreRadious; z <= zi + coreRadious; ++z) {
                Block b;
                double oRad;
                double dist = Utills.getDistanceAtoB((double)x, (double)yi, (double)z, (double)xi, (double)yc, (double)zi);
                if (dist > (oRad = (double)(coreRadious - Math.abs(yc - yi) * Math.abs(yc - yi) / 10)) - 3.0 && rand.nextDouble() * 3.0 < dist - (oRad - 3.0)) continue;
                if (fillIn && (int)Utills.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) <= ringRadius) {
                    if ((int)dist < 9) {
                        world.func_147449_b(x, yi, z, (Block)ModBlocks.infusedObsidian);
                        continue;
                    }
                    world.func_147449_b(x, yi, z, Blocks.field_150343_Z);
                    continue;
                }
                if (!fillIn && (int)Utills.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) >= ringRadius) {
                    world.func_147449_b(x, yi, z, Blocks.field_150343_Z);
                    continue;
                }
                if (fillIn || (int)Utills.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) > ringRadius || (b = world.func_147439_a(x, yi, z)) != Blocks.field_150350_a && b != Blocks.field_150377_bs && b != Blocks.field_150343_Z) continue;
                world.func_147449_b(x, yi, z, ModBlocks.chaosShardAtmos);
            }
        }
    }

    public static DataUtills.XZPair<Integer, Integer> getClosestChaosSpawn(int chunkX, int chunkZ) {
        return new DataUtills.XZPair((Object)Utills.getNearestMultiple((int)(chunkX * 16), (int)ConfigHandler.chaosIslandSeparation), (Object)Utills.getNearestMultiple((int)(chunkZ * 16), (int)ConfigHandler.chaosIslandSeparation));
    }

    private static void generateObelisks(World world, DataUtills.XZPair<Integer, Integer> islandCenter, Random rand) {
        int sZ;
        int sX;
        double rotation;
        int i;
        for (i = 0; i < 7; ++i) {
            rotation = (double)i * 0.9;
            sX = (Integer)islandCenter.x + (int)(Math.sin(rotation) * 45.0);
            sZ = (Integer)islandCenter.z + (int)(Math.cos(rotation) * 45.0);
            ChaosWorldGenHandler.generateObelisk(world, sX, 90, sZ, false, rand);
        }
        for (i = 0; i < 14; ++i) {
            rotation = (double)i * 0.45;
            sX = (Integer)islandCenter.x + (int)(Math.sin(rotation) * 90.0);
            sZ = (Integer)islandCenter.z + (int)(Math.cos(rotation) * 90.0);
            ChaosWorldGenHandler.generateObelisk(world, sX, 90, sZ, true, rand);
        }
    }

    private static void generateObelisk(World world, int x1, int y1, int z1, boolean outer, Random rand) {
        if (!outer) {
            world.func_147465_d(x1, y1 + 20, z1, (Block)ModBlocks.infusedObsidian, 0, 2);
            if (!world.field_72995_K) {
                EntityChaosCrystal crystal = new EntityChaosCrystal(world);
                crystal.func_70107_b((double)x1 + 0.5, y1 + 21, (double)z1 + 0.5);
                world.func_72838_d((Entity)crystal);
            }
            for (int y = y1; y < y1 + 20; ++y) {
                world.func_147465_d(x1, y, z1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 + 1, y, z1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 - 1, y, z1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1, y, z1 + 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1, y, z1 - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 + 1, y, z1 + 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 - 1, y, z1 - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 + 1, y, z1 - 1, Blocks.field_150343_Z, 0, 2);
                world.func_147465_d(x1 - 1, y, z1 + 1, Blocks.field_150343_Z, 0, 2);
            }
        } else {
            int z;
            int y;
            world.func_147465_d(x1, y1 + 40, z1, (Block)ModBlocks.infusedObsidian, 0, 2);
            if (!world.field_72995_K) {
                EntityChaosCrystal crystal = new EntityChaosCrystal(world);
                crystal.func_70107_b((double)x1 + 0.5, y1 + 41, (double)z1 + 0.5);
                world.func_72838_d((Entity)crystal);
            }
            int diff = 0;
            for (int y2 = y1 + 20; y2 < y1 + 40; ++y2) {
                double pct = (double)(++diff) / 25.0;
                int r = 3;
                for (int x = x1 - r; x <= x1 + r; ++x) {
                    for (int z2 = z1 - r; z2 <= z1 + r; ++z2) {
                        if (!(Utills.getDistanceAtoB((double)x, (double)z2, (double)x1, (double)z1) <= (double)r) || !(pct > rand.nextDouble())) continue;
                        world.func_147465_d(x, y2, z2, Blocks.field_150343_Z, 0, 2);
                    }
                }
            }
            int cageS = 2;
            for (int x = x1 - cageS; x <= x1 + cageS; ++x) {
                for (y = y1 - cageS; y <= y1 + cageS; ++y) {
                    if (0.8f > rand.nextFloat()) {
                        world.func_147465_d(x, y + 41, z1 + cageS, Blocks.field_150411_aY, 0, 2);
                    }
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_147465_d(x, y + 41, z1 - cageS, Blocks.field_150411_aY, 0, 2);
                }
            }
            for (z = z1 - cageS; z <= z1 + cageS; ++z) {
                for (y = y1 - cageS; y <= y1 + cageS; ++y) {
                    if (0.8f > rand.nextFloat()) {
                        world.func_147465_d(x1 + cageS, y + 41, z, Blocks.field_150411_aY, 0, 2);
                    }
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_147465_d(x1 - cageS, y + 41, z, Blocks.field_150411_aY, 0, 2);
                }
            }
            for (z = z1 - cageS; z <= z1 + cageS; ++z) {
                for (int x = x1 - cageS; x <= x1 + cageS; ++x) {
                    if (!(0.8f > rand.nextFloat())) continue;
                    world.func_147465_d(x, y1 + 44, z, (Block)Blocks.field_150333_U, 6, 2);
                }
            }
        }
    }

    public static class CrystalRemover
    implements IProcess {
        private boolean dead = false;
        private Entity entity;
        private int delay = 2;

        public CrystalRemover(Entity entity) {
            this.entity = entity;
        }

        public void updateProcess() {
            if (this.delay > 0) {
                --this.delay;
            } else {
                boolean flag = true;
                int y = (int)this.entity.field_70163_u - 1;
                while (flag) {
                    flag = false;
                    for (int x = (int)Math.floor(this.entity.field_70165_t) - 4; x <= (int)Math.floor(this.entity.field_70165_t) + 4; ++x) {
                        for (int z = (int)Math.floor(this.entity.field_70161_v) - 4; z <= (int)Math.floor(this.entity.field_70161_v) + 4; ++z) {
                            Block block = this.entity.field_70170_p.func_147439_a(x, y, z);
                            if (block != Blocks.field_150357_h && block != Blocks.field_150343_Z) continue;
                            flag = true;
                            this.entity.field_70170_p.func_147468_f(x, y, z);
                        }
                    }
                    if (!flag) continue;
                    --y;
                }
                this.entity.func_70106_y();
                this.dead = true;
            }
        }

        public boolean isDead() {
            return this.dead;
        }
    }
}

