/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractItemConduit;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduit.liquid.CrystallineEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.CrystallinePinkSlimeEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduit;
import crazypants.enderio.conduit.liquid.MelodicEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.StellarEnderLiquidConduit;
import crazypants.enderio.config.Config;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemLiquidConduit
extends AbstractItemConduit
implements IAdvancedTooltipProvider {
    private static ItemConduitSubtype[] subtypes = new ItemConduitSubtype[]{new ItemConduitSubtype(ModObject.itemLiquidConduit.name(), "enderio:itemLiquidConduit"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "Advanced", "enderio:itemLiquidConduitAdvanced"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "Ender", "enderio:itemLiquidConduitEnder"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "CrystallineEnder", "enderio:itemLiquidConduitCrystallineEnder"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "CrystallinePinkSlimeEnder", "enderio:itemLiquidConduitCrystallinePinkSlimeEnder"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "MelodicEnder", "enderio:itemLiquidConduitMelodicEnder"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "StellarEnder", "enderio:itemLiquidConduitStellarEnder")};

    public static ItemLiquidConduit create() {
        ItemLiquidConduit result = new ItemLiquidConduit();
        result.init();
        return result;
    }

    protected ItemLiquidConduit() {
        super(ModObject.itemLiquidConduit, subtypes);
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public IConduit createConduit(ItemStack stack, EntityPlayer player) {
        switch (stack.func_77960_j()) {
            case 0: {
                return new LiquidConduit();
            }
            case 1: {
                return new AdvancedLiquidConduit();
            }
            case 2: {
                return new EnderLiquidConduit();
            }
            case 3: {
                return new CrystallineEnderLiquidConduit();
            }
            case 4: {
                return new CrystallinePinkSlimeEnderLiquidConduit();
            }
            case 5: {
                return new MelodicEnderLiquidConduit();
            }
            case 6: {
                return new StellarEnderLiquidConduit();
            }
        }
        throw new IllegalArgumentException("Unrecognized ender fluid conduit type: " + stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        int maxIo;
        int extractRate;
        switch (itemstack.func_77960_j()) {
            case 0: {
                extractRate = Config.fluidConduitExtractRate;
                maxIo = Config.fluidConduitMaxIoRate;
                break;
            }
            case 1: {
                extractRate = Config.advancedFluidConduitExtractRate;
                maxIo = Config.advancedFluidConduitMaxIoRate;
                break;
            }
            case 2: {
                extractRate = EnderLiquidConduit.TYPE.getMaxExtractPerTick();
                maxIo = EnderLiquidConduit.TYPE.getMaxIoPerTick();
                break;
            }
            case 3: {
                extractRate = CrystallineEnderLiquidConduit.TYPE.getMaxExtractPerTick();
                maxIo = CrystallineEnderLiquidConduit.TYPE.getMaxIoPerTick();
                break;
            }
            case 4: {
                extractRate = CrystallinePinkSlimeEnderLiquidConduit.TYPE.getMaxExtractPerTick();
                maxIo = CrystallinePinkSlimeEnderLiquidConduit.TYPE.getMaxIoPerTick();
                break;
            }
            case 5: {
                extractRate = MelodicEnderLiquidConduit.TYPE.getMaxExtractPerTick();
                maxIo = MelodicEnderLiquidConduit.TYPE.getMaxIoPerTick();
                break;
            }
            case 6: {
                extractRate = StellarEnderLiquidConduit.TYPE.getMaxExtractPerTick();
                maxIo = StellarEnderLiquidConduit.TYPE.getMaxIoPerTick();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized ender fluid conduit type: " + itemstack.func_77960_j());
            }
        }
        String mbt = " " + EnderIO.lang.localize("fluid.millibucketsTick");
        list.add(EnderIO.lang.localize("itemLiquidConduit.tooltip.maxExtract") + " " + extractRate + mbt);
        list.add(EnderIO.lang.localize("itemLiquidConduit.tooltip.maxIo") + " " + maxIo + mbt);
        if (itemstack.func_77960_j() == 0) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"enderio.itemLiquidConduit");
        } else if (itemstack.func_77960_j() > 1) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"enderio.itemLiquidConduitEnder");
        }
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return true;
    }
}

