/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import java.util.Iterator;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech_nh")})
public class ItemStellarArmor
extends ItemDarkSteelArmor
implements IDarkSteelItem.IStellarItem,
IHazardProtector {
    public static final ItemArmor.ArmorMaterial MATERIAL = EnumHelper.addArmorMaterial((String)"stellarAlloy", (int)75, (int[])new int[]{8, 14, 18, 7}, (int)25);

    public ItemStellarArmor(int armorType) {
        super(MATERIAL, "stellar", armorType);
    }

    public static ItemStellarArmor create(int armorType) {
        ItemStellarArmor res = new ItemStellarArmor(armorType);
        res.init();
        return res;
    }

    public static ItemStellarArmor forArmorType(int armorType) {
        switch (armorType) {
            case 0: {
                return DarkSteelItems.itemStellarHelmet;
            }
            case 1: {
                return DarkSteelItems.itemStellarChestplate;
            }
            case 2: {
                return DarkSteelItems.itemStellarLeggings;
            }
            case 3: {
                return DarkSteelItems.itemStellarBoots;
            }
        }
        return null;
    }

    public static int getPoweredProtectionIncrease(int armorType) {
        switch (armorType) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FIVE.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        Iterator<IDarkSteelUpgrade> iter = DarkSteelRecipeManager.instance.recipeIterator();
        while (iter.hasNext()) {
            IDarkSteelUpgrade upgrade = iter.next();
            if (upgrade instanceof EnergyUpgrade || !upgrade.canAddToItem(is)) continue;
            upgrade.writeToItem(is);
        }
        par3List.add(is);
    }

    @Optional.Method(modid="gregtech_nh")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return true;
    }
}

