/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.ranged;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.ranged.IRanged;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class RangeEntity
extends Entity {
    int totalLife;
    int lifeSpan;
    private Vector3d lastRange;
    private AxisAlignedBB lastBounds;
    private final IRanged spawnGuard;
    private int color;
    private AxisAlignedBB rangeBounds;
    private Vector3d range;

    public RangeEntity(IRanged sg) {
        super(sg.getWorld());
        this.lifeSpan = this.totalLife = 20;
        this.spawnGuard = sg;
        BlockCoord bc = this.spawnGuard.getLocation();
        this.func_70107_b((double)bc.x - 0.01, (double)bc.y - 0.01, (double)bc.z - 0.01);
        this.field_70158_ak = true;
        this.color = sg.getColor();
        this.lastRange = this.spawnGuard.getRange();
        this.lastBounds = this.spawnGuard.getBounds();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.spawnGuard.getBounds() != null ? this.spawnGuard.getBounds() : AxisAlignedBB.func_72330_a((double)(this.field_70165_t - this.lastRange.x), (double)(this.field_70163_u - this.lastRange.y), (double)(this.field_70161_v - this.lastRange.z), (double)(this.field_70165_t + this.lastRange.x + 1.0), (double)(this.field_70163_u + this.lastRange.y + 1.0), (double)(this.field_70161_v + this.lastRange.z + 1.0));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.lifeSpan;
        BlockCoord bc = this.spawnGuard.getLocation();
        this.updateRange();
        if (!(this.field_70170_p.func_147438_o(bc.x, bc.y, bc.z) instanceof IRanged)) {
            this.func_70106_y();
        }
        if (!this.spawnGuard.isShowingRange()) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    private void updateRange() {
        if (this.lastRange != null && !this.lastRange.equals(this.spawnGuard.getRange())) {
            this.lastRange = this.spawnGuard.getRange();
        } else if (this.lastBounds != null && !this.lastBounds.equals(this.spawnGuard.getBounds())) {
            this.lastBounds = this.spawnGuard.getBounds();
        }
    }

    public float[] getColor() {
        return new float[]{(float)(this.color >> 16 & 0xFF) / 255.0f, (float)(this.color >> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f};
    }
}

