/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.slicensplice.ContainerSliceAndSplice;
import crazypants.enderio.machine.slicensplice.GuiSliceAndSplice;
import crazypants.enderio.machine.slicensplice.SliceAndSpliceRecipeManager;
import crazypants.enderio.power.PowerDisplayUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class SliceAndSpliceRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"enderio.nei.slicensplice");
    }

    public String getGuiTexture() {
        return GuiContainerBaseEIO.getGuiTexture("sliceAndSplice").toString();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSliceAndSplice.class;
    }

    public String getOverlayIdentifier() {
        return "EnderIOSliceAndSplice";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(91, 37, 22, 17), "EnderIOSliceAndSplice", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null) {
            return;
        }
        ArrayList<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>(SliceAndSpliceRecipeManager.getInstance().getRecipes());
        for (IRecipe iRecipe : recipes) {
            ItemStack output = iRecipe.getOutputs()[0].getOutput();
            if (result.func_77973_b() != output.func_77973_b() || result.func_77960_j() != output.func_77960_j()) continue;
            SliceAndSpliceRecipe res = new SliceAndSpliceRecipe(iRecipe);
            this.arecipes.add(res);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("EnderIOSliceAndSplice") && ((Object)((Object)this)).getClass() == SliceAndSpliceRecipeHandler.class) {
            ArrayList<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>(SliceAndSpliceRecipeManager.getInstance().getRecipes());
            for (IRecipe iRecipe : recipes) {
                SliceAndSpliceRecipe res = new SliceAndSpliceRecipe(iRecipe);
                this.arecipes.add(res);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>(SliceAndSpliceRecipeManager.getInstance().getRecipes());
        for (IRecipe iRecipe : recipes) {
            if (!iRecipe.isValidInput(0, ingredient)) continue;
            SliceAndSpliceRecipe res = new SliceAndSpliceRecipe(iRecipe);
            res.setIngredientPermutation(res.input, ingredient);
            this.arecipes.add(res);
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)16, (int)0, (int)29, (int)11, (int)142, (int)65);
    }

    public void drawExtras(int recipeIndex) {
        this.drawProgressBar(91, 38, 177, 14, 23, 17, 120, 0);
        SliceAndSpliceRecipe recipe = (SliceAndSpliceRecipe)((Object)this.arecipes.get(recipeIndex));
        String energyString = PowerDisplayUtil.formatPower(recipe.getEnergy()) + " " + PowerDisplayUtil.abrevation();
        GuiDraw.drawString((String)energyString, (int)100, (int)57, (int)0x808080, (boolean)false);
    }

    public List<ItemStack> getInputs(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] equivs = input.getEquivelentInputs();
        if (equivs != null) {
            for (ItemStack st : equivs) {
                result.add(st);
            }
        }
        return result;
    }

    public class SliceAndSpliceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ArrayList<PositionedStack> input;
        private PositionedStack output;
        private int energy;

        public int getEnergy() {
            return this.energy;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SliceAndSpliceRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public SliceAndSpliceRecipe(IRecipe recipe) {
            Point pos;
            super((TemplateRecipeHandler)SliceAndSpliceRecipeHandler.this);
            this.input = new ArrayList();
            int yOff = 11;
            int xOff = 13;
            for (RecipeInput recipeInput : recipe.getInputs()) {
                if (recipeInput == null) continue;
                pos = ContainerSliceAndSplice.INPUT_SLOTS[recipeInput.getSlotNumber()];
                this.input.add(new PositionedStack(SliceAndSpliceRecipeHandler.this.getInputs(recipeInput), pos.x - xOff, pos.y - yOff));
            }
            pos = ContainerSliceAndSplice.INPUT_SLOTS[6];
            this.input.add(new PositionedStack((Object)new ItemStack(Items.field_151036_c), pos.x - xOff, pos.y - yOff));
            pos = ContainerSliceAndSplice.INPUT_SLOTS[7];
            this.input.add(new PositionedStack((Object)new ItemStack((Item)Items.field_151097_aZ), pos.x - xOff, pos.y - yOff));
            if (recipe.getOutputs()[0] != null) {
                this.output = new PositionedStack((Object)recipe.getOutputs()[0].getOutput(), ContainerSliceAndSplice.OUTPUT_SLOT.x - xOff, ContainerSliceAndSplice.OUTPUT_SLOT.y - yOff);
            }
            this.energy = recipe.getEnergyRequired();
        }
    }
}

