/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import cpw.mods.fml.relauncher.ReflectionHelper;
import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.Log;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.TeleportHelper;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityConcussionCreeper
extends EntityCreeper
implements IEnderZooMob {
    public static final String NAME = "enderzoo.ConcussionCreeper";
    public static final int EGG_BG_COL = 5701518;
    public static final int EGG_FG_COL = 16714274;
    private Field fTimeSinceIgnited;
    private Field fFuseTime;

    public EntityConcussionCreeper(World world) {
        super(world);
        try {
            this.fTimeSinceIgnited = ReflectionHelper.findField(EntityCreeper.class, (String[])new String[]{"timeSinceIgnited", "field_70833_d"});
            this.fFuseTime = ReflectionHelper.findField(EntityCreeper.class, (String[])new String[]{"fuseTime", "field_82225_f"});
        }
        catch (Exception e) {
            Log.error("Could not create ender creeper  logic as fields not found");
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        MobInfo.CONCUSSION_CREEPER.applyAttributes((EntityLivingBase)this);
    }

    public void func_70071_h_() {
        int fuseTime;
        int timeSinceIgnited;
        if (this.func_70089_S() && (timeSinceIgnited = this.getTimeSinceIgnited()) >= (fuseTime = this.getFuseTime()) - 1) {
            this.setTimeSinceIgnited(0);
            int range = Config.concussionCreeperExplosionRange;
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)range), (double)(this.field_70163_u - (double)range), (double)(this.field_70161_v - (double)range), (double)(this.field_70165_t + (double)range), (double)(this.field_70163_u + (double)range), (double)(this.field_70161_v + (double)range));
            List ents = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
            for (EntityLivingBase ent : ents) {
                if (ent == this) continue;
                if (!this.field_70170_p.field_72995_K) {
                    boolean done = false;
                    for (int i = 0; i < 20 && !done; ++i) {
                        done = TeleportHelper.teleportRandomly(ent, Config.concussionCreeperMaxTeleportRange);
                    }
                }
                if (!(ent instanceof EntityPlayer)) continue;
                this.field_70170_p.func_72908_a(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
                EnderZoo.proxy.setInstantConfusionOnPlayer((EntityPlayer)ent, Config.concussionCreeperConfusionDuration);
            }
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0);
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
        int j = this.field_70146_Z.nextInt(3);
        if (looting > 0) {
            j += this.field_70146_Z.nextInt(looting + 1);
        }
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(this.func_146068_u(), 1);
        }
    }

    protected Item func_146068_u() {
        int num = this.field_70146_Z.nextInt(3);
        if (num == 0) {
            return EnderZoo.itemEnderFragment;
        }
        if (num == 1) {
            return EnderZoo.itemConfusingDust;
        }
        return Items.field_151016_H;
    }

    private void setTimeSinceIgnited(int i) {
        if (this.fTimeSinceIgnited == null) {
            return;
        }
        try {
            this.fTimeSinceIgnited.setInt(this, i);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getTimeSinceIgnited() {
        if (this.fTimeSinceIgnited == null) {
            return 0;
        }
        try {
            return this.fTimeSinceIgnited.getInt(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int getFuseTime() {
        if (this.fFuseTime == null) {
            return 0;
        }
        try {
            return this.fFuseTime.getInt(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

