/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.core.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import de.keridos.floodlights.FloodLights;
import de.keridos.floodlights.tileentity.TileEntityCarbonFloodlight;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MessageTileEntityFL
implements IMessage {
    public int x;
    public int y;
    public int z;
    public int timeRemaining;
    public int color;
    public int rfStorage;
    public byte orientation;
    public byte state;
    public boolean rotationState;
    public boolean wasActive;
    public String customName;
    public String owner;

    public MessageTileEntityFL() {
    }

    public MessageTileEntityFL(TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityFL) {
            TileEntityFL tileEntityFL = (TileEntityFL)tileEntity;
            this.x = tileEntityFL.field_145851_c;
            this.y = tileEntityFL.field_145848_d;
            this.z = tileEntityFL.field_145849_e;
            this.orientation = (byte)tileEntityFL.getOrientation().ordinal();
            this.state = (byte)tileEntityFL.getState();
            this.customName = tileEntityFL.getCustomName();
            this.owner = tileEntityFL.getOwner();
            this.color = tileEntityFL.getColor();
            this.timeRemaining = tileEntity instanceof TileEntityCarbonFloodlight ? ((TileEntityCarbonFloodlight)tileEntity).timeRemaining : 0;
            this.rotationState = tileEntity instanceof TileEntitySmallFloodlight ? ((TileEntitySmallFloodlight)tileEntity).getRotationState() : false;
            this.rfStorage = tileEntity instanceof TileEntityFLElectric ? ((TileEntityFLElectric)tileEntity).getEnergyStored(ForgeDirection.UNKNOWN) : 0;
            this.wasActive = tileEntity instanceof TileEntityMetaFloodlight ? ((TileEntityMetaFloodlight)tileEntity).getWasActive() : false;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.timeRemaining = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        int ownerLength = buf.readInt();
        this.owner = new String(buf.readBytes(ownerLength).array());
        this.rotationState = buf.readBoolean();
        this.color = buf.readInt();
        this.rfStorage = buf.readInt();
        this.wasActive = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.timeRemaining);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        buf.writeInt(this.owner.length());
        buf.writeBytes(this.owner.getBytes());
        buf.writeBoolean(this.rotationState);
        buf.writeInt(this.color);
        buf.writeInt(this.rfStorage);
        buf.writeBoolean(this.wasActive);
    }

    public String toString() {
        return String.format("MessageTileEntityFL - x:%s, y:%s, z:%s, timeRemaining:%s, orientation:%s, state:%s, customName:%s, owner:%s", this.x, this.y, this.z, this.timeRemaining, this.orientation, this.state, this.customName, this.owner);
    }

    public static class MessageHandlerTileEntityFL
    implements IMessageHandler<MessageTileEntityFL, IMessage> {
        public IMessage onMessage(MessageTileEntityFL message, MessageContext ctx) {
            TileEntity tileEntity = FloodLights.proxy.getWorld().func_147438_o(message.x, message.y, message.z);
            if (tileEntity instanceof TileEntityFL) {
                TileEntityFL tileEntityFL = (TileEntityFL)tileEntity;
                tileEntityFL.setOrientation(message.orientation);
                tileEntityFL.setState(message.state);
                tileEntityFL.setCustomName(message.customName);
                tileEntityFL.setOwner(message.owner);
                tileEntityFL.setColor(message.color);
            }
            if (tileEntity instanceof TileEntityCarbonFloodlight) {
                ((TileEntityCarbonFloodlight)tileEntity).timeRemaining = message.timeRemaining;
            }
            if (tileEntity instanceof TileEntitySmallFloodlight) {
                ((TileEntitySmallFloodlight)tileEntity).setRotationState(message.rotationState);
            }
            if (tileEntity instanceof TileEntityFLElectric) {
                ((TileEntityFLElectric)tileEntity).setEnergyStored(message.rfStorage);
            }
            if (tileEntity instanceof TileEntityMetaFloodlight) {
                ((TileEntityMetaFloodlight)tileEntity).setWasActive(message.wasActive);
            }
            return null;
        }
    }
}

