/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenSequoia
extends WorldGenTree {
    public WorldGenSequoia(ITreeGenData tree) {
        this(tree, 20, 5);
    }

    protected WorldGenSequoia(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree, baseHeight, heightVariation);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        this.generateSupportStems(world, this.height, this.girth, 0.4f, 0.4f);
        int topHeight = this.height / 3 + world.field_73012_v.nextInt(this.height / 6);
        ArrayList<ChunkCoordinates> branchCoords = new ArrayList<ChunkCoordinates>();
        for (int yBranch = topHeight; yBranch < this.height; ++yBranch) {
            int branchLength = Math.round(this.height - yBranch) / 2;
            if (branchLength > 4) {
                branchLength = 4;
            }
            branchCoords.addAll(this.generateBranches(world, yBranch, 0, 0, 0.05f, 0.25f, branchLength, 1, 0.5f));
        }
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.field_71572_b, branchEnd.field_71574_a, branchEnd.field_71573_c, 1.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        int leafSpawn = this.height + 2;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        while (leafSpawn > topHeight) {
            this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn, 0.0f, 1, this.leaf);
    }
}

