/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.core.items.ItemForestry;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class ItemForestryTool
extends ItemForestry {
    private final ItemStack remnants;
    private float efficiencyOnProperMaterial;

    public ItemForestryTool(ItemStack remnants) {
        this.field_77777_bU = 1;
        this.efficiencyOnProperMaterial = 6.0f;
        this.func_77656_e(200);
        this.remnants = remnants;
        if (remnants != null) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        }
    }

    public void setEfficiencyOnProperMaterial(float efficiencyOnProperMaterial) {
        this.efficiencyOnProperMaterial = efficiencyOnProperMaterial;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        if (ForgeHooks.isToolEffective((ItemStack)itemstack, (Block)block, (int)metadata)) {
            return this.efficiencyOnProperMaterial;
        }
        return super.getDigSpeed(itemstack, block, metadata);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return ForgeHooks.canToolHarvestBlock((Block)block, (int)0, (ItemStack)stack);
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase entityliving) {
        if (block.func_149712_f(world, x, y, z) != 0.0f) {
            itemstack.func_77972_a(1, entityliving);
        }
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public class EventHandler {
        @SubscribeEvent
        public void onDestroyCurrentItem(PlayerDestroyItemEvent event) {
            if (event.original == null || event.original.func_77973_b() != ItemForestryTool.this) {
                return;
            }
            EntityPlayer player = event.entityPlayer;
            World world = player.field_70170_p;
            if (!world.field_72995_K && ItemForestryTool.this.remnants != null) {
                ItemStackUtil.dropItemStackAsEntity(ItemForestryTool.this.remnants.func_77946_l(), world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
    }
}

