/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.inventory.MergedInventories;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public enum IngredientsStorage {
    INTERNAL_INVENTORY,
    PLAYER_INVENTORY,
    ALL_INVENTORIES;

    public static final IngredientsStorage[] VALUES;

    public static IngredientsStorage fromInt(int value) {
        if ((value %= VALUES.length) < 0) {
            value += VALUES.length;
        }
        return VALUES[value];
    }

    public IngredientsStorage next() {
        return IngredientsStorage.fromInt(this.ordinal() + 1);
    }

    public IngredientsStorage previous() {
        return IngredientsStorage.fromInt(this.ordinal() - 1);
    }

    public IInventory getInventory(IInventory internal, EntityPlayer player) {
        switch (this) {
            case PLAYER_INVENTORY: {
                return player.field_71071_by;
            }
            case ALL_INVENTORIES: {
                return new MergedInventories(internal, (IInventory)player.field_71071_by);
            }
        }
        return internal;
    }

    static {
        VALUES = IngredientsStorage.values();
    }
}

