/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.bartworksHandler;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.MainMod;
import bartworks.common.items.SimpleSubItemClass;
import bartworks.common.loaders.BioItemList;
import bartworks.util.BWUtil;
import bartworks.util.BioCulture;
import com.dreammaster.bartworksHandler.BacteriaRegistry;
import com.dreammaster.main.MainRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.fluid.GTFluidFactory;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.api.util.recipe.Sievert;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BioItemLoader {
    private static Item BIOTEMS;
    private static Fluid[] BIOFLUIDS;

    public static boolean preInit() {
        try {
            BIOTEMS = new SimpleSubItemClass(new String[]{"itemCollagen", "itemGelatin", "itemAgar"}).func_77637_a(MainMod.BIO_TAB);
            GameRegistry.registerItem((Item)BIOTEMS, (String)"GTNHBioItems", (String)Mods.BartWorks.ID);
            BIOFLUIDS = new Fluid[]{GTFluidFactory.builder((String)"GelatinMixture").withLocalizedName("Gelatin Mixture").withTextureName("molten.autogenerated").withColorRGBA(new short[]{255, 255, 125}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid(), GTFluidFactory.builder((String)"MeatExtract").withLocalizedName("Meat Extract").withTextureName("molten.autogenerated").withColorRGBA(new short[]{160, 70, 50}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid(), GTFluidFactory.builder((String)"UnknownNutrientAgar").withLocalizedName("Unknown Nutrient Agar").withTextureName("molten.autogenerated").withColorRGBA(new short[]{175, 133, 0}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid(), GTFluidFactory.builder((String)"SeaweedBroth").withLocalizedName("Seaweed Broth").withTextureName("molten.autogenerated").withColorRGBA(new short[]{60, 200, 0}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid()};
            return true;
        }
        catch (Exception e) {
            MainRegistry.Logger.error((Object)e);
            return false;
        }
    }

    public static void registerRecipes() {
        if (BIOTEMS == null || BIOFLUIDS == null) {
            throw new IllegalStateException("Called registerRecipes without calling preInit first.");
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.MeatRaw.getDust(2), new ItemStack(Items.field_151103_aS, 1)}).itemOutputs(new ItemStack[]{new ItemStack(BIOTEMS, 2, 0)}).fluidInputs(new FluidStack[]{Materials.DilutedSulfuricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(1000L)}).duration(1600).eut(TierEU.RECIPE_HV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.MeatRaw.getDust(1), Materials.Bone.getDust(2)}).itemOutputs(new ItemStack[]{new ItemStack(BIOTEMS, 1, 0)}).fluidInputs(new FluidStack[]{Materials.DilutedSulfuricAcid.getFluid(500L)}).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(500L)}).duration(800).eut(TierEU.RECIPE_HV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{new ItemStack(BIOTEMS, 4, 0), Materials.Water.getCells(3)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(3)}).fluidInputs(new FluidStack[]{Materials.PhosphoricAcid.getFluid(1000L)}).fluidOutputs(new FluidStack[]{new FluidStack(BIOFLUIDS[0], 4000)}).duration(1600).eut(TierEU.RECIPE_HV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{new ItemStack(BIOTEMS, 4, 0), Materials.PhosphoricAcid.getCells(1)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidInputs(new FluidStack[]{Materials.Water.getFluid(3000L)}).fluidOutputs(new FluidStack[]{new FluidStack(BIOFLUIDS[0], 4000)}).duration(1600).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{Materials.Phosphorus.getDust(1), new ItemStack(BIOTEMS, 4, 1)}).fluidInputs(new FluidStack[]{new FluidStack(BIOFLUIDS[0], 6000)}).duration(2400).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)11), new ItemStack(BIOTEMS, 1, 1)}).itemOutputs(new ItemStack[]{new ItemStack(BIOTEMS, 1, 2)}).fluidInputs(new FluidStack[]{GTModHandler.getDistilledWater((long)1000L)}).duration(600).eut(TierEU.RECIPE_HV).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.MeatRaw.getDust(1)}).fluidOutputs(new FluidStack[]{new FluidStack(BIOFLUIDS[1], 125)}).duration(300).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{new ItemStack(BIOTEMS, 8, 2), ItemList.Circuit_Chip_Stemcell.get(16L, new Object[0]), Materials.Salt.getDust(64)}).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"unknowwater", (int)4000), Materials.PhthalicAcid.getFluid(3000L), new FluidStack(BIOFLUIDS[1], 1000)}).fluidOutputs(new FluidStack[]{new FluidStack(BIOFLUIDS[2], 8000)}).duration(1200).eut(TierEU.RECIPE_UV).addTo((IRecipeMap)RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.IC2_Energium_Dust.get(8L, new Object[0]), Materials.Mytryl.getDust(1), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"seaweedItem", (long)64L)}).special((Object)BioItemList.getPetriDish((BioCulture)BacteriaRegistry.CultureSet.get("TcetiEBac"))).fluidInputs(new FluidStack[]{new FluidStack(BIOFLUIDS[2], 50)}).fluidOutputs(new FluidStack[]{new FluidStack(BIOFLUIDS[3], 50)}).duration(1200).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.GLASS, (Object)8).metadata(GTRecipeConstants.SIEVERT, (Object)new Sievert(100, false)).addTo((IRecipeMap)BartWorksRecipeMaps.bacterialVatRecipes);
        for (int i = 0; i < OreDictionary.getOres((String)"cropTcetiESeaweed").size(); ++i) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)(i + 1))}).itemOutputs(new ItemStack[]{((ItemStack)OreDictionary.getOres((String)"cropTcetiESeaweed").get(i)).func_77946_l().func_77979_a(64)}).fluidInputs(new FluidStack[]{new FluidStack(BIOFLUIDS[3], 1000)}).duration(40).eut(TierEU.RECIPE_UV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.MeatRaw.getDust(4), Materials.Salt.getDust(4), Materials.Calcium.getDust(4), new ItemStack(BIOTEMS, 4, 2)}).special((Object)BioItemList.getPetriDish((BioCulture)BacteriaRegistry.CultureSet.get("OvumBac"))).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"binnie.bacteria", (int)4)}).fluidOutputs(new FluidStack[]{Materials.GrowthMediumRaw.getFluid(1L)}).duration(1200).eut(TierEU.RECIPE_IV).metadata(GTRecipeConstants.GLASS, (Object)5).metadata(GTRecipeConstants.SIEVERT, (Object)new Sievert(BWUtil.calculateSv((Materials)Materials.Uranium), false)).addTo((IRecipeMap)BartWorksRecipeMaps.bacterialVatRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.MeatRaw.getDust(8), Materials.Salt.getDust(8), Materials.Calcium.getDust(8), new ItemStack(BIOTEMS, 4, 2)}).special((Object)BioItemList.getPetriDish((BioCulture)BacteriaRegistry.CultureSet.get("OvumBac"))).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"bacterialsludge", (int)4)}).fluidOutputs(new FluidStack[]{Materials.GrowthMediumRaw.getFluid(2L)}).duration(1200).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.GLASS, (Object)6).metadata(GTRecipeConstants.SIEVERT, (Object)new Sievert(BWUtil.calculateSv((Materials)Materials.Plutonium), false)).addTo((IRecipeMap)BartWorksRecipeMaps.bacterialVatRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.MeatRaw.getDust(12), Materials.Salt.getDust(12), Materials.Calcium.getDust(12), new ItemStack(BIOTEMS, 4, 2)}).special((Object)BioItemList.getPetriDish((BioCulture)BacteriaRegistry.CultureSet.get("OvumBac"))).fluidInputs(new FluidStack[]{FluidRegistry.getFluidStack((String)"mutagen", (int)4)}).fluidOutputs(new FluidStack[]{Materials.GrowthMediumRaw.getFluid(4L)}).duration(1200).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.GLASS, (Object)7).metadata(GTRecipeConstants.SIEVERT, (Object)new Sievert(BWUtil.calculateSv((Materials)Materials.NaquadahEnriched), true)).addTo((IRecipeMap)BartWorksRecipeMaps.bacterialVatRecipes);
    }
}

