/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modfixes.oilgen;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modfixes.ModFixBase;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.IntHelper;
import eu.usrv.yamcore.auxiliary.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

public class OilGeneratorFix
extends ModFixBase {
    private Block _mBuildCraftOilBlock = GameRegistry.findBlock((String)"BuildCraft|Energy", (String)"blockOil");
    public static String ModFixName = "OilGeneratorFix";
    private LogHelper _mLog = MainRegistry.Logger;

    public OilGeneratorFix() {
        super(ModFixName);
    }

    @Override
    public boolean getIsActive() {
        return this._mBuildCraftOilBlock != null;
    }

    @Override
    public boolean init() {
        if (this._mBuildCraftOilBlock == null) {
            this._mLog.error((Object)"Unable to find BuildCraft Oil Block. ModFix will not spawn anything");
            return false;
        }
        this._mLog.info((Object)"Found BC Oil block. Ready for worldgen");
        return true;
    }

    @Override
    public boolean needsForgeEventBus() {
        return true;
    }

    @Override
    public boolean needsFMLEventBus() {
        return false;
    }

    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        try {
            if (this._mBuildCraftOilBlock == null) {
                return;
            }
            int tMinDist = MainRegistry.CoreConfig.OilFixConfig.OilDepostMinDistance;
            if (tMinDist > 1 && (event.chunkX % tMinDist != 0 || event.chunkZ % tMinDist != 0)) {
                return;
            }
            boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
            if (!doGen) {
                return;
            }
            int worldX = event.chunkX << 4;
            int worldZ = event.chunkZ << 4;
            this.generateOil(event.world, event.rand, worldX + event.rand.nextInt(16), worldZ + event.rand.nextInt(16), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateOil(World world, Random rand, int xx, int zz, boolean testFirst) {
        Vec3 pos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        if (this.shouldSpawnOil(world, rand, xx, zz, pos)) {
            int groundLevel;
            int x = (int)pos.field_72450_a;
            int cy = (int)pos.field_72448_b;
            int z = (int)pos.field_72449_c;
            int tMinRadius = MainRegistry.CoreConfig.OilFixConfig.OilSphereMinRadius;
            int tMaxRadius = MainRegistry.CoreConfig.OilFixConfig.OilSphereMaxSize;
            int r = rand.nextInt(tMaxRadius + 1 - tMinRadius) + tMinRadius;
            if (testFirst && this.checkOilPresent(world, x, cy, z, r)) {
                return;
            }
            if (YAMCore.isDebug()) {
                this._mLog.info((Object)String.format("About to generate OilSphere, centered at %d/%d/%d, radius %d", x, cy, z, r));
            }
            if ((groundLevel = this.getTopBlock(world, x, z)) < 5) {
                if (YAMCore.isDebug()) {
                    this._mLog.warn((Object)"OilGenerator stopped; World-height is below 5");
                }
                return;
            }
            this.buildOilStructure(world, rand, x, cy, z, r, groundLevel, this._mBuildCraftOilBlock, true);
        }
    }

    public void buildOilStructure(World pWorld, Random pRand, int pSphereX, int pSphereY, int pSphereZ, int pRadius, int pGroundLevel, Block pTargetBlock, boolean pCheckValidLocation) {
        int y;
        EDEPOSIT_SIZE eSize;
        int tSpringHeight = 0;
        if (pRadius >= MainRegistry.CoreConfig.OilFixConfig.OilDepositThresholdLarge) {
            tSpringHeight = MainRegistry.CoreConfig.OilFixConfig.OilFountainSizeLarge;
            eSize = EDEPOSIT_SIZE.LARGE;
        } else if (pRadius >= MainRegistry.CoreConfig.OilFixConfig.OilDepositThresholdMedium) {
            tSpringHeight = MainRegistry.CoreConfig.OilFixConfig.OilFountainSizeSmall;
            eSize = EDEPOSIT_SIZE.MEDIUM;
        } else {
            eSize = EDEPOSIT_SIZE.SMALL;
        }
        int pMaxHeight = pGroundLevel + tSpringHeight;
        if (pMaxHeight >= pWorld.func_72940_L() - 1) {
            if (YAMCore.isDebug()) {
                this._mLog.warn((Object)"The total height of the calculated OilDeposit would exceed the maximum world-size.");
            }
            return;
        }
        int r2 = pRadius * pRadius;
        for (int bx = -pRadius; bx <= pRadius; ++bx) {
            for (int by = -pRadius + 2; by <= pRadius - 2; ++by) {
                for (int bz = -pRadius; bz <= pRadius; ++bz) {
                    int d2 = bx * bx + by * by * 3 + bz * bz;
                    if (d2 > r2 || this.checkBlock(pWorld, bx + pSphereX - 1, by + pSphereY, bz + pSphereZ) && pCheckValidLocation || this.checkBlock(pWorld, bx + pSphereX + 1, by + pSphereY, bz + pSphereZ) && pCheckValidLocation || this.checkBlock(pWorld, bx + pSphereX, by + pSphereY - 1, bz + pSphereZ) && pCheckValidLocation || this.checkBlock(pWorld, bx + pSphereX, by + pSphereY, bz + pSphereZ - 1) && pCheckValidLocation || this.checkBlock(pWorld, bx + pSphereX, by + pSphereY, bz + pSphereZ + 1) && pCheckValidLocation || OilGeneratorFix.checkBlockAbove(pWorld, bx + pSphereX, by + pSphereY + 1, bz + pSphereZ) && pCheckValidLocation) continue;
                    pWorld.func_147465_d(bx + pSphereX, by + pSphereY, bz + pSphereZ, pTargetBlock, 0, 2);
                }
            }
        }
        if (eSize.ordinal() >= EDEPOSIT_SIZE.MEDIUM.ordinal()) {
            for (y = pSphereY + 1; y <= pMaxHeight; ++y) {
                pWorld.func_147465_d(pSphereX, y, pSphereZ, pTargetBlock, 0, 3);
            }
        }
        if (eSize == EDEPOSIT_SIZE.LARGE) {
            for (y = pSphereY; y <= pMaxHeight - tSpringHeight / 2; ++y) {
                pWorld.func_147465_d(pSphereX + 1, y, pSphereZ, pTargetBlock, 0, 3);
                pWorld.func_147465_d(pSphereX - 1, y, pSphereZ, pTargetBlock, 0, 3);
                pWorld.func_147465_d(pSphereX, y, pSphereZ + 1, pTargetBlock, 0, 3);
                pWorld.func_147465_d(pSphereX, y, pSphereZ - 1, pTargetBlock, 0, 3);
            }
        }
    }

    private int getTopBlock(World pWorld, int pLocX, int pLocZ) {
        Chunk tChunk = pWorld.func_72938_d(pLocX, pLocZ);
        int trimmedX = pLocX & 0xF;
        int trimmedZ = pLocZ & 0xF;
        for (int y = tChunk.func_76625_h() + 15; y > 0; --y) {
            Block tBlock = tChunk.func_150810_a(trimmedX, y, trimmedZ);
            if (tBlock.isAir((IBlockAccess)pWorld, pLocX, y, pLocZ)) continue;
            if (tBlock instanceof BlockStaticLiquid) {
                return y;
            }
            if (tBlock instanceof BlockFluidBase) {
                return y;
            }
            if (tBlock instanceof IFluidBlock) {
                return y;
            }
            if (!tBlock.func_149688_o().func_76230_c() || tBlock instanceof BlockFlower) continue;
            return y - 1;
        }
        return -1;
    }

    private boolean checkOilPresent(World pWorld, int pLocX, int pLocY, int pLocZ, int pRadius) {
        int r2 = pRadius * pRadius;
        for (int bx = -pRadius; bx <= pRadius; ++bx) {
            for (int by = -pRadius + 2; by <= pRadius - 2; ++by) {
                for (int bz = -pRadius; bz <= pRadius; ++bz) {
                    int d2 = bx * bx + by * by * 3 + bz * bz;
                    if (d2 > r2 || this.checkBlock(pWorld, bx + pLocX - 1, by + pLocY, bz + pLocZ) || this.checkBlock(pWorld, bx + pLocX + 1, by + pLocY, bz + pLocZ) || this.checkBlock(pWorld, bx + pLocX, by + pLocY - 1, bz + pLocZ) || this.checkBlock(pWorld, bx + pLocX, by + pLocY, bz + pLocZ - 1) || this.checkBlock(pWorld, bx + pLocX, by + pLocY, bz + pLocZ + 1) || OilGeneratorFix.checkBlockAbove(pWorld, bx + pLocX, by + pLocY + 1, bz + pLocZ) || pWorld.func_147439_a(bx + pLocX, by + pLocY, bz + pLocZ) != this._mBuildCraftOilBlock) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkBlock(World pWorld, int pLocX, int pLocY, int pLocZ) {
        Block tBlock = pWorld.func_147439_a(pLocX, pLocY, pLocZ);
        return tBlock.func_149688_o() == Material.field_151579_a || tBlock instanceof BlockLiquid && tBlock != this._mBuildCraftOilBlock;
    }

    private static boolean checkBlockAbove(World pWorld, int pLocX, int pLocY, int pLocZ) {
        Block tBlock = pWorld.func_147439_a(pLocX, pLocY, pLocZ);
        if (tBlock instanceof BlockSand) {
            return true;
        }
        return tBlock instanceof BlockGravel;
    }

    private boolean shouldSpawnOil(World pWorld, Random pRand, int pX, int pZ, Vec3 pPos) {
        boolean flag2;
        if (!MainRegistry.CoreConfig.OilFixConfig.OilDimensionWhitelist.contains(pWorld.field_73011_w.field_76574_g)) {
            if (YAMCore.isDebug()) {
                this._mLog.info((Object)String.format("Not generating OilDeposit; Dimension is not Whitelisted %d", pWorld.field_73011_w.field_76574_g));
            }
            return false;
        }
        BiomeGenBase biomegenbase = pWorld.func_72807_a(pX + 8, pZ + 8);
        if (MainRegistry.CoreConfig.OilFixConfig.OilBiomeIDBlackList.contains(biomegenbase.field_76756_M)) {
            if (YAMCore.isDebug()) {
                this._mLog.info((Object)String.format("Not generating OilDeposit; BiomeID %d is Blacklisted", biomegenbase.field_76756_M));
            }
            return false;
        }
        pRand.setSeed(pWorld.func_72905_C());
        long i1 = (long)pRand.nextInt() / 2L * 2L + 1L;
        long j1 = (long)pRand.nextInt() / 2L * 2L + 1L;
        pRand.setSeed((long)pX * i1 + (long)pZ * j1 ^ pWorld.func_72905_C());
        double randMod = Math.min(0.2, 1.0E-4 * MainRegistry.CoreConfig.OilFixConfig.OilSphereChance);
        if (biomegenbase.field_76748_D >= 0.45f) {
            randMod /= 2.0;
        }
        if (biomegenbase.field_76748_D < -0.5f) {
            randMod *= 1.8;
        }
        if (MainRegistry.CoreConfig.OilFixConfig.OilBoostBiomes.contains(biomegenbase.field_76756_M)) {
            randMod *= MainRegistry.CoreConfig.OilFixConfig.OilBiomeBoostFactor;
        }
        boolean flag1 = pRand.nextDouble() <= randMod;
        boolean bl = flag2 = pRand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            pPos.field_72448_b = 17 + pRand.nextInt(10) + pRand.nextInt(5);
            pPos.field_72450_a = pX + pRand.nextInt(16);
            pPos.field_72449_c = pZ + pRand.nextInt(16);
            return true;
        }
        return false;
    }

    public static class OilConfig {
        public boolean OilFixEnabled = false;
        public int OilDepostMinDistance = 2;
        public double OilSphereChance = 30.0;
        public int OilSphereMinRadius = 8;
        public int OilSphereMaxSize = 15;
        public int OilDepositThresholdLarge = 14;
        public int OilDepositThresholdMedium = 11;
        public int OilFountainSizeSmall = 5;
        public int OilFountainSizeLarge = 16;
        public double OilBiomeBoostFactor = 2.5;
        public List<Integer> OilDimensionWhitelist = new ArrayList<Integer>();
        public List<Integer> OilBiomeIDBlackList = new ArrayList<Integer>();
        public List<Integer> OilBoostBiomes = new ArrayList<Integer>();

        public OilConfig(Configuration pConfigObject) {
            pConfigObject.addCustomCategoryComment("ModFixes.OilGen", "The OilgenChance is based on height of the biome. On high-y biomes, the basic chance is divided by 2, on low-y biomes like oceans, it is multiplied by 1.8.\nThe multiplier set here for -OilBoostBiomes- Biomes is applied after those multipliers are set.");
            this.OilFixEnabled = pConfigObject.getBoolean("GenerateOil", "ModFixes", this.OilFixEnabled, "Set to true to enable OilSpawn from this Mod. Make sure to disable Oil-Spawn in BuildCraft if you do");
            this.OilDepostMinDistance = pConfigObject.getInt("OilDepostMinDistance", "ModFixes.OilGen", this.OilDepostMinDistance, 0, 1024, "The minimum distance of 2 Oil-Deposits in chunks. Modulo-Based; A 2 here means an deposit can only spawn in chunks that have a number that is a multiple of 2 (Chunknumber * 16 = X/Z coord)");
            this.OilSphereChance = pConfigObject.getFloat("OilSphereChance", "ModFixes.OilGen", (float)this.OilSphereChance, 0.0f, 2000.0f, "General OilGen factor");
            this.OilSphereMinRadius = pConfigObject.getInt("OilSphereMinRadius", "ModFixes.OilGen", this.OilSphereMinRadius, 0, 20, "The minimum radius of an underground OilSphere");
            this.OilSphereMaxSize = pConfigObject.getInt("OilSphereMaxSize", "ModFixes.OilGen", this.OilSphereMaxSize, 3, 50, "The maximum radius of an underground OilSphere. The final size is calculated by OilSphereMinRadius + Random(OilSphereMaxSize-OilSphereMinRadius)");
            this.OilDepositThresholdMedium = pConfigObject.getInt("OilDepositThresholdMedium", "ModFixes.OilGen", this.OilDepositThresholdMedium, 0, 100, "Threshold at which an oil-deposit will be considered as 'medium' and the fountain will be higher and thicker.");
            this.OilDepositThresholdLarge = pConfigObject.getInt("OilDepositThresholdLarge", "ModFixes.OilGen", this.OilDepositThresholdLarge, 0, 100, "Threshold at which an oil-deposit will be considered as 'large' and the fountain will be higher and thicker.");
            this.OilFountainSizeSmall = pConfigObject.getInt("OilFountainSizeSmall", "ModFixes.OilGen", this.OilFountainSizeSmall, 0, 100, "Visible height of the fountain above the oil-deposit for MEDIUM deposits");
            this.OilFountainSizeLarge = pConfigObject.getInt("OilFountainSizeLarge", "ModFixes.OilGen", this.OilFountainSizeLarge, 0, 100, "Visible height of the fountain above the oil-deposit for LARGE deposits");
            this.OilBiomeBoostFactor = pConfigObject.getFloat("OilBiomeBoostFactor", "ModFixes.OilGen", (float)this.OilBiomeBoostFactor, 0.0f, 50.0f, "Boost factor of oil spheres in certain Biomes that are listed in -OilBoostBiomes-");
            this.OilDimensionWhitelist = this.parseStringListToIntList(pConfigObject.getStringList("OilDimensionWhitelist", "ModFixes.OilGen", new String[]{"0"}, "List DimensionIDs (Numbers only; One per line!) here where the OilGenerator should do its work"));
            this.OilBiomeIDBlackList = this.parseStringListToIntList(pConfigObject.getStringList("OilBiomeIDBlackList", "ModFixes.OilGen", new String[0], "List BiomeIDs (Numbers only; One per line!) where no oil should be generated"));
            this.OilBoostBiomes = this.parseStringListToIntList(pConfigObject.getStringList("OilBoostBiomes", "ModFixes.OilGen", new String[0], "List BiomeIDs (Numbers only; One per line!) where the boost multiplicator is applied. Leave empty to disable Biome-Boost"));
        }

        private List<Integer> parseStringListToIntList(String[] pSource) {
            ArrayList<Integer> tLst = new ArrayList<Integer>();
            for (String tEntry : pSource) {
                if (!IntHelper.tryParse((String)tEntry)) continue;
                tLst.add(Integer.parseInt(tEntry));
            }
            return tLst;
        }
    }

    private static enum EDEPOSIT_SIZE {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

