/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.PlasmaArcFurnace")
@ModOnly(value={"gregtech"})
public class PlasmaArcFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, ILiquidStack fluidOutput, IIngredient input, ILiquidStack fluidInput, int[] outChances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Plasma Arc Furnace must have at least 1 output");
        } else if (outputs.length != outChances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Plasma Arc Furnace recipe for " + input, new Object[]{input, fluidInput, outputs, fluidOutput, outChances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input = i.nextItem();
                    FluidStack fluidInput = i.nextFluid();
                    ItemStack[] outputs = i.nextItemArr();
                    FluidStack fluidOutput = i.nextFluid();
                    int[] chances = i.nextIntArr();
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).itemOutputs(outputs).outputChances(chances).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[]{fluidOutput}).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.plasmaArcFurnaceRecipes);
                }
            });
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, ILiquidStack fluidOutput, IIngredient input, int[] outChances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Plasma Arc Furnace must have at least 1 output");
        } else if (outputs.length != outChances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Plasma Arc Furnace recipe for " + input, new Object[]{input, outputs, fluidOutput, outChances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input = i.nextItem();
                    ItemStack[] outputs = i.nextItemArr();
                    FluidStack fluidOutput = i.nextFluid();
                    int[] chances = i.nextIntArr();
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).itemOutputs(outputs).outputChances(chances).fluidOutputs(new FluidStack[]{fluidOutput}).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.plasmaArcFurnaceRecipes);
                }
            });
        }
    }
}

