/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(modid="CoFHAPI|energy", iface="cofh.api.energy.IEnergyContainerItem"), @Optional.Interface(modid="IC2API", iface="ic2.api.item.ISpecialElectricItem"), @Optional.Interface(modid="MekanismAPI|energy", iface="mekanism.api.energy.IEnergizedItem")})
public abstract class ItemElectricBase
extends Item
implements IItemElectricBase,
IEnergyContainerItem,
ISpecialElectricItem,
IEnergizedItem {
    private static Object itemManagerIC2;
    public float transferMax;

    public ItemElectricBase() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = new ElectricItemManagerIC2_1710();
        }
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    @Override
    public float getMaxTransferGC(ItemStack itemStack) {
        return this.transferMax;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        float joules = this.getElectricityStored(itemStack);
        String color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS(joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS(this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    @Override
    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    @Override
    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    @Override
    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @Override
    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    @Override
    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    @Override
    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(ElectricItemHelper.getUncharged(new ItemStack((Item)this)));
        par3List.add(ElectricItemHelper.getWithCharge(new ItemStack((Item)this), this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    public static boolean isElectricItem(Item item) {
        if (item instanceof IItemElectricBase) {
            return true;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            return item instanceof ISpecialElectricItem;
        }
        return false;
    }

    public static boolean isElectricItemEmpty(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof IItemElectricBase) {
            return ((IItemElectricBase)item).getElectricityStored(itemstack) <= 0.0f;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof ISpecialElectricItem) {
            return !((ISpecialElectricItem)item).canProvideEnergy(itemstack);
        }
        return false;
    }

    public static boolean isElectricItemCharged(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof IItemElectricBase) {
            return ((IItemElectricBase)item).getElectricityStored(itemstack) > 0.0f;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof ISpecialElectricItem) {
            return ((ISpecialElectricItem)item).canProvideEnergy(itemstack);
        }
        return false;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)(this.recharge(container, (float)maxReceive * EnergyConfigHandler.RF_RATIO, !simulate) / EnergyConfigHandler.RF_RATIO);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)(this.discharge(container, (float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO);
    }

    public int getEnergyStored(ItemStack container) {
        return (int)(this.getElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return (int)(this.getMaxElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="IC2API")
    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }
}

