/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

public final class RelativeCoordinatePacker {
    private static final int X_BITS = 9;
    private static final int Z_BITS = 9;
    private static final int Y_BITS = 8;
    private static final int SIDE_BITS = 6;
    private static final int Z_SHIFT = 9;
    private static final int Y_SHIFT = 18;
    private static final int SIDE_SHIFT = 26;
    private static final int XZ_MASK = 511;
    private static final int Y_MASK = 255;
    private static final int SIDE_MASK = 63;
    public static final int COORD_ONLY_MASK = 0x3FFFFFF;
    private static final int X_SIGN_LEFT = 23;
    private static final int Z_SIGN_LEFT = 14;
    private static final int Y_SIGN_LEFT = 6;
    private static final int XZ_SIGN_RIGHT = 23;
    private static final int Y_SIGN_RIGHT = 24;

    private RelativeCoordinatePacker() {
    }

    public static int pack(int relX, int relY, int relZ) {
        return relX & 0x1FF | (relZ & 0x1FF) << 9 | (relY & 0xFF) << 18;
    }

    public static int unpackX(int packed) {
        return packed << 23 >> 23;
    }

    public static int unpackZ(int packed) {
        return packed << 14 >> 23;
    }

    public static int unpackY(int packed) {
        return packed << 6 >> 24;
    }

    public static int getSideBits(int packed) {
        return packed >>> 26 & 0x3F;
    }

    public static int withSideBit(int packed, int side) {
        return packed | 1 << 26 + side;
    }

    public static int coordOnly(int packed) {
        return packed & 0x3FFFFFF;
    }
}

