/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.BarnardsSystem.planets.barnardaC.dimension;

import galaxyspace.BarnardsSystem.planets.barnardaC.world.BiomeGenBaseBarnardaC;
import galaxyspace.BarnardsSystem.planets.barnardaC.world.layer.GenLayerBarnardaC;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldChunkManagerSpace;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class WorldChunkManagerBarnardaC
extends WorldChunkManagerSpace {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache biomeCache;
    private final List<BiomeGenBase> biomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected WorldChunkManagerBarnardaC() {
        this.biomeCache = new BiomeCache((WorldChunkManager)this);
        this.biomesToSpawnIn.add(BiomeGenBaseBarnardaC.BARNARDA_C_HILLS);
        this.biomesToSpawnIn.add(BiomeGenBaseBarnardaC.BARNARDA_C_LOW_PLAINS);
        this.biomesToSpawnIn.add(BiomeGenBaseBarnardaC.BARNARDA_C_FLOWERS);
        this.biomesToSpawnIn.add(BiomeGenBaseBarnardaC.BARNARDA_C_OCEANS);
    }

    public WorldChunkManagerBarnardaC(long seed) {
        this();
        GenLayer[] genLayers = GenLayerBarnardaC.makeTheWorld(seed);
        this.unzoomedBiomes = genLayers[0];
        this.zoomedBiomes = genLayers[1];
    }

    public WorldChunkManagerBarnardaC(World world) {
        this(world.func_72905_C());
    }

    public List<BiomeGenBase> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase getBiome() {
        return BiomeGenBaseBarnardaC.BARNARDA_C_SHORES;
    }

    public BiomeGenBase func_76935_a(int x, int z) {
        BiomeGenBase biome = this.biomeCache.func_76837_b(x, z);
        if (biome == null) {
            return this.getBiome();
        }
        return biome;
    }

    public float[] func_76936_a(float[] downfalls, int x, int z, int w, int h) {
        IntCache.func_76446_a();
        int[] zoomedBiomes_ = this.zoomedBiomes.func_75904_a(x, z, w, h);
        if (downfalls == null || downfalls.length < w * h) {
            downfalls = new float[w * h];
        }
        for (int i = 0; i < w * h; ++i) {
            try {
                float f = (float)BiomeGenBase.func_150568_d((int)zoomedBiomes_[i]).func_76744_g() / 65536.0f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                downfalls[i] = f;
                continue;
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                crashreportcategory.func_71507_a("biome id", (Object)i);
                crashreportcategory.func_71507_a("downfalls[] size", (Object)downfalls.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)w);
                crashreportcategory.func_71507_a("h", (Object)h);
                throw new ReportedException(crashreport);
            }
        }
        return downfalls;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomes, int x, int z, int w, int h) {
        IntCache.func_76446_a();
        int[] unzoomedBiomes_ = this.unzoomedBiomes.func_75904_a(x, z, w, h);
        if (biomes == null || biomes.length < w * h) {
            biomes = new BiomeGenBase[w * h];
        }
        try {
            for (int i = 0; i < w * h; ++i) {
                biomes[i] = unzoomedBiomes_[i] >= 0 ? BiomeGenBase.func_150568_d((int)unzoomedBiomes_[i]) : this.getBiome();
            }
            return biomes;
        }
        catch (Exception e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)w);
            crashreportcategory.func_71507_a("h", (Object)h);
            throw new ReportedException(crashreport);
        }
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomes, int x, int z, int w, int h, boolean cacheFlag) {
        IntCache.func_76446_a();
        int[] zoomedBiomes_ = this.zoomedBiomes.func_75904_a(x, z, w, h);
        if (biomes == null || biomes.length < w * h) {
            biomes = new BiomeGenBase[w * h];
        }
        if (cacheFlag && w == 16 && h == 16 && (x & 0x10) == 0 && (z & 0x10) == 0) {
            System.arraycopy(this.biomeCache.func_76839_e(x, z), 0, biomes, 0, w * h);
            return biomes;
        }
        for (int i = 0; i < w * h; ++i) {
            biomes[i] = zoomedBiomes_[i] >= 0 ? BiomeGenBase.func_150568_d((int)zoomedBiomes_[i]) : this.getBiome();
        }
        return biomes;
    }

    public boolean func_76940_a(int x, int z, int radius, List<BiomeGenBase> allowed) {
        IntCache.func_76446_a();
        int areaX = x - radius >> 2;
        int areaY = z - radius >> 2;
        int areaW = 2 * (radius >> 2) + 1;
        int areaH = 2 * (radius >> 2) + 1;
        int[] unzoomedBiomes_ = this.unzoomedBiomes.func_75904_a(areaX, areaY, areaW, areaH);
        try {
            for (int i = 0; i < areaW * areaH; ++i) {
                BiomeGenBase biome = BiomeGenBase.func_150568_d((int)unzoomedBiomes_[i]);
                if (allowed.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.unzoomedBiomes);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    public ChunkPosition func_150795_a(int x, int z, int radius, List<BiomeGenBase> biomes, Random random) {
        IntCache.func_76446_a();
        int areaX = x - radius >> 2;
        int areaZ = z - radius >> 2;
        int areaW = 2 * (radius >> 2) + 1;
        int areaH = 2 * (radius >> 2) + 1;
        int[] unzoomedBiomes_ = this.unzoomedBiomes.func_75904_a(areaX, areaZ, areaW, areaH);
        ChunkPosition chunkposition = null;
        int bound = 0;
        for (int i = 0; i < unzoomedBiomes_.length; ++i) {
            int cX = areaX + i % areaW << 2;
            int cZ = areaZ + i / areaW << 2;
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)unzoomedBiomes_[i]);
            if (!biomes.contains(biome) || chunkposition != null && random.nextInt(bound + 1) != 0) continue;
            chunkposition = new ChunkPosition(cX, 0, cZ);
            ++bound;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

