/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.kuiperbelt.dimension;

import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.SolarSystem.planets.kuiperbelt.world.BiomeGenBaseKuiper;
import galaxyspace.core.entity.mob.EntityEvolvedColdBlaze;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class ChunkProviderKuiper
extends ChunkProviderGenerate {
    private static final Set<BlockVec3> CHUNKS_DONE = new HashSet<BlockVec3>();
    private final Block ASTEROID_STONE = AsteroidBlocks.blockBasic;
    private final Block ASTEROID_ICE = AsteroidBlocks.blockDenseIce;
    private final Block DIRT = Blocks.field_150346_d;
    private final Block GRASS = Blocks.field_150349_c;
    private final Block LIGHT = Blocks.field_150426_aN;
    private final Block TALL_GRASS = Blocks.field_150329_H;
    private final Block FLOWER = Blocks.field_150328_O;
    private final Block LAVA = Blocks.field_150353_l;
    private final Block WATER = Blocks.field_150355_j;
    private final NoiseModule asteroidDensity;
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    private final SpecialAsteroidBlockHandler coreHandler;
    private final SpecialAsteroidBlockHandler shellHandler;
    private final List<AsteroidData> largeAsteroids = new ArrayList<AsteroidData>();
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;

    public ChunkProviderKuiper(World world, long seed, boolean mapFeaturesEnabled) {
        super(world, seed, mapFeaturesEnabled);
        this.asteroidDensity = new Billowed(this.field_73220_k.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient(this.field_73220_k.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient(this.field_73220_k.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.field_73220_k.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.field_73220_k.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 2, 5, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 1, 7, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 11, 0.25));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 3, 5, 0.2));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 4, 4, 0.15));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 5, 3, 0.2));
        this.shellHandler = new SpecialAsteroidBlockHandler();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 1, 3, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 2, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15));
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray, boolean flagDataOnly) {
        this.largeAsteroids.clear();
        Random random = new Random();
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int minX = i * 16;
            int maxX = minX + 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int minZ = k * 16;
                int maxZ = minZ + 16;
                for (int x = minX; x < maxX; x += 2) {
                    for (int z = minZ; z < maxZ; z += 2) {
                        if (!((double)this.randFromPointPos(x, z) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 2400.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(160) + 48;
                        int size = random.nextInt(10) + 5;
                        this.generateAsteroid(random, x, y, z, chunkX << 4, chunkZ << 4, size, idArray, metaArray, flagDataOnly);
                    }
                }
            }
        }
    }

    private void generateAsteroid(Random rand_, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, Block[] blockArray, byte[] metaArray, boolean flagDataOnly) {
        int indexBaseX;
        int distanceX;
        int indexXZ;
        int indexXY;
        int x3;
        SpecialAsteroidBlock core = this.coreHandler.getBlock(rand_, size);
        SpecialAsteroidBlock shell = null;
        if (rand_.nextInt(2) == 0) {
            shell = this.shellHandler.getBlock(rand_, size);
        }
        boolean isHollow = false;
        float hollowSize = rand_.nextFloat() * 0.19999999f + 0.6f;
        if (rand_.nextInt(10) == 0 && size >= 15) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15);
        }
        ((WorldProviderKuiper)this.field_73230_p.field_73011_w).addAsteroid(asteroidX, asteroidY, asteroidZ, size, isHollow ? -1 : core.index);
        int xMin = this.clamp(Math.max(chunkX, asteroidX - size - 8 - 2) - chunkX, 0, 16);
        int zMin = this.clamp(Math.max(chunkZ, asteroidZ - size - 8 - 2) - chunkZ, 0, 16);
        int yMin = asteroidY - size - 8 - 2;
        int yMax = asteroidY + size + 8 + 2;
        int xMax = this.clamp(Math.min(chunkX + 16, asteroidX + size + 8 + 2) - chunkX, 0, 16);
        int zMax = this.clamp(Math.min(chunkZ + 16, asteroidZ + size + 8 + 2) - chunkZ, 0, 16);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * 256.0f + (float)chunkX;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * 256.0f;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * 256.0f + (float)chunkZ;
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int x = 0; x < xSize; ++x) {
            int xx = x * zSize;
            float xxx = (float)x + noiseOffsetX;
            for (int z = 0; z < zSize; ++z) {
                sizeYArray[xx + z] = this.asteroidSkewY.getNoise(xxx, (float)z + noiseOffsetZ);
            }
        }
        AsteroidData asteroidData = new AsteroidData(isHollow, sizeYArray, xMin, zMin, xMax, zMax, zSize, size, asteroidX, asteroidY, asteroidZ);
        this.largeAsteroids.add(asteroidData);
        this.largeAsteroidsLastChunkX = chunkX;
        this.largeAsteroidsLastChunkZ = chunkZ;
        if (flagDataOnly) {
            return;
        }
        for (int y = 0; y < ySize; ++y) {
            int yy = y * zSize;
            float yyy = (float)y + noiseOffsetY;
            for (int z2 = 0; z2 < zSize; ++z2) {
                sizeXArray[yy + z2] = this.asteroidSkewX.getNoise(yyy, (float)z2 + noiseOffsetZ);
            }
        }
        for (int x2 = 0; x2 < xSize; ++x2) {
            int xx2 = x2 * ySize;
            float xxx2 = (float)x2 + noiseOffsetX;
            for (int y2 = 0; y2 < ySize; ++y2) {
                sizeZArray[xx2 + y2] = this.asteroidSkewZ.getNoise(xxx2, (float)y2 + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        int terrainY = 0;
        int terrainYY = 0;
        if (shell != null) {
            shellThickness = 1.0 - shell.thickness;
        }
        for (x3 = xMax - 1; x3 >= xMin; --x3) {
            indexXY = (x3 - xMin) * ySize - yMin;
            indexXZ = (x3 - xMin) * zSize - zMin;
            distanceX = asteroidX - (x3 + chunkX);
            indexBaseX = x3 * 256 << 4;
            float xx3 = x3 + chunkX;
            for (int z3 = zMin; z3 < zMax; ++z3) {
                if (isHollow) {
                    float sizeModY = sizeYArray[indexXZ + z3];
                    terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                    terrainYY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size);
                }
                float sizeY = (float)size + sizeYArray[indexXZ + z3];
                sizeY *= sizeY;
                int distanceZ = asteroidZ - (z3 + chunkZ);
                int indexBase = indexBaseX | z3 * 256;
                float zz = z3 + chunkZ;
                for (int y3 = yMin; y3 < yMax; ++y3) {
                    int index;
                    float distanceAbove;
                    float dSizeX = (float)distanceX / ((float)size + sizeXArray[(y3 - yMin) * zSize + z3 - zMin]);
                    float dSizeZ = (float)distanceZ / ((float)size + sizeZArray[indexXY + y3]);
                    dSizeX *= dSizeX;
                    dSizeZ *= dSizeZ;
                    int distanceY = asteroidY - y3;
                    distanceY *= distanceY;
                    float distance = distanceAbove = dSizeX + (float)distanceY / sizeY + dSizeZ;
                    distance += this.asteroidTurbulance.getNoise(xx3, (float)y3, zz);
                    if (isHollow && distance <= hollowSize && (distanceAbove += this.asteroidTurbulance.getNoise(xx3, (float)(y3 + 1), zz)) <= 1.0f && y3 - 1 == terrainYY) {
                        index = indexBase | y3 + 1;
                        blockArray[index] = this.LIGHT;
                        int n = index;
                        ((Object)((Object)this)).getClass();
                        metaArray[n] = 0;
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y3;
                    if (isHollow && distance <= hollowSize) {
                        if (y3 == terrainY) {
                            blockArray[index] = this.GRASS;
                            int n2 = index;
                            ((Object)((Object)this)).getClass();
                            metaArray[n2] = 0;
                            continue;
                        }
                        if (y3 < terrainY) {
                            blockArray[index] = this.DIRT;
                            int n3 = index;
                            ((Object)((Object)this)).getClass();
                            metaArray[n3] = 0;
                            continue;
                        }
                        blockArray[index] = Blocks.field_150350_a;
                        metaArray[index] = 0;
                        continue;
                    }
                    if ((double)distance <= core.thickness) {
                        if (rand_.nextBoolean()) {
                            blockArray[index] = core.block;
                            metaArray[index] = core.meta;
                            continue;
                        }
                        blockArray[index] = this.ASTEROID_STONE;
                        int n4 = index;
                        ((Object)((Object)this)).getClass();
                        metaArray[n4] = 0;
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        blockArray[index] = shell.block;
                        metaArray[index] = shell.meta;
                        continue;
                    }
                    blockArray[index] = this.ASTEROID_ICE;
                    int n5 = index;
                    ((Object)((Object)this)).getClass();
                    metaArray[n5] = 1;
                }
            }
        }
        if (isHollow) {
            shellThickness = 0.0;
            if (shell != null) {
                shellThickness = 1.0 - shell.thickness;
            }
            for (x3 = xMin; x3 < xMax; ++x3) {
                indexXY = (x3 - xMin) * ySize - yMin;
                indexXZ = (x3 - xMin) * zSize - zMin;
                distanceX = asteroidX - (x3 + chunkX);
                distanceX *= distanceX;
                indexBaseX = x3 * 256 << 4;
                for (int z4 = zMin; z4 < zMax; ++z4) {
                    float sizeY = (float)size + sizeYArray[indexXZ + z4];
                    sizeY *= sizeY;
                    int distanceZ = asteroidZ - (z4 + chunkZ);
                    distanceZ *= distanceZ;
                    int indexBase = indexBaseX | z4 * 256;
                    for (int y4 = yMin; y4 < yMax; ++y4) {
                        float sizeX = (float)size + sizeXArray[(y4 - yMin) * zSize + z4 - zMin];
                        float sizeZ = (float)size + sizeZArray[indexXY + y4];
                        sizeX *= sizeX;
                        sizeZ *= sizeZ;
                        int distanceY2 = asteroidY - y4;
                        distanceY2 *= distanceY2;
                        float distance2 = (float)distanceX / sizeX + (float)distanceY2 / sizeY + (float)distanceZ / sizeZ;
                        if (!((distance2 += this.asteroidTurbulance.getNoise((float)(x3 + chunkX), (float)y4, (float)(z4 + chunkZ))) <= 1.0f)) continue;
                        int index2 = indexBase | y4;
                        int indexAbove = indexBase | y4 + 1;
                        if (Blocks.field_150350_a != blockArray[indexAbove] || blockArray[index2] != this.ASTEROID_STONE && blockArray[index2] != this.GRASS || this.field_73220_k.nextInt(20) != 0) continue;
                        blockArray[index2] = this.LIGHT;
                        int n6 = index2;
                        ((Object)((Object)this)).getClass();
                        metaArray[n6] = 0;
                    }
                }
            }
        }
    }

    private void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((float)(asteroidY - asteroidSize / 4) + yMod * 1.5f);
    }

    private int getTerrainHeightAt(int x, float[] yModArray, int xMin, int zMin, int zSize, int asteroidY, int asteroidSize) {
        int index = (x - xMin) * zSize - zMin;
        if (index < yModArray.length && index >= 0) {
            float yMod = yModArray[index];
            return this.getTerrainHeightFor(yMod, asteroidY, asteroidSize);
        }
        return 1;
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.field_73220_k.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Block[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(chunkX, chunkZ, ids, meta, false);
        Chunk chunk = new Chunk(this.field_73230_p, ids, meta, chunkX, chunkZ);
        byte[] biomes = chunk.func_76605_m();
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = (byte)BiomeGenBaseKuiper.INSTANCE.field_76756_M;
        }
        this.generateSkylightMap(chunk, chunkX, chunkZ);
        return chunk;
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPoint(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPointPos(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public boolean func_73149_a(int chunkX, int chunkZ) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        long seedZ;
        long seedX;
        int z;
        int x;
        block24: {
            x = chunkX << 4;
            z = chunkZ << 4;
            if (!CHUNKS_DONE.add(new BlockVec3(x, 0, z))) {
                return;
            }
            BlockFalling.field_149832_M = true;
            this.field_73230_p.func_72807_a(x + 16, z + 16);
            BlockFalling.field_149832_M = false;
            this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
            seedX = this.field_73220_k.nextLong() / 2L * 2L + 1L;
            seedZ = this.field_73220_k.nextLong() / 2L * 2L + 1L;
            this.field_73220_k.setSeed((long)chunkX * seedX + (long)chunkZ * seedZ ^ this.field_73230_p.func_72905_C());
            if (!this.field_73220_k.nextBoolean()) break block24;
            double density = (double)this.asteroidDensity.getNoise((float)(chunkX * 16), (float)(chunkZ * 16)) * 0.54;
            double numOfBlocks = this.clamp(this.randFromPoint(chunkX, chunkZ), 0.4, 1.0) * 200.0 * density + 50.0;
            int y0 = this.field_73220_k.nextInt(2);
            int yRange = 160;
            int i = 0;
            while ((double)i < numOfBlocks) {
                block25: {
                    int meta;
                    Block block;
                    int rZ;
                    int rX;
                    int rY;
                    block27: {
                        block28: {
                            block26: {
                                rY = this.field_73220_k.nextInt(yRange) + 48;
                                if (y0 != rY / 16 % 2) break block25;
                                rX = x + this.field_73220_k.nextInt(16);
                                rZ = z + this.field_73220_k.nextInt(16);
                                block = this.ASTEROID_ICE;
                                ((Object)((Object)this)).getClass();
                                meta = 1;
                                if (this.field_73220_k.nextInt(400) != 0) break block26;
                                meta = 4;
                                if (!ConfigManagerAsteroids.disableIlmeniteGen) break block27;
                                break block25;
                            }
                            if (this.field_73220_k.nextInt(300) != 0) break block28;
                            meta = 5;
                            if (!ConfigManagerAsteroids.disableIronGen) break block27;
                            break block25;
                        }
                        if (this.field_73220_k.nextInt(250) != 0) break block27;
                        meta = 3;
                        if (ConfigManagerAsteroids.disableAluminumGen) break block25;
                    }
                    this.field_73230_p.func_147465_d(rX, rY, rZ, block, meta, 2);
                    int count = 7;
                    if (!(this.field_73230_p.func_147439_a(rX - 1, rY, rZ) instanceof BlockAir)) {
                        count = 1;
                    } else if (!(this.field_73230_p.func_147439_a(rX - 2, rY, rZ) instanceof BlockAir)) {
                        count = 3;
                    } else if (!(this.field_73230_p.func_147439_a(rX - 3, rY, rZ) instanceof BlockAir)) {
                        count = 5;
                    } else if (!(this.field_73230_p.func_147439_a(rX - 4, rY, rZ) instanceof BlockAir)) {
                        count = 6;
                    }
                    this.field_73230_p.func_72915_b(EnumSkyBlock.Block, rX, rY, rZ, count);
                }
                ++i;
            }
        }
        if (this.largeAsteroidsLastChunkX != chunkX || this.largeAsteroidsLastChunkZ != chunkZ) {
            this.generateTerrain(chunkX, chunkZ, null, null, true);
        }
        this.field_73220_k.setSeed((long)chunkX * seedX + (long)chunkZ * seedZ ^ this.field_73230_p.func_72905_C());
        if (!this.largeAsteroids.isEmpty()) {
            for (AsteroidData asteroidIndex : this.largeAsteroids) {
                int rX;
                if (!asteroidIndex.isHollow) continue;
                float[] sizeYArray = asteroidIndex.sizeYArray;
                int xMin = asteroidIndex.xMinArray;
                int zMin = asteroidIndex.zMinArray;
                int zSize = asteroidIndex.zSizeArray;
                int asteroidY = asteroidIndex.asteroidYArray;
                int asteroidSize = asteroidIndex.asteroidSizeArray;
                boolean treesdone = false;
                if (ConfigManagerCore.challengeMode || this.field_73220_k.nextInt(2) == 0) {
                    int treeType = this.field_73220_k.nextInt(3);
                    if (treeType == 1) {
                        treeType = 0;
                    }
                    WorldGenTrees wg = new WorldGenTrees(false, 2, 0, 0, false);
                    for (int tries = 0; tries < 5; ++tries) {
                        int rX2 = this.field_73220_k.nextInt(16) + x + 8;
                        int rZ = this.field_73220_k.nextInt(16) + z + 8;
                        if (wg.func_76484_a(this.field_73230_p, this.field_73220_k, rX2, this.getTerrainHeightAt(rX2 - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), rZ)) break;
                    }
                    treesdone = true;
                }
                if (!treesdone || this.field_73220_k.nextInt(2) == 0) {
                    rX = this.field_73220_k.nextInt(16) + x + 8;
                    int rZ = this.field_73220_k.nextInt(16) + z + 8;
                    Block tall_GRASS = this.TALL_GRASS;
                    ((Object)((Object)this)).getClass();
                    new WorldGenTallGrass(tall_GRASS, 1).func_76484_a(this.field_73230_p, this.field_73220_k, rX, this.getTerrainHeightAt(rX - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), rZ);
                }
                if (this.field_73220_k.nextInt(2) == 0) {
                    rX = this.field_73220_k.nextInt(16) + x + 8;
                    int rZ = this.field_73220_k.nextInt(16) + z + 8;
                    new WorldGenFlowers(this.FLOWER).func_76484_a(this.field_73230_p, this.field_73220_k, rX, this.getTerrainHeightAt(rX - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), rZ);
                }
                if (this.field_73220_k.nextInt(2) == 0) {
                    rX = this.field_73220_k.nextInt(16) + x + 8;
                    int rZ = this.field_73220_k.nextInt(16) + z + 8;
                    new WorldGenLakes(this.LAVA).func_76484_a(this.field_73230_p, this.field_73220_k, rX, this.getTerrainHeightAt(rX - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), rZ);
                }
                if (this.field_73220_k.nextInt(2) != 0) continue;
                rX = this.field_73220_k.nextInt(16) + x + 8;
                int rZ = this.field_73220_k.nextInt(16) + z + 8;
                new WorldGenLakes(this.WATER).func_76484_a(this.field_73230_p, this.field_73220_k, rX, this.getTerrainHeightAt(rX - x, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), rZ);
            }
        }
        for (int dX = 0; dX < 16; ++dX) {
            int pX = x + dX;
            for (int dZ = 0; dZ < 16; ++dZ) {
                int pZ = z + dZ;
                for (int pY = 16; pY < 240; ++pY) {
                    this.field_73230_p.func_147463_c(EnumSkyBlock.Block, pX, pY, pZ);
                }
            }
        }
    }

    public void generateSkylightMap(Chunk chunk, int cx, int cz) {
        int i;
        for (i = 0; i < 16; ++i) {
            if (chunk.func_76587_i()[i] != null) continue;
            chunk.func_76587_i()[i] = new ExtendedBlockStorage(i << 4, false);
        }
        i = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int k = 0; k < 16; ++k) {
            block2: for (int l = 0; l < 16; ++l) {
                chunk.field_76638_b[k + (l << 4)] = -999;
                for (int y = i + 15; y > 0; --y) {
                    if (chunk.func_150808_b(k, y - 1, l) == 0) continue;
                    chunk.field_76634_f[l << 4 | k] = y;
                    if (chunk.field_76634_f[l << 4 | k] >= chunk.field_82912_p) continue block2;
                    chunk.field_82912_p = y;
                    continue block2;
                }
            }
        }
        for (AsteroidData a : this.largeAsteroids) {
            int yMin = a.asteroidYArray - a.asteroidSizeArray;
            int yMax = a.asteroidYArray + a.asteroidSizeArray;
            int xMin = a.xMinArray;
            if (yMin < 0) {
                yMin = 0;
            }
            if (yMax > 255) {
                yMax = 255;
            }
            if (xMin == 0) {
                xMin = 1;
            }
            for (int x = a.xMax - 1; x >= xMin; --x) {
                for (int z = a.zMinArray; z < a.zMax; ++z) {
                    for (int y2 = yMin; y2 < yMax; ++y2) {
                        if (!(chunk.func_150810_a(x - 1, y2, z) instanceof BlockAir) || chunk.func_150810_a(x, y2, z) instanceof BlockAir) continue;
                        int count = 2;
                        if (x > 1 && chunk.func_150810_a(x - 2, y2, z) instanceof BlockAir) {
                            count += 2;
                        }
                        if (x > 2) {
                            if (chunk.func_150810_a(x - 3, y2, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 3, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 3, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && chunk.func_150810_a(x - 3, y2, z - 1) instanceof BlockAir) {
                                ++count;
                            }
                            if (z < 15 && chunk.func_150810_a(x - 3, y2, z + 1) instanceof BlockAir) {
                                ++count;
                            }
                        }
                        if (x > 3) {
                            if (chunk.func_150810_a(x - 4, y2, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 4, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 4, y2 + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && !(chunk.func_150810_a(x - 4, y2, z - 1) instanceof BlockAir)) {
                                ++count;
                            }
                            if (z < 15 && !(chunk.func_150810_a(x - 4, y2, z + 1) instanceof BlockAir)) {
                                ++count;
                            }
                        }
                        if (count > 12) {
                            count = 12;
                        }
                        chunk.func_150807_a(x - 1, y2 & 0xF, z, GCBlocks.brightAir, 15 - count);
                        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y2 >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76677_d(x - 1, y2 & 0xF, z, count);
                    }
                }
            }
        }
        chunk.field_76643_l = true;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "KuiperBeltLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        if (creatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 3000, 1, 3));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 2000, 1, 2));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 1500, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 2000, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedColdBlaze.class, 2000, 1, 1));
            return monsters;
        }
        return null;
    }

    public BlockVec3 isLargeAsteroidAt(int x0, int z0) {
        for (int i0 = 0; i0 <= 32; ++i0) {
            for (int i2 = -i0; i2 <= i0; ++i2) {
                int xToCheck = (x0 >> 4) + i0;
                int zToCheck = (z0 >> 4) + i2;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) + i0;
                zToCheck = (z0 >> 4) - i2;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) + i2;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) - i2;
                if (!this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) continue;
                return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int x0, int z0) {
        for (int x = x0; x < x0 + 16; x += 2) {
            for (int z = z0; z < z0 + 16; z += 2) {
                if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 2400.0)) continue;
                return true;
            }
        }
        return false;
    }

    private static class AsteroidData {
        public boolean isHollow;
        public float[] sizeYArray;
        public int xMinArray;
        public int zMinArray;
        public int xMax;
        public int zMax;
        public int zSizeArray;
        public int asteroidSizeArray;
        public int asteroidYArray;

        public AsteroidData(boolean hollow, float[] sizeYArray2, int xMin, int zMin, int xmax, int zmax, int zSize, int size, int asteroidX, int asteroidY, int asteroidZ) {
            this.isHollow = hollow;
            this.sizeYArray = (float[])sizeYArray2.clone();
            this.xMinArray = xMin;
            this.zMinArray = zMin;
            this.xMax = xmax;
            this.zMax = zmax;
            this.zSizeArray = zSize;
            this.asteroidSizeArray = size;
            this.asteroidYArray = asteroidY;
        }
    }
}

