/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.core.register.GSItems;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class GSSpaceSuitHandler {
    public static List<Item> validSpaceSuitHelmets = new ArrayList<Item>();
    public static List<Item> validSpaceSuitChestPlates = new ArrayList<Item>();
    public static List<Item> validSpaceSuitLeggings = new ArrayList<Item>();
    public static List<Item> validSpaceSuitBoots = new ArrayList<Item>();
    private static final String FORCE_SPACE_SUIT_NBT_KEY = "ForceValidSpaceSuit";

    public static void registerValidSpaceSuits() {
        validSpaceSuitHelmets.add(GSItems.SpacesuitHelmet);
        validSpaceSuitHelmets.add(GSItems.SpacesuitHelmetGlasses);
        validSpaceSuitChestPlates.add(GSItems.SpacesuitPlate);
        validSpaceSuitChestPlates.add(GSItems.SpacesuitJetPlate);
        validSpaceSuitLeggings.add(GSItems.SpacesuitLeg);
        validSpaceSuitBoots.add(GSItems.SpacesuitBoots);
        validSpaceSuitBoots.add(GSItems.SpacesuitGravityBoots);
        validSpaceSuitHelmets.add(Ic2Items.quantumHelmet.func_77973_b());
        validSpaceSuitChestPlates.add(Ic2Items.quantumBodyarmor.func_77973_b());
        validSpaceSuitLeggings.add(Ic2Items.quantumLeggings.func_77973_b());
        validSpaceSuitBoots.add(Ic2Items.quantumBoots.func_77973_b());
        if (Loader.isModLoaded((String)"EnderIO")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"EnderIO", (String)"item.stellar_helmet"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"EnderIO", (String)"item.stellar_chestplate"));
            validSpaceSuitLeggings.add(GameRegistry.findItem((String)"EnderIO", (String)"item.stellar_leggings"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"EnderIO", (String)"item.stellar_boots"));
        }
        if (Loader.isModLoaded((String)"EMT")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"EMT", (String)"SolarHelmetRevealing"));
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"EMT", (String)"QuantumGogglesRevealing"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"EMT", (String)"QuantumWing"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"EMT", (String)"itemArmorQuantumChestplate"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"EMT", (String)"QuantumBootsTraveller"));
        }
        if (Loader.isModLoaded((String)"WitchingGadgets")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"WitchingGadgets", (String)"item.WG_PrimordialHelm"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"WitchingGadgets", (String)"item.WG_PrimordialChest"));
            validSpaceSuitLeggings.add(GameRegistry.findItem((String)"WitchingGadgets", (String)"item.WG_PrimordialLegs"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"WitchingGadgets", (String)"item.WG_PrimordialBoots"));
        }
        if (Loader.isModLoaded((String)"AdvancedSolarPanel")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"AdvancedSolarPanel", (String)"hybrid_solar_helmet"));
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"AdvancedSolarPanel", (String)"ultimate_solar_helmet"));
        }
        if (Loader.isModLoaded((String)"TaintedMagic")) {
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"TaintedMagic", (String)"ItemVoidwalkerBoots"));
        }
        if (Loader.isModLoaded((String)"ThaumicTinkerer")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"ThaumicTinkerer", (String)"ichorclothHelmGem"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"ThaumicTinkerer", (String)"ichorclothChestGem"));
            validSpaceSuitLeggings.add(GameRegistry.findItem((String)"ThaumicTinkerer", (String)"ichorclothLegsGem"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"ThaumicTinkerer", (String)"ichorclothBootsGem"));
        }
        if (Loader.isModLoaded((String)"Avaritia")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"Avaritia", (String)"Infinity_Helm"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"Avaritia", (String)"Infinity_Chest"));
            validSpaceSuitLeggings.add(GameRegistry.findItem((String)"Avaritia", (String)"Infinity_Pants"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"Avaritia", (String)"Infinity_Shoes"));
        }
        if (Loader.isModLoaded((String)"GraviSuite")) {
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"GraviSuite", (String)"graviChestPlate"));
        }
        if (Loader.isModLoaded((String)"DraconicEvolution")) {
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"draconicHelm"));
            validSpaceSuitHelmets.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"wyvernHelm"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"draconicChest"));
            validSpaceSuitChestPlates.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"wyvernChest"));
            validSpaceSuitLeggings.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"draconicLeggs"));
            validSpaceSuitLeggings.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"wyvernLeggs"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"draconicBoots"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"DraconicEvolution", (String)"wyvernBoots"));
        }
        if (Loader.isModLoaded((String)"thaumicboots")) {
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemQuantumVoid"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemQuantumMeteor"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemQuantumComet"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemVoidMeteor"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemVoidComet"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemNanoVoid"));
            validSpaceSuitBoots.add(GameRegistry.findItem((String)"thaumicboots", (String)"item.ItemElectricVoid"));
        }
    }

    public static boolean isValidHelmet(ItemStack helmetStack) {
        if (helmetStack == null) {
            return false;
        }
        NBTTagCompound tag = helmetStack.func_77978_p();
        if (tag != null && tag.func_74767_n(FORCE_SPACE_SUIT_NBT_KEY)) {
            return true;
        }
        for (Item helmet : validSpaceSuitHelmets) {
            if (helmetStack.func_77973_b() != helmet) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidChestPlate(ItemStack chestPlateStack) {
        if (chestPlateStack == null) {
            return false;
        }
        NBTTagCompound tag = chestPlateStack.func_77978_p();
        if (tag != null && tag.func_74767_n(FORCE_SPACE_SUIT_NBT_KEY)) {
            return true;
        }
        for (Item chestPlate : validSpaceSuitChestPlates) {
            if (chestPlateStack.func_77973_b() != chestPlate) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidLeggings(ItemStack leggingsStack) {
        if (leggingsStack == null) {
            return false;
        }
        NBTTagCompound tag = leggingsStack.func_77978_p();
        if (tag != null && tag.func_74767_n(FORCE_SPACE_SUIT_NBT_KEY)) {
            return true;
        }
        for (Item leggings : validSpaceSuitLeggings) {
            if (leggingsStack.func_77973_b() != leggings) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidBoots(ItemStack bootsStack) {
        if (bootsStack == null) {
            return false;
        }
        NBTTagCompound tag = bootsStack.func_77978_p();
        if (tag != null && tag.func_74767_n(FORCE_SPACE_SUIT_NBT_KEY)) {
            return true;
        }
        for (Item boots : validSpaceSuitBoots) {
            if (bootsStack.func_77973_b() != boots) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.itemStack != null) {
            Item item = event.itemStack.func_77973_b();
            for (Item helmet : validSpaceSuitHelmets) {
                if (item != helmet) continue;
                event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + GCCoreUtil.translate((String)"tooltip.spacesuit"));
                return;
            }
            for (Item chestPlate : validSpaceSuitChestPlates) {
                if (item != chestPlate) continue;
                event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + GCCoreUtil.translate((String)"tooltip.spacesuit"));
                return;
            }
            for (Item leggings : validSpaceSuitLeggings) {
                if (item != leggings) continue;
                event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + GCCoreUtil.translate((String)"tooltip.spacesuit"));
                return;
            }
            for (Item boots : validSpaceSuitBoots) {
                if (item != boots) continue;
                event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + GCCoreUtil.translate((String)"tooltip.spacesuit"));
                return;
            }
        }
    }
}

