/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.ACentauriSystem.ACBlocks;
import galaxyspace.BarnardsSystem.BRBlocks;
import galaxyspace.VegaSystem.VegaBlocks;
import galaxyspace.core.register.GSBlocks;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityConverterSurface
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory {
    private static final int PROCESS_TIME_REQUIRED = 130;
    public static final ItemStack[] blocks = new ItemStack[]{new ItemStack(GSBlocks.MercuryBlocks), new ItemStack(GSBlocks.MercuryBlocks, 1, 1), new ItemStack(GSBlocks.MercuryBlocks, 1, 2), new ItemStack((Block)GSBlocks.VenusBlocks), new ItemStack((Block)GSBlocks.VenusBlocks, 1, 1), new ItemStack(GSBlocks.CeresBlocks), new ItemStack(GSBlocks.CeresBlocks, 1, 1), new ItemStack(GSBlocks.PlutoBlocks), new ItemStack(GSBlocks.PlutoBlocks, 1, 1), new ItemStack(GSBlocks.PlutoBlocks, 1, 2), new ItemStack(GSBlocks.PlutoBlocks, 1, 3), new ItemStack(GSBlocks.PlutoBlocks, 1, 4), new ItemStack(GSBlocks.PlutoBlocks, 1, 5), new ItemStack(GSBlocks.HaumeaBlocks), new ItemStack(GSBlocks.MakemakeBlocks), new ItemStack(GSBlocks.MakemakeBlocks, 1, 1), new ItemStack(GSBlocks.PhobosBlocks), new ItemStack(GSBlocks.PhobosBlocks, 1, 1), new ItemStack(GSBlocks.PhobosBlocks, 1, 2), new ItemStack(GSBlocks.DeimosBlocks), new ItemStack(GSBlocks.DeimosBlocks, 1, 1), new ItemStack(GSBlocks.IoBlocks), new ItemStack(GSBlocks.IoBlocks, 1, 1), new ItemStack(GSBlocks.IoBlocks, 1, 2), new ItemStack(GSBlocks.EuropaBlocks), new ItemStack(GSBlocks.GanymedeBlocks), new ItemStack(GSBlocks.GanymedeBlocks, 1, 1), new ItemStack(GSBlocks.CallistoBlocks), new ItemStack(GSBlocks.CallistoBlocks, 1, 1), new ItemStack(GSBlocks.EnceladusBlocks, 1, 1), new ItemStack(GSBlocks.TitanBlocks), new ItemStack(GSBlocks.TitanBlocks, 1, 1), new ItemStack(GSBlocks.TitanBlocks, 1, 2), new ItemStack(GSBlocks.OberonBlocks), new ItemStack(GSBlocks.OberonBlocks, 1, 1), new ItemStack(GSBlocks.OberonBlocks, 1, 2), new ItemStack(GSBlocks.ProteusBlocks), new ItemStack(GSBlocks.ProteusBlocks, 1, 1), new ItemStack(GSBlocks.ProteusBlocks, 1, 2), new ItemStack(GSBlocks.TritonBlocks), new ItemStack(GSBlocks.TritonBlocks, 1, 1), new ItemStack(GSBlocks.TritonBlocks, 1, 2), new ItemStack(ACBlocks.ACentauriBbGrunt), new ItemStack(ACBlocks.ACentauriBbSubGrunt), new ItemStack(BRBlocks.BarnardaCGrass), new ItemStack(BRBlocks.BarnardaCDirt), new ItemStack(VegaBlocks.VegaBGrunt), new ItemStack(VegaBlocks.VegaBSubGrunt)};
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(3000);
    private ItemStack[] containingItems = new ItemStack[6];
    private boolean initialised;

    public TileEntityConverterSurface() {
        this(1);
        this.initialised = true;
    }

    public TileEntityConverterSurface(int tier) {
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public void func_145845_h() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, GCBlocks.machineTiered, 4, 2);
            } else if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean isWater;
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && (isWater = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("water")) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(new FluidStack(FluidRegistry.WATER, liquid.amount), true);
                if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                    int amount = this.containingItems[1].field_77994_a;
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, (amount - 1) * 1000), true);
                    }
                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                } else {
                    ItemStack itemStack = this.containingItems[1];
                    --itemStack.field_77994_a;
                    if (this.containingItems[1].field_77994_a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        return this.waterTank.getFluidAmount() != 0 && this.containingItems[2] != null && this.containingItems[3] != null && this.containingItems[4] != null && (this.containingItems[5] == null || this.containingItems[5].field_77994_a + 1 <= 64);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack itemStack = this.containingItems[2];
            --itemStack.field_77994_a;
            ItemStack itemStack2 = this.containingItems[3];
            --itemStack2.field_77994_a;
            ItemStack itemStack3 = this.containingItems[4];
            --itemStack3.field_77994_a;
            if (this.containingItems[5] == null) {
                this.containingItems[5] = new ItemStack((Block)Blocks.field_150349_c);
            } else {
                ItemStack itemStack4 = this.containingItems[5];
                ++itemStack4.field_77994_a;
            }
            this.waterTank.drain(100, true);
            if (this.containingItems[2].field_77994_a == 0) {
                this.containingItems[2] = null;
            }
            if (this.containingItems[3].field_77994_a == 0) {
                this.containingItems[3] = null;
            }
            if (this.containingItems[4].field_77994_a == 0) {
                this.containingItems[4] = null;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 16000.0f) {
            this.storage.setEnergyStored(16000.0f);
        }
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.ConverterSurface.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        switch (index) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)stack.func_77973_b());
            }
            case 1: {
                return stack.func_77973_b() == Items.field_151131_as;
            }
            case 2: {
                return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15;
            }
            case 3: {
                return stack.func_77973_b() == Items.field_151014_N;
            }
        }
        return stack.func_77973_b() instanceof ITerraformableBlock || this.func_94041_b(index, stack);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean func_102007_a(int slotID, ItemStack item, int side) {
        return this.func_94041_b(slotID, item);
    }

    public boolean func_102008_b(int slotID, ItemStack item, int side) {
        return slotID == 5;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.startsWith("water")) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }
}

