/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.handlers;

import chylex.hee.api.message.MessageHandler;
import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.IntValue;
import chylex.hee.api.message.element.ItemPatternValue;
import chylex.hee.api.message.element.SpawnEntryValue;
import chylex.hee.api.message.element.StringValue;
import chylex.hee.api.message.element.WeightedLootValue;
import chylex.hee.api.message.handlers.ImcHandler;
import chylex.hee.api.message.utils.MessageLogger;
import chylex.hee.api.message.utils.RunEvent;
import chylex.hee.entity.block.EntityBlockHomelandCache;
import chylex.hee.system.util.ItemPattern;
import chylex.hee.world.loot.LootItemStack;
import chylex.hee.world.loot.WeightedLootList;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.IslandBiomeBurningMountains;
import chylex.hee.world.structure.island.biome.IslandBiomeEnchantedIsland;
import chylex.hee.world.structure.island.biome.IslandBiomeInfestedForest;
import chylex.hee.world.structure.island.biome.data.BiomeContentVariation;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.RavagedDungeonLoot;
import chylex.hee.world.structure.island.biome.feature.island.StructureHiddenCellar;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryContent;
import chylex.hee.world.structure.tower.ComponentTower;
import chylex.hee.world.util.SpawnEntry;
import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class ImcWorldHandlers
extends ImcHandler {
    private static final Map<String, WeightedLootList> lootNames = new HashMap<String, WeightedLootList>();
    private static final Map<String, Pair<IslandBiomeBase, BiomeContentVariation>> biomeNames = new HashMap<String, Pair<IslandBiomeBase, BiomeContentVariation>>();
    private static final StringValue lootName;
    private static final StringValue biomeName;
    private static final MessageHandler lootAdd;
    private static final MessageHandler lootRemove;
    private static final MessageHandler biomeMobAdd;

    @Override
    public void register() {
        this.register("HEE:World:LootAdd", lootAdd, RunEvent.LOADCOMPLETE).addProp("list", lootName).addProp("item", WeightedLootValue.any());
        this.register("HEE:World:LootRemove", lootRemove, RunEvent.LOADCOMPLETE).addProp("list", lootName).addProp("search", ItemPatternValue.any()).addProp("limit", IntValue.positiveOrZero());
        this.register("HEE:World:BiomeMobAdd", biomeMobAdd, RunEvent.LOADCOMPLETE).addProp("biome", biomeName).addProp("mob", SpawnEntryValue.any());
    }

    static {
        lootNames.put("DungeonTowerChest", ComponentTower.lootTower);
        lootNames.put("DungeonTowerFurnaceFuel", ComponentTower.lootFuel);
        lootNames.put("RavagedDungeonGeneral", RavagedDungeonLoot.lootGeneral);
        lootNames.put("RavagedDungeonUncommon", RavagedDungeonLoot.lootUncommon);
        lootNames.put("RavagedDungeonRare", RavagedDungeonLoot.lootRare);
        lootNames.put("RavagedDungeonFinalRoom", RavagedDungeonLoot.lootEnd);
        lootNames.put("HiddenCellarNormalHomeland", StructureHiddenCellar.normalChestVariation[0]);
        lootNames.put("HiddenCellarRareHomeland", StructureHiddenCellar.rareChestVariation[0]);
        lootNames.put("HiddenCellarNormalLaboratory", StructureHiddenCellar.normalChestVariation[1]);
        lootNames.put("HiddenCellarRareLaboratory", StructureHiddenCellar.rareChestVariation[1]);
        lootNames.put("HomelandCache", EntityBlockHomelandCache.loot);
        lootNames.put("LaboratorySmallChest", LaboratoryContent.smallChestLoot);
        lootNames.put("LaboratoryLargeChest", LaboratoryContent.largeChestLoot);
        biomeNames.put("InfestedForest.Deep", (Pair<IslandBiomeBase, BiomeContentVariation>)Pair.of((Object)IslandBiomeBase.infestedForest, (Object)IslandBiomeInfestedForest.DEEP));
        biomeNames.put("InfestedForest.Ravaged", (Pair<IslandBiomeBase, BiomeContentVariation>)Pair.of((Object)IslandBiomeBase.infestedForest, (Object)IslandBiomeInfestedForest.RAVAGED));
        biomeNames.put("BurningMountains.Scorching", (Pair<IslandBiomeBase, BiomeContentVariation>)Pair.of((Object)IslandBiomeBase.burningMountains, (Object)IslandBiomeBurningMountains.SCORCHING));
        biomeNames.put("BurningMountains.Mine", (Pair<IslandBiomeBase, BiomeContentVariation>)Pair.of((Object)IslandBiomeBase.burningMountains, (Object)IslandBiomeBurningMountains.MINE));
        biomeNames.put("EnchantedIsland.Homeland", (Pair<IslandBiomeBase, BiomeContentVariation>)Pair.of((Object)IslandBiomeBase.enchantedIsland, (Object)IslandBiomeEnchantedIsland.HOMELAND));
        biomeNames.put("EnchantedIsland.Laboratory", (Pair<IslandBiomeBase, BiomeContentVariation>)Pair.of((Object)IslandBiomeBase.enchantedIsland, (Object)IslandBiomeEnchantedIsland.LABORATORY));
        lootName = StringValue.function(new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return lootNames.containsKey(input);
            }
        });
        biomeName = StringValue.function(new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return biomeNames.containsKey(input);
            }
        });
        lootAdd = new MessageHandler(){

            @Override
            public void call(MessageRunner runner) {
                WeightedLootList list = (WeightedLootList)lootNames.get(runner.getString("list"));
                LootItemStack toAdd = (LootItemStack)runner.getValue("item");
                for (LootItemStack item : list) {
                    if (item.getItem() != toAdd.getItem()) continue;
                    MessageLogger.logFail("The item was already in the list.", new Object[0]);
                    return;
                }
                list.add(toAdd);
                MessageLogger.logOk("Added 1 item to the list.", new Object[0]);
            }
        };
        lootRemove = new MessageHandler(){

            @Override
            public void call(MessageRunner runner) {
                WeightedLootList list = (WeightedLootList)lootNames.get(runner.getString("list"));
                int limit = runner.getInt("limit");
                ItemPattern pattern = (ItemPattern)runner.getValue("search");
                pattern.setDamageValues(ArrayUtils.EMPTY_INT_ARRAY);
                pattern.setNBT(null);
                int size = list.size();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    if (!pattern.matches(new ItemStack(((LootItemStack)iter.next()).getItem()))) continue;
                    iter.remove();
                    if (limit <= 0 || --limit != 0) continue;
                }
                if ((size -= list.size()) == 0) {
                    MessageLogger.logWarn("Did not find any items to remove.", new Object[0]);
                } else {
                    MessageLogger.logOk("Removed $0 item(s).", size);
                }
            }
        };
        biomeMobAdd = new MessageHandler(){

            @Override
            public void call(MessageRunner runner) {
                Pair pair = (Pair)biomeNames.get(runner.getString("biome"));
                ((IslandBiomeBase)pair.getLeft()).getSpawnEntries((BiomeContentVariation)pair.getRight()).add((SpawnEntry)runner.getValue("mob"));
                MessageLogger.logOk("Added 1 entry to the list.", new Object[0]);
            }
        };
    }
}

