/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.block;

import chylex.hee.mechanics.enhancements.EnhancementEnumHelper;
import chylex.hee.mechanics.enhancements.types.TNTEnhancements;
import chylex.hee.system.util.BlockPosM;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityBlockEnhancedTNTPrimed
extends EntityTNTPrimed {
    private List<Enum> tntEnhancements = new ArrayList<Enum>();
    private boolean wentIntoWall = false;

    public EntityBlockEnhancedTNTPrimed(World world) {
        super(world);
        this.field_70516_a = 80;
        this.field_70129_M = 0.0f;
    }

    public EntityBlockEnhancedTNTPrimed(World world, double x, double y, double z, EntityLivingBase igniter, List<Enum> enhancements) {
        super(world, x, y, z, igniter);
        this.tntEnhancements.addAll(enhancements);
        if (this.tntEnhancements.contains(TNTEnhancements.NOCLIP)) {
            this.field_70145_X = true;
            this.field_70516_a = 40;
            this.field_70180_af.func_75692_b(16, (Object)1);
        }
        if (this.tntEnhancements.contains(TNTEnhancements.NO_FUSE)) {
            this.field_70516_a = 1;
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)"");
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.field_70180_af.func_75692_b(18, (Object)EnhancementEnumHelper.serialize(this.tntEnhancements));
        }
        if (this.field_70170_p.field_72995_K && !this.field_70145_X && this.field_70180_af.func_75683_a(16) == 1) {
            this.field_70145_X = true;
            this.field_70516_a = 40;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (!this.field_70170_p.field_72995_K && this.field_70145_X) {
            Block block = BlockPosM.tmp((Entity)this).getBlock((IBlockAccess)this.field_70170_p);
            if (!this.wentIntoWall && block.func_149662_c()) {
                this.wentIntoWall = true;
            } else if (this.wentIntoWall && block.func_149688_o() == Material.field_151579_a) {
                this.field_70516_a = 1;
                this.field_70180_af.func_75692_b(17, (Object)1);
            }
        }
        if (this.field_70122_E && !this.field_70145_X) {
            this.field_70159_w *= 0.7;
            this.field_70179_y *= 0.7;
            this.field_70181_x *= -0.5;
        }
        if (this.field_70516_a-- == 5 || this.field_70516_a == 0 && this.tntEnhancements.contains(TNTEnhancements.NO_FUSE)) {
            this.field_70180_af.func_75692_b(17, (Object)1);
        }
        if (this.field_70516_a <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void explode() {
        EnhancedTNTExplosion explosion = new EnhancedTNTExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.tntEnhancements.contains(TNTEnhancements.EXTRA_POWER) ? 5.2f : 4.0f);
        explosion.field_77286_a = this.tntEnhancements.contains(TNTEnhancements.FIRE);
        explosion.field_82755_b = !this.tntEnhancements.contains(TNTEnhancements.NO_BLOCK_DAMAGE);
        explosion.damageEntities = !this.tntEnhancements.contains(TNTEnhancements.NO_ENTITY_DAMAGE);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70128_L && this.field_70170_p.field_72995_K && this.field_70180_af.func_75683_a(17) == 1) {
            this.tntEnhancements = EnhancementEnumHelper.deserialize(this.field_70180_af.func_75681_e(18), TNTEnhancements.class);
            this.explode();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int par9) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("enhancements", EnhancementEnumHelper.serialize(this.tntEnhancements));
        nbt.func_74757_a("wentIntoWall", this.wentIntoWall);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.tntEnhancements = EnhancementEnumHelper.deserialize(nbt.func_74779_i("enhancements"), TNTEnhancements.class);
        this.wentIntoWall = nbt.func_74767_n("wentIntoWall");
    }

    private static final class EnhancedTNTExplosion
    extends Explosion {
        private final World worldObj;
        private final int dist = 16;
        private final Map<EntityPlayer, Vec3> hurtPlayers = new HashMap<EntityPlayer, Vec3>();
        public boolean damageEntities = true;

        public EnhancedTNTExplosion(World world, Entity sourceEntity, double x, double y, double z, float power) {
            super(world, sourceEntity, x, y, z, power);
            this.worldObj = world;
        }

        public void func_77278_a() {
            double tempZ;
            double tempY;
            double tempX;
            double totalDist;
            float explosionSizeBackup = this.field_77280_f;
            HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>();
            BlockPosM testPos = new BlockPosM();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                        double distX = (float)x / 15.0f * 2.0f - 1.0f;
                        double distY = (float)y / 15.0f * 2.0f - 1.0f;
                        double distZ = (float)z / 15.0f * 2.0f - 1.0f;
                        totalDist = Math.sqrt(distX * distX + distY * distY + distZ * distZ);
                        distX /= totalDist;
                        distY /= totalDist;
                        distZ /= totalDist;
                        tempX = this.field_77284_b;
                        tempY = this.field_77285_c;
                        tempZ = this.field_77282_d;
                        float mp = 0.3f;
                        for (float affectedDistance = this.field_77280_f * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); affectedDistance > 0.0f; affectedDistance -= mp * 0.75f) {
                            testPos.set(tempX, tempY, tempZ);
                            Block block = testPos.getBlock((IBlockAccess)this.worldObj);
                            if (block.func_149688_o() != Material.field_151579_a) {
                                float resistance = this.field_77283_e != null ? this.field_77283_e.func_145772_a((Explosion)this, this.worldObj, testPos.x, testPos.y, testPos.z, block) : block.getExplosionResistance(this.field_77283_e, this.worldObj, testPos.x, testPos.y, testPos.z, this.field_77284_b, this.field_77285_c, this.field_77282_d);
                                affectedDistance -= (resistance + 0.3f) * mp;
                            }
                            if (affectedDistance > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_145774_a((Explosion)this, this.worldObj, testPos.x, testPos.y, testPos.z, block, affectedDistance))) {
                                affectedBlocks.add(new ChunkPosition(testPos.x, testPos.y, testPos.z));
                            }
                            tempX += distX * (double)mp;
                            tempY += distY * (double)mp;
                            tempZ += distZ * (double)mp;
                        }
                    }
                }
            }
            this.field_77281_g.addAll(affectedBlocks);
            this.field_77280_f *= 2.0f;
            int minX = MathHelper.func_76128_c((double)(this.field_77284_b - (double)this.field_77280_f - 1.0));
            int maxX = MathHelper.func_76128_c((double)(this.field_77284_b + (double)this.field_77280_f + 1.0));
            int minY = MathHelper.func_76128_c((double)(this.field_77285_c - (double)this.field_77280_f - 1.0));
            int maxY = MathHelper.func_76128_c((double)(this.field_77285_c + (double)this.field_77280_f + 1.0));
            int minZ = MathHelper.func_76128_c((double)(this.field_77282_d - (double)this.field_77280_f - 1.0));
            int maxZ = MathHelper.func_76128_c((double)(this.field_77282_d + (double)this.field_77280_f + 1.0));
            List entities = this.worldObj.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            Vec3 locationVec = Vec3.func_72443_a((double)this.field_77284_b, (double)this.field_77285_c, (double)this.field_77282_d);
            for (int a = 0; a < entities.size(); ++a) {
                Entity entity = (Entity)entities.get(a);
                double entityDist = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)this.field_77280_f;
                if (!(entityDist <= 1.0) || (totalDist = (double)MathHelper.func_76133_a((double)((tempX = entity.field_70165_t - this.field_77284_b) * tempX + (tempY = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * tempY + (tempZ = entity.field_70161_v - this.field_77282_d) * tempZ))) == 0.0) continue;
                tempX /= totalDist;
                tempY /= totalDist;
                tempZ /= totalDist;
                double blastPower = (1.0 - entityDist) * (double)this.worldObj.func_72842_a(locationVec, entity.field_70121_D);
                if (this.damageEntities) {
                    entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((blastPower * blastPower + blastPower) / 2.0 * 8.0 * (double)this.field_77280_f + 1.0)));
                }
                double knockbackMp = EnchantmentProtection.func_92092_a((Entity)entity, (double)blastPower);
                entity.field_70159_w += tempX * knockbackMp;
                entity.field_70181_x += tempY * knockbackMp;
                entity.field_70179_y += tempZ * knockbackMp;
                if (!this.damageEntities || !(entity instanceof EntityPlayer)) continue;
                this.hurtPlayers.put((EntityPlayer)entity, Vec3.func_72443_a((double)(tempX * blastPower), (double)(tempY * blastPower), (double)(tempZ * blastPower)));
            }
            this.field_77280_f = explosionSizeBackup;
        }

        public Map func_77277_b() {
            return this.hurtPlayers;
        }
    }
}

