/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss;

import chylex.hee.entity.GlobalMobData;
import chylex.hee.entity.RandomNameGenerator;
import chylex.hee.entity.boss.AttackType;
import chylex.hee.entity.mob.util.DamageSourceMobUnscaled;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C07AddPlayerVelocity;
import chylex.hee.packets.client.C08PlaySound;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityLaserBeam;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityMiniBossEnderEye
extends EntityFlying
implements IBossDisplayData,
GlobalMobData.IIgnoreEnderGoo {
    private byte sleepTimer;
    private byte healTimer;
    private byte attackTimer;
    private short laserTopY;
    private AttackType attackType;
    private AttackType lastAttackType;
    public EntityLivingBase target;

    public EntityMiniBossEnderEye(World world) {
        super(world);
        this.func_70105_a(1.25f, 1.25f);
        this.field_70728_aV = 35;
        this.field_70744_aE = 25;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        RandomNameGenerator.generateEntityName((EntityLiving)this, this.field_70146_Z.nextInt(3) + 4);
    }

    public EntityMiniBossEnderEye(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)1);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModCommonProxy.opMobs ? 350.0 : 250.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.8);
    }

    protected void func_70626_be() {
        if (this.isAsleep()) {
            this.healTimer = (byte)(this.healTimer + 1);
            if (this.healTimer >= 7 - this.field_70170_p.field_73013_u.func_151525_a() && this.func_110143_aJ() < this.func_110138_aP()) {
                this.healTimer = 0;
                this.func_70691_i(1.0f);
            }
            this.sleepTimer = 0;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else if (this.target == null) {
            if (Math.abs(this.field_70159_w) > 0.0) {
                this.field_70159_w *= 0.25;
            }
            if (Math.abs(this.field_70181_x) > 0.0) {
                this.field_70181_x *= 0.25;
            }
            if (Math.abs(this.field_70179_y) > 0.0) {
                this.field_70179_y *= 0.25;
            }
            if ((this.sleepTimer = (byte)(this.sleepTimer + 1)) == 60) {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
            if (this.sleepTimer > 80) {
                this.setIsAsleep(true);
                this.setAttackAnimationTime((byte)0);
                this.attackType = null;
            } else {
                List nearPlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(8.0, 4.0, 8.0));
                if (!nearPlayers.isEmpty()) {
                    this.target = (EntityLivingBase)nearPlayers.get(0);
                    this.sleepTimer = 0;
                }
                this.attackTimer = (byte)(-65 + this.field_70146_Z.nextInt(15));
            }
        } else if (this.func_70068_e((Entity)this.target) < 60.0) {
            double diffX = this.field_70165_t - this.target.field_70165_t;
            double diffY = this.field_70163_u - (this.target.field_70163_u + (double)this.target.field_70131_O * 0.5);
            double diffZ = this.field_70161_v - this.target.field_70161_v;
            double distance = Math.sqrt(diffX * diffX + diffZ * diffZ);
            this.field_70177_z = DragonUtil.rotateSmoothly(this.field_70177_z, (float)MathUtil.toDeg(Math.atan2(diffZ, diffX)) - 270.0f, 6.0f);
            this.field_70125_A = DragonUtil.rotateSmoothly(this.field_70125_A, (float)(-MathUtil.toDeg(Math.atan2(diffY, distance))), 8.0f);
            byte attackAnim = this.getAttackAnimationTime();
            if (attackAnim == 0 && (this.attackTimer = (byte)(this.attackTimer - 1)) < -100) {
                this.attackTimer = (byte)(this.attackTimer + (38 + this.field_70146_Z.nextInt(20)));
                for (int attempt = 0; attempt < 3; ++attempt) {
                    this.attackType = AttackType.getById(this.field_70146_Z.nextInt(AttackType.values().length));
                    if (this.attackType != this.lastAttackType) break;
                }
                this.lastAttackType = this.attackType;
                this.setAttackAnimationTime((byte)1);
            } else if (attackAnim >= 1) {
                this.func_70657_f(0.0f);
                if (attackAnim < this.attackType.getLength()) {
                    this.setAttackAnimationTime((byte)(attackAnim + 1));
                } else {
                    this.setAttackAnimationTime((byte)0);
                }
                if (this.attackType == AttackType.Poof) {
                    if (attackAnim == 34) {
                        if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                            BlockPosM tmpPos = BlockPosM.tmp();
                            int hits = 0;
                            for (int a = 0; a < 200 && hits < 16 + this.field_70170_p.field_73013_u.func_151525_a(); ++a) {
                                Block block = tmpPos.set((Entity)this).move(this.field_70146_Z.nextInt(15) - 7, this.field_70146_Z.nextInt(8) - 4, this.field_70146_Z.nextInt(15) - 7).getBlock((IBlockAccess)this.field_70170_p);
                                if (block.func_149688_o() == Material.field_151579_a || block.func_149712_f(this.field_70170_p, tmpPos.x, tmpPos.y, tmpPos.z) == -1.0f) continue;
                                tmpPos.setAir(this.field_70170_p);
                                this.field_70170_p.func_72926_e(2001, tmpPos.x, tmpPos.y, tmpPos.z, Block.func_149682_b((Block)Blocks.field_150343_Z));
                                ++hits;
                            }
                        }
                        for (EntityPlayer player : this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0))) {
                            double[] vec = DragonUtil.getNormalizedVector(player.field_70165_t - this.field_70165_t, player.field_70161_v - this.field_70161_v);
                            boolean blocking = player.func_70632_aY();
                            vec[0] = vec[0] * (blocking ? 1.4 : 2.4);
                            vec[1] = vec[1] * (blocking ? 1.4 : 2.4);
                            PacketPipeline.sendToPlayer(player, new C07AddPlayerVelocity(vec[0], 0.34, vec[1]));
                            player.field_70159_w += vec[0];
                            player.field_70181_x += 0.34;
                            player.field_70179_y += vec[1];
                            player.func_70097_a((DamageSource)new DamageSourceMobUnscaled((Entity)this), DamageSourceMobUnscaled.getDamage(ModCommonProxy.opMobs ? 7.0f : 4.0f, this.field_70170_p.field_73013_u));
                        }
                        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C08PlaySound(0, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                } else if (this.attackType == AttackType.Nausea) {
                    if (attackAnim == 17) {
                        PotionEffect effNausea = new PotionEffect(Potion.field_76431_k.field_76415_H, 220, 0, true);
                        for (EntityPlayer player : this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0))) {
                            player.func_70690_d(effNausea);
                        }
                    } else if (attackAnim == 19) {
                        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C08PlaySound(1, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    } else if (attackAnim == 26) {
                        PotionEffect effBlind = new PotionEffect(Potion.field_76440_q.field_76415_H, 160, 0, true);
                        PotionEffect effSlow = new PotionEffect(Potion.field_76421_d.field_76415_H, 120, 0, true);
                        for (EntityPlayer player : this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0))) {
                            player.func_70690_d(effBlind);
                            player.func_70690_d(effSlow);
                        }
                    }
                } else if (this.attackType == AttackType.LaserBeams) {
                    if (attackAnim > 35 && attackAnim < 99 && attackAnim % 7 == 0) {
                        BlockPosM tmpPos = BlockPosM.tmp((Entity)this);
                        int myY = MathUtil.floor(this.field_70163_u);
                        for (int attempt = 0; attempt < 12; ++attempt) {
                            tmpPos.set(MathUtil.floor(this.field_70165_t) + this.field_70146_Z.nextInt(17) - 8, -1, MathUtil.floor(this.field_70161_v) + this.field_70146_Z.nextInt(17) - 8);
                            if (!tmpPos.setY(myY).isAir(this.field_70170_p)) continue;
                            tmpPos.y = myY;
                            while (tmpPos.y > myY - 6 && tmpPos.isAir(this.field_70170_p)) {
                                if (tmpPos.y == myY - 4) {
                                    tmpPos.y = -1;
                                    break;
                                }
                                --tmpPos.y;
                            }
                            if (tmpPos.y == -1) continue;
                            int minY = tmpPos.y;
                            if (this.laserTopY == 0) {
                                this.laserTopY = (short)(myY + 8);
                            }
                            tmpPos.y = minY + 1;
                            while (tmpPos.y < this.laserTopY && tmpPos.isAir(this.field_70170_p)) {
                                tmpPos.setBlock(this.field_70170_p, BlockList.laser_beam);
                                TileEntityLaserBeam beam = (TileEntityLaserBeam)tmpPos.getTileEntity((IBlockAccess)this.field_70170_p);
                                if (beam != null) {
                                    beam.setTicksLeft(102 - attackAnim);
                                }
                                ++tmpPos.y;
                            }
                            PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C08PlaySound(2, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.85f, this.field_70146_Z.nextFloat() * 0.1f + 0.95f));
                            break;
                        }
                    } else if (attackAnim == 102) {
                        this.laserTopY = 0;
                        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C08PlaySound(3, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    }
                }
            }
            if (attackAnim == 0) {
                double yD = this.field_70163_u + (double)(this.field_70131_O * 0.5f) - (this.target.field_70121_D.field_72338_b + (double)this.target.field_70131_O + 0.4);
                if (Math.abs(yD) >= 0.8) {
                    this.field_70181_x -= Math.abs(yD) * 0.005 * Math.signum(yD);
                }
                if (distance >= 3.0) {
                    this.func_70657_f((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                } else if (Math.abs(yD) < 1.0) {
                    this.target.func_70097_a((DamageSource)new DamageSourceMobUnscaled((Entity)this), DamageSourceMobUnscaled.getDamage(ModCommonProxy.opMobs ? 6.0f : 3.0f, this.field_70170_p.field_73013_u));
                }
                if (this.target.field_70128_L) {
                    this.target = null;
                }
            }
        } else {
            this.target = null;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar() || source == DamageSource.field_76368_d || source == DamageSource.field_76369_e || source == DamageSource.field_76367_g || source.func_76347_k() || source.func_82725_o() || source.func_76352_a()) {
            return false;
        }
        if (this.isAsleep()) {
            this.setIsAsleep(false);
            if (this.field_70170_p.field_73013_u.func_151525_a() > 1 || ModCommonProxy.opMobs) {
                BlockPosM tmpPos = BlockPosM.tmp();
                int hits = 0;
                for (int a = 0; a < 400 && hits < 5 + this.field_70170_p.field_73013_u.func_151525_a() * 10 + (ModCommonProxy.opMobs ? 30 : 0); ++a) {
                    float hardness;
                    tmpPos.set(this.field_70165_t + (double)this.field_70146_Z.nextInt(15) - 7.0, this.field_70163_u + (double)this.field_70146_Z.nextInt(8) - 4.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(15) - 7.0);
                    Block block = tmpPos.getBlock((IBlockAccess)this.field_70170_p);
                    if (block == Blocks.field_150350_a || (hardness = block.func_149712_f(this.field_70170_p, tmpPos.x, tmpPos.y, tmpPos.z)) == -1.0f || !(hardness <= 5.0f)) continue;
                    tmpPos.setAir(this.field_70170_p);
                    this.field_70170_p.func_72926_e(2001, tmpPos.x, tmpPos.y, tmpPos.z, Block.func_149682_b((Block)Blocks.field_150343_Z));
                    ++hits;
                }
            }
        }
        if (amount < 7.0f) {
            return true;
        }
        amount = 7.0f + Math.min((amount - 7.0f) * 0.5f, 5.0f);
        if (this.getAttackAnimationTime() > 0) {
            amount *= 0.275f;
        }
        if (super.func_70097_a(source, amount)) {
            CausatumUtils.increase(source, CausatumMeters.ENDER_EYE_DAMAGE, amount * 2.0f);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource source) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)source.func_76346_g()).func_71064_a((StatBase)AchievementManager.ENDER_EYE_KILL, 1);
        }
        super.func_70645_a(source);
    }

    public void func_70653_a(Entity entity, float damage, double xPower, double zPower) {
        this.field_70160_al = true;
        double dist = Math.sqrt(xPower * xPower + zPower * zPower);
        this.field_70159_w -= xPower / dist * 0.04;
        this.field_70181_x += 0.005;
        this.field_70179_y -= zPower / dist * 0.04;
        if (this.field_70181_x > 0.05) {
            this.field_70181_x = 0.05;
        }
    }

    public void func_70024_g(double xVelocity, double yVelocity, double zVelocity) {
        super.func_70024_g(xVelocity / 10.0, yVelocity / 10.0, zVelocity / 10.0);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_145779_a(Items.field_151061_bv, 1);
        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150343_Z), this.field_70146_Z.nextInt(4 + looting) + 3);
        this.func_145779_a(ItemList.spatial_dash_gem, 1);
    }

    public boolean func_70104_M() {
        return !this.isAsleep() || this.field_70125_A != 0.0f;
    }

    protected void func_82167_n(Entity entity) {
        if (this.func_70104_M()) {
            entity.func_70108_f((Entity)this);
        }
    }

    public void setIsAsleep(boolean isAsleep) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(isAsleep ? 1 : 0)));
    }

    public boolean isAsleep() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setAttackAnimationTime(byte time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public byte getAttackAnimationTime() {
        return this.field_70180_af.func_75683_a(17);
    }

    public boolean func_70601_bi() {
        return true;
    }

    protected String func_70639_aQ() {
        return this.isAsleep() ? null : "hardcoreenderexpansion:mob.endereye.living";
    }

    protected String func_70621_aR() {
        return "hardcoreenderexpansion:mob.endereye.hurt";
    }

    protected String func_70673_aS() {
        return "hardcoreenderexpansion:mob.endereye.death";
    }

    public float func_70599_aP() {
        return 0.75f;
    }

    public float func_70647_i() {
        return this.field_70146_Z.nextFloat() * 0.25f + 0.875f;
    }

    public String func_70005_c_() {
        return this.func_94056_bM() ? this.func_94057_bL() : StatCollector.func_74838_a((String)"entity.enderEye.name");
    }

    protected void func_70623_bb() {
    }
}

