/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.DamageTakenEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.commands.DebugBoard;
import chylex.hee.system.util.DragonUtil;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class DragonAttackDefault
extends DragonSpecialAttackBase {
    private byte targetCooldown;
    private int nextTargetTimer = 100;
    private EntityPlayer overrideTarget;
    private boolean isOverriding;
    private TObjectByteHashMap<UUID> seesDragon = new TObjectByteHashMap();
    private byte seesCheck;
    private boolean stealthInProgress;

    public DragonAttackDefault(EntityBossDragon dragon, int attackId) {
        super(dragon, attackId, -1);
    }

    @Override
    public void init() {
        super.init();
        this.targetCooldown = (byte)70;
    }

    @Override
    public void update() {
        ++this.tick;
        if (!(this.stealthInProgress || this.dragon.target != null || this.targetCooldown != 0 && (this.targetCooldown = (byte)(this.targetCooldown - 1)) != 0)) {
            int healthPerc = this.dragon.attacks.getHealthPercentage();
            int viablePlayers = this.dragon.attacks.getViablePlayers().size();
            int attackChance = Math.min(170, (this.dragon.angryStatus ? 45 : 5) + this.getDifficulty() * 5 + Math.min(viablePlayers, 5) * 14 + (ModCommonProxy.opMobs ? 10 : 0) + (50 - (healthPerc >> 1)));
            if (this.nextTargetTimer < 80 && this.rand.nextInt(260 - attackChance) == 0 || this.nextTargetTimer <= 0 || --this.nextTargetTimer <= 0) {
                this.nextTargetTimer = 150 + this.rand.nextInt(40) + (healthPerc >> 2) + (this.dragon.angryStatus ? 0 : 35) - this.getDifficulty() * 6 - Math.min(this.dragon.field_70170_p.field_73010_i.size(), 5) * 5;
                this.dragon.trySetTarget(this.dragon.attacks.getRandomPlayer());
            }
            DebugBoard.updateValue("TargetChance", 260 - attackChance);
            DebugBoard.updateValue("NextTargetTimer", this.nextTargetTimer);
        }
        if (!this.dragon.angryStatus) {
            if (!this.stealthInProgress && (this.seesCheck = (byte)(this.seesCheck + 1)) > 20 && this.dragon.target == null) {
                for (EntityPlayer player : this.dragon.field_70170_p.field_73010_i) {
                    UUID id = player.func_110124_au();
                    if (this.getVision((EntityLivingBase)this.dragon, (EntityLivingBase)player) && this.seesDragon.adjustOrPutValue((Object)id, (byte)1, (byte)1) > 4 + (this.getDifficulty() >> 1)) {
                        this.overrideTarget = player;
                        this.stealthInProgress = true;
                        this.isOverriding = true;
                        this.seesDragon.clear();
                        break;
                    }
                    this.seesDragon.remove((Object)id);
                }
                this.seesCheck = 0;
            } else if (this.stealthInProgress && this.overrideTarget != null && this.seesCheck % 3 == 0 && this.dragon.dragonPartHead.func_70068_e((Entity)this.overrideTarget) < 27.0) {
                this.dragon.attacks.biteClosePlayers();
                this.stealthInProgress = false;
                this.isOverriding = false;
                this.overrideTarget = null;
                this.dragon.rewards.addHandicap(0.3f, false);
            }
        } else {
            this.stealthInProgress = false;
        }
        if (this.stealthInProgress && !this.isPassiveAttackDisabled((byte)0)) {
            this.setDisabledPassiveAttacks(0);
        } else if (!this.stealthInProgress && this.isPassiveAttackDisabled((byte)0)) {
            this.setDisabledPassiveAttacks(new byte[0]);
        }
    }

    @Override
    public boolean canStart() {
        return false;
    }

    private boolean getVision(EntityLivingBase target, EntityLivingBase vision) {
        return DragonUtil.canEntitySeePoint(vision, target.field_70165_t, target.field_70163_u, target.field_70161_v, 16.0);
    }

    @Override
    public boolean hasEnded() {
        return true;
    }

    @Override
    public void onDamageTakenEvent(DamageTakenEvent event) {
        super.onDamageTakenEvent(event);
        this.nextTargetTimer = (int)((float)this.nextTargetTimer - event.damage);
    }

    @Override
    public int getNextAttackTimer() {
        return 220 + this.rand.nextInt(70) + (4 - this.getDifficulty()) * 15;
    }

    @Override
    public float overrideMovementSpeed() {
        return this.dragon.target != null ? 1.5f : 1.0f;
    }

    @Override
    public float overrideWingSpeed() {
        return 1.0f;
    }

    @Override
    public void onTargetSetEvent(TargetSetEvent event) {
        if (this.isOverriding) {
            event.newTarget = this.overrideTarget;
        }
    }

    @Override
    public void onTargetPositionSetEvent(TargetPositionSetEvent event) {
        if (this.isOverriding) {
            event.cancel();
        }
    }
}

