/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.event.CollisionEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.DamageTakenEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.MotionUpdateEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.system.collections.weight.IWeightProvider;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.ArrayUtils;

public abstract class DragonSpecialAttackBase
implements IWeightProvider {
    protected EntityBossDragon dragon;
    protected Random rand;
    protected float damageTaken;
    protected float damageDealt;
    protected TObjectFloatHashMap<UUID> lastPlayerHealth = new TObjectFloatHashMap();
    protected int tick;
    protected byte phase;
    private final short weight;
    private byte[] disabledPassiveAttacks = ArrayUtils.EMPTY_BYTE_ARRAY;
    public final byte id;

    public DragonSpecialAttackBase(EntityBossDragon dragon, int attackId, int weight) {
        this.dragon = dragon;
        this.rand = dragon.field_70170_p.field_73012_v;
        this.id = (byte)attackId;
        this.weight = (short)weight;
    }

    public DragonSpecialAttackBase setDisabledPassiveAttacks(byte ... attackIds) {
        this.disabledPassiveAttacks = attackIds;
        return this;
    }

    public boolean isPassiveAttackDisabled(byte attackId) {
        return ArrayUtils.contains((byte[])this.disabledPassiveAttacks, (byte)attackId);
    }

    public void init() {
        this.tick = 0;
        this.phase = 0;
        this.damageTaken = 0.0f;
        this.damageDealt = 0.0f;
        this.lastPlayerHealth.clear();
        this.updatePlayerHealth();
    }

    public void update() {
        ++this.tick;
        this.updatePlayerHealth();
    }

    public void end() {
    }

    public boolean canStart() {
        return true;
    }

    protected void updatePlayerHealth() {
        for (EntityPlayer player : this.dragon.field_70170_p.field_73010_i) {
            UUID id = player.func_110124_au();
            if (this.lastPlayerHealth.containsKey((Object)id)) {
                float last = this.lastPlayerHealth.get((Object)id);
                if (player.func_110143_aJ() < last) {
                    this.damageDealt += last - player.func_110143_aJ();
                }
            }
            this.lastPlayerHealth.put((Object)id, player.func_110143_aJ());
        }
    }

    public final void onDamageTaken(float damage) {
        this.damageTaken += damage;
    }

    public abstract boolean hasEnded();

    public int getNextAttackTimer() {
        return Math.max(140, 220 + this.rand.nextInt(140) + (4 - this.getDifficulty()) * 30 - Math.min(60, this.dragon.field_70170_p.field_73010_i.size() * 10));
    }

    public float overrideMovementSpeed() {
        return 1.0f;
    }

    public float overrideWingSpeed() {
        return 1.0f;
    }

    public void onDamageTakenEvent(DamageTakenEvent event) {
    }

    public void onMotionUpdateEvent(MotionUpdateEvent event) {
    }

    public void onTargetSetEvent(TargetSetEvent event) {
    }

    public void onTargetPositionSetEvent(TargetPositionSetEvent event) {
    }

    public void onCollisionEvent(CollisionEvent event) {
    }

    protected final int getDifficulty() {
        return this.dragon.field_70170_p.field_73013_u.func_151525_a();
    }

    @Override
    public final int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        return o instanceof DragonSpecialAttackBase && ((DragonSpecialAttackBase)o).id == this.id;
    }

    public boolean equals(DragonSpecialAttackBase attack) {
        return attack != null && attack.id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

